#ifndef __TYPES_INCLUDED
#define __TYPES_INCLUDED

/******** Definition of items with uniquely size **********
(c) 1997-2000 Jaroslav Fojtik
   if you don't use below mentionted compiler, please correct this items
   for your compiler and send me your correction to:
			fojtik@htc.honeywell.cz  or  fojtik@penguin.cz

List of supported types:

   Type  Alternate  Size & Description
   -----+---------+------+---------------------
   __u8   BYTE     1 byte  =  8 bit
   __s8   SBYTE    1 byte  =  8 bit signed
   __u16  WORD     2 bytes = 16 bit
   __s16  SWORD    2 bytes = 16 bit signed
   __u32  DWORD    4 bytes = 32 bit
   __s32  SDWORD   4 bytes = 32 bit signed

***************************************************************/
#ifndef __Common_H_INCLUDED
  #include <common.h>
#endif


#define CF_LE_u16(v) (v)
#define CT_LE_u16(v) (v)
#define C_ST_u16(p,v) {*(((__u16*)p)++)=v;}
#define C_LD_u16(p,v) {v=*(((__u16*)p)++);}


#ifdef __BORLANDC__
 #ifdef __OS2__
   #define __u8    unsigned char
   #define __s8    signed char
   #define __u16   unsigned short int
   #define __s16   signed short int
   #define __u32   unsigned long int
   #define __s32   signed long int
 #else
   #define __u8    unsigned char
   #define __s8    signed char
   #define __u16   unsigned int
   #define __s16   signed int
   #define __u32   unsigned long int
   #define __s32   signed long int
 #endif
#else  /* __BORLANDC__ */


#if defined(__EGC__) || defined(__GNUC__)
 #define	PACKED	 __attribute__((aligned(1))) __attribute__((packed))

 #ifdef __DJGPP__
  #define __u8    unsigned char
  #define __s8    signed char
  #define __u16   unsigned short int
  #define __s16   signed short int
  #define __u32   unsigned int
  #define __s32   signed int
 #else  /* __DJGPP__ */

  #ifndef __UNIX__
    #define __UNIX__
  #endif

  #ifdef __EMX__
    #define __u8    unsigned char
    #define __s8    signed char
    #define __u16   unsigned short int
    #define __s16   signed short int
    #define __u32   unsigned int
    #define __s32   signed int
  #else  /* __EMX__ */

  #ifdef sun
   #define __u8    unsigned char
   #define __s8    signed char
   #define __u16   unsigned short int
   #define __s16   signed short int
   #define __u32   unsigned int
   #define __s32   signed int
  #else  /* sun */
    #include <unistd.h>
    /* _ux constants are preddefined in this header */
  #endif  /* sun */
  #endif  /* __EMX__ */
 #endif  /* __DJGPP__ */

#else  /* __GNUC__ */

#ifdef __WATCOMC__
 #ifdef __386__
  #define __u8    unsigned char
  #define __s8    signed char
  #define __u16   unsigned short int
  #define __s16   signed short int
  #define __u32   unsigned int
  #define __s32   signed int
 #else
  #define __u8    unsigned char
  #define __s8    signed char
  #define __u16   unsigned int
  #define __s16   signed int
  #define __u32   unsigned long int
  #define __s32   signed long int
 #endif
#else /*__WATCOMC__*/

#ifdef __HPUXC__
 #define __u8	unsigned char
 #define __s8	signed char
 #define __u16	unsigned short int
 #define __s16	signed short int
 #define __u32	unsigned int
 #define __s32	signed int
#else

/* Here you may include your definition for other C */
#endif
#endif
#endif
#endif


#ifndef __u8
 #define __u8    unsigned char
 #define __s8    signed char
 #define __u16   unsigned short
 #define __s16   signed short
 #define __u32   unsigned long int
 #define __s32   signed long int
#endif

#ifndef BYTE
 #define BYTE    __u8
 #define SBYTE   __s8
 #define WORD    __u16
 #define SWORD   __s16
 #define DWORD   __u32
 #define SDWORD  __s32
#endif


#define Read_u16(v) ((WORD *)v)
#define Read_u32(v) ((DWORD *)v)


#ifndef PACKED
 #define	PACKED		/*default definition of packed - nothing*/
#endif
/*#define PackedArrays		//arrays are not continuous*/


#endif
/* End of Header Types.h */
