/**************************************************
* unit:    strings           release 0.8          *
* purpose: general manipulation with text strings *
***************************************************/
#ifndef __Strings_h
#define __Strings_h

#ifndef __Common_H_INCLUDED
  #include <common.h>
#endif

#ifdef __string_already_used
  #define string bbstring
#endif

#ifndef toupper
 #include <ctype.h>
#endif

#define StringsId  0x100
#define Bad_Length   0x1
#define Bad_MaxLen   0x2
#define Wrong_String 0x3
#define Unterminated 0x4
#define No_Memory    0x5

#ifndef IN
 #define IN %
#endif

int StrCmp(const char *str1,const char *str2);
#ifdef __Strict_Const_Procs
char *StrStr(char *str1,char *str2);
const char *StrStr(const char *str1,const char *str2);
#else
char *StrStr(const char *str1,const char *str2);
#endif

struct oldstring{
	char *ch;
	};

extern "C++" {

// Main definition part of Class String
class string:private oldstring {
	      void resize(int NewMaxlen);
	      string(int len);
   private:   int maxlen;
	      int size;
	      static char Dummy;
   public:    string(void) {size=maxlen=0;ch=0;};
	      string(char c);

	      string(const char *str);
	      string(const string &s);
	      string(const char *str,int i);
	      ~string(void)				{erase();};
	      char *operator()() const    		{ return ch; }
	      operator char *() const			{ return ch; }
	      string &operator=(char c);
	      string &operator=(const char *str);
	      string &operator=(const string &s);
	      string &operator=(int c)		        {*this=(char)c;return *this;};
              string &operator=(long c)		        {*this=(char)c;return *this;};

	      inline char &operator[](const int i) const {if(i>=size) return(Dummy=0); return(ch[i]);}
	      inline char *operator IN(const string &s) const {return(StrStr(s.ch, ch));}

	      int operator==(char c) const		{return(!ChStrCmp(c,*this));}
	      int operator!=(char c) const		{return(ChStrCmp(c,*this));}
	      int operator>(char c) const 	        {return(ChStrCmp(*this,c)>0);}
	      int operator<(char c) const		{return(ChStrCmp(*this,c)<0);}
	      int operator>=(char c) const		{return(ChStrCmp(*this,c)>=0);}
	      int operator<=(char c) const		{return(ChStrCmp(*this,c)<=0);}

	      int operator==(const string &s) const	{return(!StrCmp(ch,s.ch));}
	      int operator!=(const string &s) const	{return(StrCmp(ch,s.ch));}
	      int operator>(const string &s) const	{return(StrCmp(ch,s.ch)>0);}
	      int operator<(const string &s) const	{return(StrCmp(ch,s.ch)<0);}
	      int operator>=(const string &s) const	{return(StrCmp(ch,s.ch)>=0);}
	      int operator<=(const string &s) const	{return(StrCmp(ch,s.ch)<=0);}

	      int operator==(const char *str) const	{return(!StrCmp(ch,str));}
	      int operator!=(const char *str) const	{return(StrCmp(ch,str));}
	      int operator>(const char *str) const	{return(StrCmp(ch,str)>0);}
	      int operator<(const char *str) const	{return(StrCmp(ch,str)<0);}
	      int operator>=(const char *str) const	{return(StrCmp(ch,str)>=0);}
	      int operator<=(const char *str) const 	{return(StrCmp(ch,str)<=0);}

	      string &ToUpper(void);
	      string &ToLower(void);
	      void erase(void);

	      friend string operator+(const string & s1, const char *str);
	      friend string operator+(const string & s1, const string & s2);
	      friend string operator+(const char *str, const string & s2);
	      friend string operator+(const string & s, char c);
	      friend string operator+ (char c, const string & s);
	      friend string operator*(const string& s, unsigned n);
	      friend string & append(string & s1, char c);
	      friend string & append(string & s1, const char *str);
	      friend string & append(string & s1, const string & s2);
	      string & operator+=(char c)		{return append(*this,c);};
	      string & operator+=(const char *str)	{return append(*this,str);};
	      string & operator+=(const string &s)	{return append(*this,s);};

	      friend int ChStrCmp(char c, const string & s);  //-1  c<s  0 c==s  1 c>s
	      friend int ChStrCmp(const string & s,char c) {return(-ChStrCmp(c,s));};  //-1  c>s  0 c==s  1 c<s
	      friend int length(const string &s) {return(s.size);}

	      friend int sync(string &s);
	      friend void erase(string &s)	{s.erase();};

//Overloading of well known C string functions
	      friend string del(const string &s,int from, int len=1);
	      friend string insert(const string &s,const string &s2,int position);
	      inline char *strstr(const string &s1,const string &s2) {return(StrStr(s1.ch,s2.ch));};
	      inline const char *strstr(const string &s1,const char *str2) {return(StrStr(s1.ch,str2));};
	      inline const char *strstr(const char *str1,const string &s2) {return(StrStr(str1,s2.ch));};
	      inline int strcmp(const string &s1,const string &s2) {return(StrCmp(s1.ch,s2.ch));};
	      inline int strcmp(const string &s1,const char *str2) {return(StrCmp(s1.ch,str2));};
	      inline int strcmp(const char *str1,const string &s2) {return(StrCmp(str1,s2.ch));};
	      friend int strlen(const string &s) {return(s.size);}
	      };


//Related functions to the class string
string copy(const string &s,int from, int len);
string cutspaces(const string & s);
string replacesubstring(const string & s, const string & substring, const string & newsubstring );
string ToUpper(const char *str);
string ToLower(const char *str);

} // extern "C++"

#endif
