#ifndef __sets
#define __sets

#include <limits.h>

#include <types.h>
#ifdef __UniX
 #include <unistd.h>
#endif


#define SetsId     0x200
#define Bad_Bounds   0x1
#define Bad_MaxBound 0x2
#define Bad_MinBound 0x3
#define Wrong_Set    0x4
#define No_Memory    0x5

#ifndef IN
 #define IN %
#endif
#define TrickInterval INT_MIN
#define ___ ,TrickInterval,

#ifndef min
 #define min(value1,value2) ((value1 < value2) ? value1 : value2)
#endif
#ifndef max
 #define max(value1,value2) ((value1 > value2) ? value1 : value2)
#endif


// Main definition part of Class set
class set  {
public: //////////////////!!!!!!!!!!!!!
	      __u16 *data;
	      int MinElement,MaxElement;
              void resize(int MinElement,int MaxElement);

              set(int Min,int Max);
	      public:

	      set(void);
	      set(int number);
              set(const set & s);
              set(int *Array, int Size);
	      ~set(void)				{erase(*this);};

	      set &operator=(const set &s);

              int operator IN (const set &s) const;
              int operator[](int i) const;

	      int operator==(const set &s) const;
	      int operator!=(const set &s) const	{return(!(*this==s));}
              int operator>(const set &s) const		{return(Card(*this)>Card(s));}
              int operator>=(const set &s) const	{return(Card(*this)>=Card(s));}
              int operator<(const set &s) const		{return(Card(*this)<Card(s));}
              int operator<=(const set &s) const	{return(Card(*this)<=Card(s));}

              friend set operator+(const set & s1, const set & s2);
              friend set operator|(const set & s1, const set & s2) {return s1 + s2;}
              friend set operator-(const set & s1, const set & s2);
              friend set operator&(const set & s1, const set & s2);
              friend set operator^(const set & s1, const set & s2);
              set &operator+=(const set & s2)   	{return *this=*this+s2;}
              set &operator|=(const set & s2)   	{return *this=*this+s2;}
              set &operator-=(const set & s2)   	{return *this=*this-s2;}
              set &operator&=(const set & s2)   	{return *this=*this&s2;}
              set &operator^=(const set & s2)   	{return *this=*this^s2;}

              friend char *set2str(char *str,const set &s);
              friend char *str2set(char *str,const set &s);
              friend int Card(const set &s);
	      friend int EmptyCheck(const set &s);

              friend void erase(set &s);
              friend int sync(set &s);
	      };

char *set2str(char *str,const set &s);

#endif