/*
 * Created on 14-Apr-2004
 */
package jmemorize.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * @author djemili
 */
public class TimeSpan
{
    public final static long MINUTE = 60 * 1000;
    public final static long HOUR   = 60 * MINUTE;
    public final static long DAY    = 24 * HOUR;
    
//  TODO. get locale from program settings
    private static DateFormat  m_longDateFormater = 
        DateFormat.getDateTimeInstance(DateFormat.FULL,  DateFormat.LONG, Locale.GERMAN);//TODO locale      
    
    private long m_ticks;
    
    public TimeSpan(Date from, Date to)
    {
        m_ticks = to.getTime() - from.getTime();
    }
    
    public long getDays()
    {
        return m_ticks / DAY;
    }
    
    public int getHours()
    {
        return (int)((m_ticks % DAY) / HOUR);
    }
    
    public int getMinutes()
    {
        return (int)((m_ticks % HOUR) / MINUTE);
    }
    
    public long getTicks()
    {
        return m_ticks;
    }
    
    public static String format(Date dateNow, Date dateOther)
    {
        TimeSpan span = new TimeSpan(dateNow, dateOther);
        StringBuffer result = new StringBuffer();
        
        if (span.getTicks() >= 0)
        {
            result.append("in ");
        }
        
        // if one or more days left
        if (Math.abs(span.getDays()) >= 1)
        {
            result.append(Math.abs(span.getDays()) + " day");
            
            if (Math.abs(span.getDays()) > 1)
            {
                result.append("s");
            }
        }
        // if today
        else
        {
            if (Math.abs(span.getHours()) >= 1)
            {
                result.append(Math.abs(span.getHours()) + " hour");
                
                if (Math.abs(span.getHours()) > 1)
                {
                    result.append("s");
                }
            }
            // if less then one hour left
            else
            {
                result.append(Math.abs(span.getMinutes()) + " minute");
                
                if (Math.abs(span.getMinutes()) != 1) //CHECK
                {
                    result.append("s");
                }
            }
        }
        
        if (span.getTicks() < 0)
        {
            result.append(" ago");
        }
        
        return result.toString();
    }
}
