/*
 * Created on Dec 30, 2004
 */
package jmemorize.gui.swing;

import java.awt.BorderLayout;
import java.util.Iterator;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import jmemorize.core.Card;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author djemili
 */
public class StatusBar extends JPanel
{
    private JLabel m_leftLabel  = new JLabel();
    private JLabel m_rightLabel = new JLabel();
    
    public StatusBar()
    {
        setLayout(new BorderLayout());
        add(buildStatusBar(), BorderLayout.CENTER);
    }
    
    public void setLeftText(String text)
    {
        m_leftLabel.setText(text);
    }
    
    public void setCards(List cards)
    {
        int unlearned = 0;
        int learned = 0;
        int expired = 0;
        
        for (Iterator it = cards.iterator(); it.hasNext();)
        {
            Card card = (Card)it.next();
            
            if (card.isUnlearned())
            {
                unlearned++;
            }
            else if (card.isLearned())
            {
                learned++;
            }
            else //if (card.isExpired())
            {
                expired++;
            }
        }
        
        m_rightLabel.setText("Cards: "+ cards.size() +" (Unlearned: "+ unlearned +
            "  Expired: "+ expired +"  Learned: "+ learned +")"); 
    }
    
    private JPanel buildStatusBar()
    {
        FormLayout layout = new FormLayout(
            "3dlu, p, 9dlu:grow, p, 3dlu", // columns
            "p"); // rows
        
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(new EmptyBorder(4, 5, 2, 5));
        
        builder.add(m_leftLabel,   cc.xy(2,1));
        builder.add(m_rightLabel,           cc.xy(4,1));
        
        return builder.getPanel();
    }

}
