///*
// * Created on Dec 23, 2004
// */
//package jmemorize.gui.swing;
//
//import java.awt.BorderLayout;
//import java.awt.CardLayout;
//
//import javax.swing.JButton;
//import javax.swing.JList;
//import javax.swing.JPanel;
//import javax.swing.ListSelectionModel;
//import javax.swing.border.EmptyBorder;
//import javax.swing.border.EtchedBorder;
//import javax.swing.event.ListSelectionEvent;
//import javax.swing.event.ListSelectionListener;
//
//import jmemorize.core.Main;
//import jmemorize.util.EscapableFrame;
//
//import com.jgoodies.forms.builder.DefaultFormBuilder;
//import com.jgoodies.forms.factories.ButtonBarFactory;
//import com.jgoodies.forms.layout.CellConstraints;
//import com.jgoodies.forms.layout.FormLayout;
//
///**
// * @author djemili
// */
//public class PreferencesFrame extends EscapableFrame
//{
//    private static final String[] PANEL_NAMES = new String[] {
//        "General", "Learning", "Scheduling"
//    };
//    
//    private Main               m_main;
//    private MainFrame          m_frame;
//    private LearnSettingPanels m_learnSettingsPanels;
//    
//    private JPanel             m_settingsPanel  = new JPanel(new CardLayout());
//    private JButton            m_applyButton    = new JButton("Apply");
//    private JList              m_sideList       = new JList(PANEL_NAMES);
//    
//    public PreferencesFrame(Main main, MainFrame frame)
//    {
//        m_main = main;
//        m_frame = frame;
//        m_learnSettingsPanels = new LearnSettingPanels(m_main.getStrategy());
//        
//        // init components
//        getContentPane().add(buildMainPanel(), BorderLayout.CENTER);
//        getContentPane().add(buildButtonBar(), BorderLayout.SOUTH);
//        
//        setTitle("Preferences");
//        pack();
//        
//        setLocationRelativeTo(null);
//        setVisible(true);
//    }
//    
//    public boolean close()
//    {
//        m_frame.onPreferencesFrameClosed();
//        dispose();
//        
//        return true;
//    }    
//    
//    private JPanel buildMainPanel()
//    {
//        // build side list
//        m_sideList.setBorder(new EtchedBorder());
//
//        m_sideList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
//        m_sideList.addListSelectionListener(new ListSelectionListener() {
//            public void valueChanged(ListSelectionEvent e)
//            {
//                CardLayout layout = (CardLayout)m_settingsPanel.getLayout();
//                layout.show(m_settingsPanel, PANEL_NAMES[m_sideList.getSelectedIndex()]);
//            }
//        });
//        m_sideList.setSelectedIndex(0);
//        
//        // build settings panel
//        m_settingsPanel.add(buildGeneralSettingsPanel(),                PANEL_NAMES[0]);
////        m_settingsPanel.add(m_learnSettingsPanels.getGeneralPanel(),    PANEL_NAMES[1]);
////        m_settingsPanel.add(m_learnSettingsPanels.getSchedulingPanel(), PANEL_NAMES[2]);
//        m_settingsPanel.setBorder(new EtchedBorder());
//        
//        // build main panel
//        FormLayout layout = new FormLayout(
//            "70dlu, 3dlu, p:grow", // columns
//            "fill:p:grow"); // rows
//        
//        CellConstraints cc = new CellConstraints();
//        
//        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
//        builder.setDefaultDialogBorder();
//        
//        builder.add(m_sideList,      cc.xy(1,1));
//        builder.add(m_settingsPanel, cc.xy(3,1));
//        
//        return builder.getPanel();
//    }
//    
//    private JPanel buildGeneralSettingsPanel()
//    {
//        FormLayout layout = new FormLayout(
//            "p:grow", // columns
//            "p"); // rows
//        
//        CellConstraints cc = new CellConstraints();
//        
//        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
//        builder.setDefaultDialogBorder();
//        
//        builder.addSeparator("General Settings", cc.xy(1, 1));
//        return builder.getPanel();
//    }
//
//    
//    private JPanel buildButtonBar()
//    {
//        JButton okayButton = new JButton("Okay"); 
//        okayButton.addActionListener(new java.awt.event.ActionListener() {
//            public void actionPerformed(java.awt.event.ActionEvent evt) {
//                apply();
//                close();
//            }
//        });
//        
//        JButton cancelButton = new JButton("Cancel"); 
//        cancelButton.addActionListener(new java.awt.event.ActionListener() {
//            public void actionPerformed(java.awt.event.ActionEvent evt) {
//                close();
//            }
//        });
//        
//        m_applyButton.addActionListener(new java.awt.event.ActionListener() {
//            public void actionPerformed(java.awt.event.ActionEvent evt) {
//                apply();
//            }
//        });
//        
//        JPanel buttonPanel = ButtonBarFactory.buildOKCancelApplyBar(okayButton, cancelButton, m_applyButton);
//        buttonPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
//        
//        getRootPane().setDefaultButton(okayButton);
//        
//        return buttonPanel;
//    }
//    
//    private void apply()
//    {
//        m_learnSettingsPanels.applySettings();
//        m_main.getStrategy().storeToPreferences();
//    }
//}
