/*
 * Created on Dec 23, 2004
 */
package jmemorize.gui.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;

import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import jmemorize.core.Category;
import jmemorize.strategy.Strategy;
import jmemorize.util.EscapableFrame;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author djemili
 */
public class LearnSettingsFrame extends EscapableFrame
{
    private static final String[] PANEL_NAMES = new String[] {
        "General", "Advanced", "Scheduling"
    };
    
    private Strategy           m_strategy;
    
    private MainFrame          m_frame;
    private LearnSettingPanels m_learnSettingsPanels;
    private JPanel             m_settingsPanel  = new JPanel(new CardLayout());
    private JButton            m_applyButton    = new JButton("Apply");
    private JList              m_sideList       = new JList(PANEL_NAMES);;
    
    public LearnSettingsFrame(MainFrame frame)
    {
        m_frame = frame;
        m_learnSettingsPanels = new LearnSettingPanels();
        
        initComponents();
    }
    
    public void show(Strategy strategy, Category rootCategory, Category currentCategory)
    {
        m_strategy = strategy;
        m_learnSettingsPanels.setStrategy(m_strategy);
        m_learnSettingsPanels.setCategory(rootCategory, currentCategory);
        
        setVisible(true);
    }
    
    public boolean close()
    {
        m_frame.onPreferencesFrameClosed();
        setVisible(false);
        
        return true;
    }
    
    private void initComponents()
    {
        getContentPane().add(buildMainPanel(), BorderLayout.CENTER);
        getContentPane().add(buildButtonBar(), BorderLayout.SOUTH);
        
        setTitle("Start Learn Session");
        pack();
        
        setResizable(false);
        setLocationRelativeTo(null);
    }
    
    private JPanel buildMainPanel()
    {
        // build settings panel
        m_settingsPanel.add(buildGeneralSettingsPanel(),                PANEL_NAMES[0]);
        m_settingsPanel.add(buildAdvancedPanel(),                       PANEL_NAMES[1]);
        m_settingsPanel.add(m_learnSettingsPanels.buildSchedulePanel(), PANEL_NAMES[2]);
        m_settingsPanel.setBorder(new EtchedBorder());
        
        // build side list
        m_sideList.setBorder(new EtchedBorder());
        m_sideList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        m_sideList.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)
            {
                CardLayout layout = (CardLayout)m_settingsPanel.getLayout();
                layout.show(m_settingsPanel, PANEL_NAMES[m_sideList.getSelectedIndex()]);
            }
        });
        m_sideList.setSelectedIndex(0);
        
        // build main panel
        FormLayout layout = new FormLayout(
            "70dlu, 3dlu, p:grow", // columns
            "fill:p:grow"); // rows
        
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        
        builder.add(m_sideList,      cc.xy(1,1));
        builder.add(m_settingsPanel, cc.xy(3,1));
        
        return builder.getPanel();
    }
    
    private JPanel buildGeneralSettingsPanel()
    {
        FormLayout layout = new FormLayout(
            "p:grow", // columns
            "p, 15dlu, p"); // rows
        
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        
        builder.add(m_learnSettingsPanels.buildCardsPanel(),   cc.xy(1, 1));
        builder.add(m_learnSettingsPanels.buildLimiterPanel(), cc.xy(1, 3));
        
        return builder.getPanel();
        
        
    }
    
    private JPanel buildAdvancedPanel()
    {
        FormLayout layout = new FormLayout(
            "p:grow", // columns
            "p, 9dlu, p"); // rows
        
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        
        builder.add(m_learnSettingsPanels.buildCardOrderPanel(), cc.xy(1, 1));
        builder.add(m_learnSettingsPanels.buildSidesModePanel(),     cc.xy(1, 3));
        
        return builder.getPanel();
    }
    
    private JPanel buildButtonBar()
    {
        JButton okayButton = new JButton("Start Session!"); 
        okayButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                apply();
                close();
                m_frame.startLearning();
            }
        });
        
        JButton cancelButton = new JButton("Cancel"); 
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                close();
            }
        });
        
        m_applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                apply();
            }
        });
        
        JPanel buttonPanel = ButtonBarFactory.buildOKCancelApplyBar(okayButton, cancelButton, m_applyButton);
        buttonPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        
        getRootPane().setDefaultButton(okayButton);
        
        return buttonPanel;
    }
    
    private void apply()
    {
        m_learnSettingsPanels.applySettings();
        m_strategy.storeToPreferences();
    }
}
