/*
 * Created on 24. Mrz 2004, 00:12
 */
package jmemorize.gui.swing;

import java.awt.*;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.core.Main;
import jmemorize.strategy.Strategy;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import java.applet.*;
import java.applet.AudioClip;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.regex.*;
import java.io.*;


/**
 * @author  djemili
 */
public class LearnPanel extends JPanel implements CategoryObserver
{    
    private AudioClip audioClip;

    public final static Color PANEL_COLOR = new Color(225, 230, 235);
    
    private Strategy          m_strategy;
    private Card              m_currentCard;
    private boolean           m_flippedCard; // true if current card is show with flipped card sides

    // swing elements
    private JButton           m_showButton        = new JButton("Show answer");
    private JButton           m_yesButton         = new JButton("Yes");
    
    private JTextPane         m_questionTextPane  = new JTextPane();
    private CardSidesPanel    m_cardAnswerPanel   = new CardSidesPanel();
    private JPanel            m_answerMainPanel   = buildAnswerPanel();
    private JPanel            m_questionMainPanel = buildQuestionPanel();
    private JPanel            m_cardPanel         = new JPanel();
    private TimerPanel        m_timerPanel        = new TimerPanel();
    private CardCounterPanel  m_cardCounterPanel  = new CardCounterPanel();
    
    private JCheckBox         m_categoryCheckBox  = new JCheckBox("Show category");
    private JTextField        m_categoryField     = new JTextField();
    
    private JLabel            m_flippedLabel      = new JLabel(
        "Flipped card sides", 
        new ImageIcon(getClass().getResource("/resource/icons/card_flipped.gif")),
        SwingConstants.CENTER
    );
    
    private StatusBar         m_statusBar;
    public String	      recent_lesson;
    
    // pref key strings
    private static String     PREFS_SHOW_CARD_CATEGORY = "show.card-category";
    
    public LearnPanel() 
    {
	recent_lesson = null;
        initComponents();
    }
    
    public void showCard(Card card, boolean flipped)
    {
        m_currentCard = card;
        m_flippedCard = flipped;
        
        m_flippedLabel.setVisible(flipped);
        
        updateTextPanes();
        updateCategoryField();
        
        showQuestion();
        
        // update selection property
        putClientProperty("selectedCards", getSelectedCards());
        
        updateStatusBar();
    }

    public List getSelectedCards()
    {
        List currentCards = new ArrayList(1);
        currentCards.add(m_currentCard);
        
        return currentCards;
    }
    
    public void setStatusBar(StatusBar statusBar)
    {
        m_statusBar = statusBar;
    }
    
    // category and card related events
    
    public void onStartLearning(Strategy strategy)
    {
        m_strategy = strategy;
        m_strategy.getCategory().addObserver(this);
        
        if (strategy.isTimeLimitEnabled())
        {
            m_timerPanel.start(strategy, strategy.getTimeLimit() * 60);
        }
        else
        {
            m_timerPanel.start(strategy);
        }
        
        if (strategy.isCardLimitEnabled())
        {
            m_cardCounterPanel.start(strategy.getCardLimit());
        }
        else
        {
            m_cardCounterPanel.start();
        }
        
        updateStatusBar();
    }
    
    public void onEndLearning()
    {
        m_timerPanel.stop();
        m_strategy.getCategory().removeObserver(this);
        
        if (m_statusBar != null)
        {
            m_statusBar.setLeftText("");
        }
    }
    
    public void onCardEvent(int type, Card card, int deck)
    {
        if (card == m_currentCard && type == EDITED_EVENT)
        {
            updateTextPanes();
        }
    }

    public void onCategoryEvent(int type, Category category)
    {
        assert false; // no category events should occur while learning
    }
    
    // GUI building code
    
    private void initComponents() 
    {
        m_cardPanel.setLayout(new java.awt.CardLayout());
        m_cardPanel.add(m_questionMainPanel, "questionCard");
        m_cardPanel.add(m_answerMainPanel,   "answerCard");

        JPanel mainPanel = new JPanel(new java.awt.BorderLayout());
        mainPanel.add(buildSidebarPanel(), java.awt.BorderLayout.WEST);
        
        JPanel mainCardPanel = new JPanel(new java.awt.BorderLayout());
        mainCardPanel.setBorder(new EtchedBorder());
        
        JPanel catPanel = buildCategoryPanel();
        mainCardPanel.add(catPanel, java.awt.BorderLayout.NORTH);
        mainCardPanel.add(m_cardPanel, java.awt.BorderLayout.CENTER);
        
        mainPanel.add(mainCardPanel, java.awt.BorderLayout.CENTER);

        setLayout(new BorderLayout());
        add(mainPanel, BorderLayout.CENTER);
    }
    
    private JPanel buildCategoryPanel()
    {
        // prepare category field and checkbox
        m_categoryCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e)
            {
                Main.USER_PREFS.putBoolean(PREFS_SHOW_CARD_CATEGORY, m_categoryCheckBox.isSelected());
                updateCategoryField();
            }
        });
        m_categoryField.setEditable(false);
        m_categoryCheckBox.setSelected(Main.USER_PREFS.getBoolean(PREFS_SHOW_CARD_CATEGORY, true));
        
        // build it using the forms layout
        FormLayout layout = new FormLayout(
            "28dlu, 3dlu, p:grow, 3dlu, right:p", // columns
            "20px"); // rows
        
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(new EmptyBorder(10, 10, 7, 10));
        
        builder.addLabel("Category",     cc.xy(1, 1));
        builder.add(m_categoryField,     cc.xy(3, 1));
        builder.add(m_categoryCheckBox , cc.xy(5, 1));
        
        return builder.getPanel();
    }
    
    private JPanel buildQuestionPanel()
    {
        m_questionTextPane.setEditable(false);
        JScrollPane frontScroll = new JScrollPane(m_questionTextPane,
            JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);

        // build it
        FormLayout layout = new FormLayout(
            "28dlu, 3dlu, d:grow", // columns
            "fill:p:grow"); // rows
        
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(new EmptyBorder(5, 10, 5, 10));
        
        builder.addLabel("Frontside", cc.xy(1, 1, "left, top"));
        builder.add(frontScroll,          cc.xy(3, 1));
        
        // build main panel
        JPanel mainPanel = new JPanel(new java.awt.BorderLayout());
        mainPanel.add(builder.getPanel(), java.awt.BorderLayout.CENTER);
        mainPanel.add(buildQuestionButtonBar(), java.awt.BorderLayout.SOUTH);
        
        return mainPanel;
    }
    
    private JPanel buildQuestionButtonBar()
    {
        // build bottom panel
        m_showButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showButtonActionPerformed(evt);
            }
        });
        
        // prepare skip button
        JButton skipButton = new JButton("Skip card");
        skipButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e)
            {
                m_strategy.cardSkipped();
            }
        });
        
        // build it using forms layout
        FormLayout layout = new FormLayout(
            "right:p:grow, 3dlu, 60dlu, 3dlu, 60dlu", // columns
            "p"); // rows
        
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(new EmptyBorder(5, 5, 5, 10));
        
        builder.addLabel("Try to remember the answer", cc.xy(1, 1));
        builder.add(m_showButton, cc.xy(3,1));
        builder.add(skipButton,   cc.xy(5,1));
        
        return builder.getPanel();
    }
    
    private JPanel buildAnswerPanel()
    {
        m_cardAnswerPanel.setEditable(false);
        m_cardAnswerPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        
        // build main panel
        JPanel mainPanel = new JPanel(new java.awt.BorderLayout());
        mainPanel.add(m_cardAnswerPanel, java.awt.BorderLayout.CENTER);
        mainPanel.add(buildAnswerButtonBar(), java.awt.BorderLayout.SOUTH);
        
        return mainPanel;
    }
    
    private JPanel buildAnswerButtonBar()
    {
        // prepare buttons
        m_yesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                yesButtonActionPerformed(evt);
            }
        });

        JButton noButton = new JButton("No");
        noButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                noButtonActionPerformed(evt);
            }
        });
        
        // build it using forms layout
        FormLayout layout = new FormLayout(
            "right:p:grow, 3dlu, 60dlu, 3dlu, 60dlu", // columns
            "p"); // rows
        
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(new EmptyBorder(5, 5, 5, 10));
        
        builder.addLabel("Did you know the correct answer?", cc.xy(1,1));
        builder.add(m_yesButton, cc.xy(3,1));
        builder.add(noButton,    cc.xy(5,1));
        
        return builder.getPanel();
    }
    
    private JPanel buildSidebarPanel()
    {
        m_timerPanel.setBackground(new java.awt.Color(225, 230, 235));
        m_timerPanel.setPreferredSize(new Dimension(140, 22));
        
        m_cardCounterPanel.setBackground(new java.awt.Color(225, 230, 235));
        m_cardCounterPanel.setPreferredSize(new Dimension(140, 22));
        
        JButton stopLearningButton = new JButton("Stop learning");
        stopLearningButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelLearningButtonActionPerformed(evt);
            }
        });
        
        // build it using FormLayout
        FormLayout layout = new FormLayout(
            "center:170px:grow", // columns
            "10px, p, 3dlu, p, 9dlu, p, 3dlu, p, 5dlu, fill:p:grow, 5dlu, p, 5px"); // rows
        
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        
        builder.addLabel("Timer",         cc.xy(1,  2));
        builder.add(m_timerPanel,         cc.xy(1,  4));
        builder.addLabel("Card counter",  cc.xy(1,  6));
        builder.add(m_cardCounterPanel,   cc.xy(1,  8));
        builder.add(m_flippedLabel,       cc.xy(1, 10));
        builder.add(stopLearningButton,   cc.xy(1, 12));
        
        JPanel sidePanel = builder.getPanel();
        sidePanel.setBackground(new java.awt.Color(225, 230, 235));
        sidePanel.setBorder(new javax.swing.border.EtchedBorder());
        return sidePanel;
    }
    
    // GUI updating
    
    private void updateTextPanes()
    {
        String front = !m_flippedCard ? m_currentCard.getFrontSide() : m_currentCard.getBackSide();
        String back = !m_flippedCard ? m_currentCard.getBackSide() : m_currentCard.getFrontSide();
        
	if(!m_flippedCard)
		{
		int fsiz = (front.length() <= 12) ? 48 : 24;
	        Font font = m_questionTextPane.getFont().deriveFont(Font.BOLD, fsiz);
	        m_questionTextPane.setFont(font);
		}
		else
		{
	        Font font = m_questionTextPane.getFont().deriveFont(Font.PLAIN, 12);
	        m_questionTextPane.setFont(font);
		}

        m_questionTextPane.setText(front);
        m_cardAnswerPanel.setSidesBigSide(m_flippedCard, front, back);

        String REGEX = "[ |\t|\n]";
        String INPUT = !m_flippedCard ? back : front;
        Pattern p = Pattern.compile(REGEX, Pattern.UNIX_LINES);
        String[] items = p.split(INPUT);

	audioClip = null ;

        if(items.length!=0)
                {
		for(int i=0; i<items.length; i++)		
			{
			String s = recent_lesson + items[i] + ".WAV";
			boolean exists = (new File(s)).exists();
			if(exists)
				{           
		                try     {
		                        URL snd = new URL("file:" + s);
		                        audioClip = Applet.newAudioClip(snd);
					i = items.length;
		               
		                        } catch (MalformedURLException e) { System.err.println(e.getMessage()); }
				}
			}
		}
    }

    private void updateCategoryField()
    {
        m_categoryField.setEnabled(m_categoryCheckBox.isSelected());
        m_categoryField.setText(m_categoryCheckBox.isSelected() ?
            m_currentCard.getCategory().getPath() +" ("+ m_currentCard.getLevel() +")" : "");
    }
    
    private void updateStatusBar()
    {
        if (m_statusBar != null)
        {
            m_statusBar.setLeftText("Learning category: "+m_strategy.getCategory().getName() +" "+
                "       Cards left: "+ (m_strategy.getCards().size()+1));
        }
    }
    
    private void showQuestion()
    {
        ((CardLayout)m_cardPanel.getLayout()).show(m_cardPanel, "questionCard");
        m_showButton.requestFocus();
    }
    
    private void showAnswer()
    {
        ((CardLayout)m_cardPanel.getLayout()).show(m_cardPanel, "answerCard");
        m_yesButton.requestFocus();
    }
    
    // button action events
    
    private void showButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        showAnswer();
	if(audioClip != null) audioClip.play();
    }

    private void cancelLearningButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        m_strategy.endLearning();
    }

    private void noButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        m_strategy.cardChecked(false);
    }

    private void yesButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
         m_strategy.cardChecked(true);
         m_cardCounterPanel.incStats();
    }
}
