/*
 * CardsPanel.java
 *
 * Created on 31. Mrz 2004, 02:28
 */
package jmemorize.gui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.core.Main;

/**
 * @author  djemili
 */
public class DeckTablePanel extends JPanel implements CategoryObserver
{
    private class NextDeckAction extends AbstractAction
    {
        public NextDeckAction()
        {
            putValue(NAME, "Next deck");
            putValue(SMALL_ICON, new ImageIcon(getClass().getResource("/resource/icons/card_next.gif")));
            putValue(SHORT_DESCRIPTION, "Display next deck.");
            //putValue(MNEMONIC_KEY, new Integer(1));
        }
        
        /*
         * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
         */
        public void actionPerformed(ActionEvent e)
        {
            int nextLevel = m_currentDeckLevel + 1;
            while (m_category.getCards(nextLevel).isEmpty())
            {
                nextLevel++;
            } 
            
            showDeck(nextLevel);
        }        
    }
    
    private class PreviousDeckAction extends AbstractAction
    {
        public PreviousDeckAction()
        {
            putValue(NAME, "Previous deck");
            putValue(SMALL_ICON, new ImageIcon(getClass().getResource("/resource/icons/card_prev.gif")));
            putValue(SHORT_DESCRIPTION, "Display previous deck.");
            //putValue(MNEMONIC_KEY, new Integer(1));
        }
        
        /*
         * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
         */
        public void actionPerformed(ActionEvent e)
        {
            int prevLevel = m_currentDeckLevel - 1;
            while (prevLevel >= 0 && m_category.getCards(prevLevel).isEmpty() )
            {
                prevLevel--;
            }
            
            showDeck(prevLevel); //HACK better use showAllDecks!?
        }        
    }
    
    private NextDeckAction     m_nextDeckAction     = new NextDeckAction();
    private PreviousDeckAction m_previousDeckAction = new PreviousDeckAction();
    
    private int                m_currentDeckLevel = 0;
    private Category           m_category;
    
    // swing elements
    private CardTable          m_cardTable  = new CardTable(Main.USER_PREFS.node("main.table"), new int[]{
        CardTable.COLUMN_FRONTSIDE, 
        CardTable.COLUMN_DECK, 
        CardTable.COLUMN_CATEGORY, 
        CardTable.COLUMN_TESTED, 
        CardTable.COLUMN_EXPIRES});
    
    /** 
     * Creates new form CardsPanel 
     */
    public DeckTablePanel() //TODO lesson as arguemtn
    {
        initComponents();
    }
    
    /**
     * @param deck If deck is -1 then all decks are shown, otherwise only given 
     * deck is shown. 
     */
    public void showDeck(int deck)
    {
        m_cardTable.getView().setCards(
            deck > -1 ? m_category.getCards(deck) : m_category.getCards(), m_category);
        m_currentDeckLevel = deck;
        updateButtons();
    }
    
    public void editCards() //HACK
    {
        Card card = m_cardTable.getSelectedCard();
        List cards = m_cardTable.getView().getCards();
        Category category = m_cardTable.getView().getCategory();
        
        EditCardFrame.getInstance().showCard(card, cards, category);
    }
    
    public void setCategory(Category category)
    {
        if (m_category != null)
        {
            m_category.removeObserver(this);
        }
        m_category = category;
        m_category.addObserver(this);
        
        showDeck(-1);
    }
    
    public CardTable getCardTable()
    {
        return m_cardTable;
    }
    
    /*
     * @see jmemorize.core.CategoryObserver#onCategoryEvent(int, jmemorize.core.Category)
     */
    public void onCategoryEvent(int type, Category category)
    {
        // ignore
        // if this category change was important, mainframe will let us know
    }

    /*
     * @see jmemorize.core.CategoryObserver#onCardEvent(int, jmemorize.core.Card, int)
     */
    public void onCardEvent(int type, Card card, int deck)
    {
        // HACK make this finer
        showDeck(m_currentDeckLevel);
    }
    
    private void updateButtons()
    {
        m_previousDeckAction.setEnabled(m_currentDeckLevel >= 0);
        m_nextDeckAction.setEnabled(m_currentDeckLevel < m_category.getNumberOfDecks() - 1);
    }
    
    private void initComponents() 
    {
        JButton  leftButton  = new JButton(m_previousDeckAction);
        JButton  rightButton = new JButton(m_nextDeckAction);

        JToolBar buttonBar   = new JToolBar();
        buttonBar.setFloatable(false);
        buttonBar.add(leftButton);
        buttonBar.add(rightButton);

        JPanel mainPanel   = new JPanel(new java.awt.BorderLayout());
        mainPanel.setBorder(new javax.swing.border.EtchedBorder());
        mainPanel.add(buttonBar, java.awt.BorderLayout.NORTH);

        JScrollPane scrollPane = new JScrollPane(m_cardTable);
        scrollPane.getViewport().setBackground(javax.swing.UIManager.getColor("Table.background"));
        
        m_cardTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                tableMouseClicked(evt);
            }
        });

        mainPanel.add(scrollPane, java.awt.BorderLayout.CENTER);

        setLayout(new java.awt.BorderLayout());
        add(mainPanel, java.awt.BorderLayout.CENTER);
        
        // overwrite moving to next row when pressing ENTER
        InputMap map = m_cardTable.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        map.put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "");        
    }
    
    private void tableMouseClicked(MouseEvent evt)
    {
        if (evt.getClickCount() == 2)
        {
            editCards();
        }
    }
}
