/*
 * Created on 14-May-2004
 */
package jmemorize.gui.swing;

import java.awt.Component;
import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;

/**
 * @author djemili
 */
public class CategoryComboBox extends JComboBox implements CategoryObserver
{
    private class CatergoryRenderer extends BasicComboBoxRenderer
    {
        /**
         * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
         */
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus)
        {
            Category cat = (Category)value;
            JLabel label = (JLabel)super.getListCellRendererComponent(list, cat.getName(), index, isSelected, cellHasFocus);
            label.setIcon(FOLDER_ICON);
            
            // show items in combo list indented.
            int leftSpace = index >= 0 ? 20 * cat.getDepth() : 0;
            label.setBorder(new EmptyBorder(2, leftSpace, 2, 2));

            return label;
        }
    }
    
    private final ImageIcon     FOLDER_ICON = new ImageIcon(getClass().getResource("/resource/icons/folder.gif"));
    
    private Category            m_rootCategory;
    
    public CategoryComboBox()
    {
        setRenderer(new CatergoryRenderer());
        setMaximumRowCount(12);
    }
    
    public void setRootCategory(Category category)
    {
        if (m_rootCategory != null)
        {
            m_rootCategory.removeObserver(this);
        }
        m_rootCategory = category;
        m_rootCategory.addObserver(this);
        
        updateModel();
    }
    
    public void setSelectedCategory(Category category)
    {
        setSelectedItem(category);
    }
    
    public Category getSelectedCategory()
    {
        return (Category)getModel().getSelectedItem();
    }
    
    /*
     * @see jmemorize.core.CategoryObserver#onCategoryEvent(int, jmemorize.core.Category)
     */
    public void onCategoryEvent(int type, Category category)
    {
        updateModel();
    }

    /*
     * @see jmemorize.core.CategoryObserver#onCardEvent(int, jmemorize.core.Card, int)
     */
    public void onCardEvent(int type, Card card, int deck)
    {
        // ignore
    }
    
    private void updateModel()
    {
        Object selected = getModel().getSelectedItem();
        List categoryList = m_rootCategory.getSubtreeList();
        DefaultComboBoxModel model = new DefaultComboBoxModel(categoryList.toArray());
        
        // if former selected object still there, select it again
        if (categoryList.contains(selected))
        {
            model.setSelectedItem(selected);
        }

        setModel(model);
    }
}
