/*
 * Created on 23. Mrz 2004, 19:15
 */
package jmemorize.gui.swing;

import java.awt.*;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;


/**
 * @author  djemili
 */
public class CardSidesPanel extends JPanel 
{
    // swing elements
    private JTextPane  m_frontTextPane  = new JTextPane();
    private JTextPane  m_backTextPane   = new JTextPane();
    private JTextPane  m_notesTextPane  = new JTextPane();

    private JLabel     m_frontLabel     = new JLabel("Frontside");
    private JLabel     m_backLabel      = new JLabel("Flipside");
    private JLabel     m_notesLabel     = new JLabel("Notes");
    
    /** 
     * Creates new form EditCardPanel 
     */
    public CardSidesPanel() 
    {
        // init components
        setLayout(new BorderLayout());
        add(buildSidesPanel(-1), BorderLayout.CENTER);
        
        // for unknown reasons the default focus traversal mechanism ignores
        // the first char entered into the back text pane. overriding it by
        // handling the key event ourself, seems to fix this issue.
        m_frontTextPane.setFocusTraversalKeysEnabled(false);
        m_frontTextPane.getInputMap(JComponent.WHEN_FOCUSED).put(
            KeyStroke.getKeyStroke(KeyEvent.VK_TAB, KeyEvent.CTRL_DOWN_MASK), "FocusNext");
        m_frontTextPane.getActionMap().put("FocusNext", new AbstractAction(){
            public void actionPerformed(ActionEvent e)
            {
                m_backTextPane.requestFocus();
            }
        });
    }
    
    /**
     * Sets front- and backside and focuses text area for frontside.
     */
    public void setSidesBigSide(boolean flipped, String frontside, String backside)
    {
	if(!flipped)
		{
		int fsiz = (frontside.length() <= 12) ? 48 : 24;
		Font font = m_frontTextPane.getFont().deriveFont(Font.BOLD, fsiz);
	        m_frontTextPane.setFont(font);
		}
		else
		{
		Font font = m_frontTextPane.getFont().deriveFont(Font.PLAIN, 12);
	        m_frontTextPane.setFont(font);
		}
        m_frontTextPane.setText(frontside);

	if(flipped)
		{
		int fsiz = (backside.length() <= 12) ? 48 : 24;
		Font font = m_backTextPane.getFont().deriveFont(Font.BOLD, fsiz);
	        m_backTextPane.setFont(font);
		}
		else
		{
		Font font = m_backTextPane.getFont().deriveFont(Font.PLAIN, 12);
	        m_backTextPane.setFont(font);
		}
        m_backTextPane.setText(backside);
        
        m_frontTextPane.requestFocus();
    }

    public void setSides(String frontside, String backside)
    {
        m_frontTextPane.setText(frontside);
        m_backTextPane.setText(backside);
        
        m_frontTextPane.requestFocus();
    }
    
    public void setEditable(boolean editable)
    {
        m_frontTextPane.setEditable(editable);
        m_backTextPane.setEditable(editable);
        m_notesTextPane.setEditable(editable);
    }

    /**
     * Clears both text areas and give the first focus.
     */
    public void reset()
    {
        setSides("", "");
    }
    
    public String getFrontside()
    {
        return m_frontTextPane.getText();                
    }
    
    public String getBackside()
    {
        return m_backTextPane.getText();
    }
    
    public void addDocumentListener(DocumentListener listener)
    {
        m_frontTextPane.getDocument().addDocumentListener(listener);
        m_backTextPane.getDocument().addDocumentListener(listener);
    }
    
    private JPanel buildSidesPanel(int changePanel)
    {
        JScrollPane frontScroll = new JScrollPane(m_frontTextPane);
        frontScroll.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        
        JScrollPane backScroll = new JScrollPane(m_backTextPane);
        backScroll.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        
        JScrollPane notesScroll = new JScrollPane(m_notesTextPane);
        notesScroll.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        
        // build it
        FormLayout layout = new FormLayout(
            "28dlu, 3dlu, d:grow", // columns
            "fill:20dlu:grow, 3dlu, fill:20dlu:grow"); // rows
       
        CellConstraints cc = new CellConstraints();
        
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        
        builder.add(m_frontLabel, cc.xy(1, 1, "left, top"));
        builder.add(frontScroll,      cc.xy(3, 1));
        builder.add(m_backLabel,  cc.xy(1, 3, "left, top"));
        builder.add(backScroll,      cc.xy(3, 3));
        
        return builder.getPanel();
    }
    
    public static void main(String[] args)
    {
        JFrame frame = new JFrame();
        frame.add(new CardSidesPanel());
        frame.setVisible(true);
    }
}
