/*
 * Created on Dec 26, 2004
 */
package jmemorize.gui.swing;

import java.awt.BorderLayout;

import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

/**
 * @author djemili
 */
public class CardCounterPanel extends JPanel
{
    private int           m_cardsPassed;
    private int           m_cardsTarget;

    private JProgressBar  m_bar       = new JProgressBar();
    private JTextField    m_textField = new JTextField();

    public void start(int target)
    {
        m_cardsTarget = target;
        m_cardsPassed = 0;

        removeAll();
        setLayout(new BorderLayout());
        
        // if there is a card limit show a progess bar
        if (m_cardsTarget > -1)
        {
            m_bar.setStringPainted(true);
            m_bar.setString(getCardString());
            m_bar.setValue(0);
            add(m_bar, BorderLayout.CENTER);
        }
        // otherwise show a textfield
        else
        {
            m_textField.setText(getCardString());
            m_textField.setHorizontalAlignment(JTextField.CENTER);
            m_textField.setEditable(false);
            add(m_textField, BorderLayout.CENTER);
        }
    }
    
    public void start()
    {
        start(-1);
    }

    public void incStats()
    {
        m_cardsPassed++;

        if (m_cardsTarget > -1)
        {
            m_bar.setValue((100 * m_cardsPassed) / m_cardsTarget);
            m_bar.setString(getCardString());
        }
        else
        {
            m_textField.setText(getCardString());
        }
    }

    /**
     * @return The string that is used to show time in progressbar.
     */
    protected String getCardString()
    {
        // if progress bar
        if (m_cardsTarget > -1)
        {
            return m_cardsPassed + " / " + m_cardsTarget;
        }
        // else text field
        else
        {
            return Integer.toString(m_cardsPassed);
        }
    }
}