/*
 * Created on 31-Oct-2004
 */
package jmemorize.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * @author rdjemili
 */
public class SearchTool
{
    public final static int FRONT_SIDE = 0;
    public final static int FLIP_SIDE  = 1;
    public final static int BOTH_SIDES = 2;
    
    public static List search(String text, int side, boolean matchCase, List cards)
    {
        List foundCards = new LinkedList();
        for (Iterator it = cards.iterator(); it.hasNext();)
        {
            Card card = (Card) it.next();
            
            String frontSide = card.getFrontSide();
            String flipSide  = card.getBackSide();
            
            if (!matchCase)
            {
                text      = text.toLowerCase();
                frontSide = frontSide.toLowerCase();
                flipSide  = flipSide.toLowerCase();
            }
            
            if (side == FRONT_SIDE || side == BOTH_SIDES)
            {
                if (frontSide.indexOf(text) > -1)
                {
                    foundCards.add(card);
                    continue;
                }
            }
            
            if (side == FLIP_SIDE || side == BOTH_SIDES)
            {
                if (flipSide.indexOf(text) > -1)
                {
                    foundCards.add(card);
                }
            }
        }
        
        return foundCards;
    }
    
    public static List search(String text, String searchtext, int side, boolean ignoreCase)
    {
        if (ignoreCase)
        {
            text       = text.toLowerCase();
            searchtext = searchtext.toLowerCase();
        }
        
        List positions = new ArrayList();
        int pos = 0;
        while ((pos = text.indexOf(searchtext, pos)) >= 0) 
        {
            positions.add(new Integer(pos));
            pos += searchtext.length();
        }
        
        return positions;
    }

}
