/*
 * Created on 24-Jun-2004
 */
package jmemorize.core;

/**
 * Interface for observers of a category.
 * Categories can signal either card or category hierarchy related events.
 * 
 * @author djemili
 */
public interface CategoryObserver extends Events
{
    /**
     * @param type Either EDITED_EVENT, ADDED_EVENT, REMOVED_EVENT, EXPIRED_EVENT or DECK_EVENT.
     * @param card The card that changed.
     * @param deck The deck that held the card, when the event happend.
     */
    void onCardEvent(int type, Card card, int deck);
    
    /**
     * @param type Either EDITED_EVENT, ADDED_EVENT or REMOVED_EVENT.
     * @param category The category that created the event. 
     */
    void onCategoryEvent(int type, Category category);
}
