/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ObjectUtils;

public class TimeSeriesCollection
extends AbstractIntervalXYDataset
implements XYDataset,
IntervalXYDataset,
DomainInfo,
Serializable {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    private List data;
    private Calendar workingCalendar;
    private TimePeriodAnchor xPosition;
    private boolean domainIsPointsInTime;

    public TimeSeriesCollection() {
        this(null, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeZone zone) {
        this(null, zone);
    }

    public TimeSeriesCollection(TimeSeries series) {
        this(series, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeSeries series, TimeZone zone) {
        if (zone == null) {
            zone = TimeZone.getDefault();
        }
        this.workingCalendar = Calendar.getInstance(zone);
        this.data = new ArrayList();
        if (series != null) {
            this.data.add(series);
            series.addChangeListener(this);
        }
        this.xPosition = TimePeriodAnchor.START;
        this.domainIsPointsInTime = true;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean flag) {
        this.domainIsPointsInTime = flag;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.xPosition = anchor;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public TimeSeries getSeries(int series) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("The 'series' argument is out of bounds.");
        }
        return (TimeSeries)this.data.get(series);
    }

    public TimeSeries getSeries(String name) {
        TimeSeries result = null;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TimeSeries series = (TimeSeries)iterator.next();
            String n = series.getName();
            if (n == null || !n.equals(name)) continue;
            result = series;
        }
        return result;
    }

    public String getSeriesName(int series) {
        return this.getSeries(series).getName();
    }

    public void addSeries(TimeSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(TimeSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.remove(series);
        series.removeChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int index) {
        TimeSeries series = this.getSeries(index);
        if (series != null) {
            this.removeSeries(series);
        }
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            TimeSeries series = (TimeSeries)this.data.get(i);
            series.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public double getXValue(int series, int item) {
        TimeSeries s = (TimeSeries)this.data.get(series);
        TimeSeriesDataItem i = s.getDataItem(item);
        RegularTimePeriod period = i.getPeriod();
        return this.getX(period);
    }

    public Number getX(int series, int item) {
        TimeSeries ts = (TimeSeries)this.data.get(series);
        TimeSeriesDataItem dp = ts.getDataItem(item);
        RegularTimePeriod period = dp.getPeriod();
        return new Long(this.getX(period));
    }

    protected long getX(RegularTimePeriod period) {
        long result = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            result = period.getFirstMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            result = period.getMiddleMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.END) {
            result = period.getLastMillisecond(this.workingCalendar);
        }
        return result;
    }

    public Number getStartX(int series, int item) {
        TimeSeries ts = (TimeSeries)this.data.get(series);
        TimeSeriesDataItem dp = ts.getDataItem(item);
        return new Long(dp.getPeriod().getFirstMillisecond(this.workingCalendar));
    }

    public Number getEndX(int series, int item) {
        TimeSeries ts = (TimeSeries)this.data.get(series);
        TimeSeriesDataItem dp = ts.getDataItem(item);
        return new Long(dp.getPeriod().getLastMillisecond(this.workingCalendar));
    }

    public Number getY(int series, int item) {
        TimeSeries ts = (TimeSeries)this.data.get(series);
        TimeSeriesDataItem dp = ts.getDataItem(item);
        return dp.getValue();
    }

    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public int[] getSurroundingItems(int series, long milliseconds) {
        int[] result = new int[]{-1, -1};
        TimeSeries timeSeries = this.getSeries(series);
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            Number x = this.getX(series, i);
            long m = x.longValue();
            if (m <= milliseconds) {
                result[0] = i;
            }
            if (m < milliseconds) continue;
            result[1] = i;
            break;
        }
        return result;
    }

    public Number getMinimumDomainValue() {
        Range r = this.getDomainRange();
        return new Double(r.getLowerBound());
    }

    public Number getMaximumDomainValue() {
        Range r = this.getDomainRange();
        return new Double(r.getUpperBound());
    }

    public Range getDomainRange() {
        Range result = null;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TimeSeries series = (TimeSeries)iterator.next();
            int count = series.getItemCount();
            if (count <= 0) continue;
            RegularTimePeriod start = series.getTimePeriod(0);
            RegularTimePeriod end = series.getTimePeriod(count - 1);
            Range temp = this.domainIsPointsInTime ? new Range(this.getX(start), this.getX(end)) : new Range(start.getFirstMillisecond(this.workingCalendar), end.getLastMillisecond(this.workingCalendar));
            result = Range.combine(result, temp);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TimeSeriesCollection)) {
            return false;
        }
        TimeSeriesCollection tsc = (TimeSeriesCollection)obj;
        if (!ObjectUtils.equal(this.data, tsc.data)) {
            return false;
        }
        if (this.xPosition != tsc.xPosition) {
            return false;
        }
        return this.domainIsPointsInTime == tsc.domainIsPointsInTime;
    }

    public int hashCode() {
        int result = ((Object)this.data).hashCode();
        result = 29 * result + (this.workingCalendar != null ? this.workingCalendar.hashCode() : 0);
        result = 29 * result + (this.xPosition != null ? this.xPosition.hashCode() : 0);
        result = 29 * result + (this.domainIsPointsInTime ? 1 : 0);
        return result;
    }

    public int getPosition() {
        int result = 1;
        TimePeriodAnchor anchor = this.getXPosition();
        if (anchor == TimePeriodAnchor.START) {
            result = 0;
        } else if (anchor == TimePeriodAnchor.MIDDLE) {
            result = 1;
        } else if (anchor == TimePeriodAnchor.END) {
            result = 2;
        }
        return result;
    }

    public void setPosition(int position) {
        if (position == 0) {
            this.setXPosition(TimePeriodAnchor.START);
        } else if (position == 1) {
            this.setXPosition(TimePeriodAnchor.MIDDLE);
        } else if (position == 2) {
            this.setXPosition(TimePeriodAnchor.END);
        }
    }
}

