/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.needle.ArrowNeedle;
import org.jfree.chart.needle.LineNeedle;
import org.jfree.chart.needle.LongNeedle;
import org.jfree.chart.needle.MeterNeedle;
import org.jfree.chart.needle.MiddlePinNeedle;
import org.jfree.chart.needle.PinNeedle;
import org.jfree.chart.needle.PlumNeedle;
import org.jfree.chart.needle.PointerNeedle;
import org.jfree.chart.needle.ShipNeedle;
import org.jfree.chart.needle.WindNeedle;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.util.ObjectUtils;

public class CompassPlot
extends Plot
implements Cloneable,
Serializable {
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    private int labelType;
    private Font labelFont;
    private boolean drawBorder = false;
    private Paint roseHighlightPaint = Color.black;
    private Paint rosePaint = Color.yellow;
    private Paint roseCenterPaint = Color.white;
    private Font compassFont = new Font("Arial", 0, 10);
    private transient Ellipse2D circle1;
    private transient Ellipse2D circle2;
    private transient Area a1;
    private transient Area a2;
    private transient Rectangle2D rect1;
    private ValueDataset[] datasets = new ValueDataset[1];
    private MeterNeedle[] seriesNeedle = new MeterNeedle[1];
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    protected double revolutionDistance = 360.0;

    public CompassPlot() {
        this(new DefaultValueDataset());
    }

    public CompassPlot(ValueDataset dataset) {
        if (dataset != null) {
            this.datasets[0] = dataset;
            dataset.addChangeListener(this);
        }
        this.circle1 = new Ellipse2D.Double();
        this.circle2 = new Ellipse2D.Double();
        this.rect1 = new Rectangle2D.Double();
        this.setSeriesNeedle(0);
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.labelType != type) {
            this.labelType = type;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("MeterPlot.setLabelFont(...): null font not allowed.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean status) {
        this.drawBorder = status;
    }

    public void setSeriesPaint(int series, Paint paint) {
        if (series >= 0 && series < this.seriesNeedle.length) {
            this.seriesNeedle[series].setFillPaint(paint);
        }
    }

    public void setSeriesOutlinePaint(int series, Paint p) {
        if (series >= 0 && series < this.seriesNeedle.length) {
            this.seriesNeedle[series].setOutlinePaint(p);
        }
    }

    public void setSeriesOutlineStroke(int series, Stroke stroke) {
        if (series >= 0 && series < this.seriesNeedle.length) {
            this.seriesNeedle[series].setOutlineStroke(stroke);
        }
    }

    public void setSeriesNeedle(int type) {
        this.setSeriesNeedle(0, type);
    }

    public void setSeriesNeedle(int index, int type) {
        switch (type) {
            case 0: {
                this.setSeriesNeedle(index, new ArrowNeedle(true));
                this.setSeriesPaint(index, Color.red);
                this.seriesNeedle[index].setHighlightPaint(Color.white);
                break;
            }
            case 1: {
                this.setSeriesNeedle(index, new LineNeedle());
                break;
            }
            case 2: {
                LongNeedle longNeedle = new LongNeedle();
                longNeedle.setRotateY(0.5);
                this.setSeriesNeedle(index, longNeedle);
                break;
            }
            case 3: {
                this.setSeriesNeedle(index, new PinNeedle());
                break;
            }
            case 4: {
                this.setSeriesNeedle(index, new PlumNeedle());
                break;
            }
            case 5: {
                this.setSeriesNeedle(index, new PointerNeedle());
                break;
            }
            case 6: {
                this.setSeriesPaint(index, null);
                this.setSeriesOutlineStroke(index, new BasicStroke(3.0f));
                this.setSeriesNeedle(index, new ShipNeedle());
                break;
            }
            case 7: {
                this.setSeriesPaint(index, Color.blue);
                this.setSeriesNeedle(index, new WindNeedle());
                break;
            }
            case 8: {
                this.setSeriesNeedle(index, new ArrowNeedle(true));
                break;
            }
            case 9: {
                this.setSeriesNeedle(index, new MiddlePinNeedle());
                break;
            }
            default: {
                String message = "CompassPlot.setSeriesNeedle(...): unrecognised type.";
                throw new IllegalArgumentException(message);
            }
        }
    }

    public void setSeriesNeedle(int index, MeterNeedle needle) {
        if (needle != null && index < this.seriesNeedle.length) {
            this.seriesNeedle[index] = needle;
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueDataset[] getData() {
        return this.datasets;
    }

    public void addData(ValueDataset data) {
        this.addData(data, null);
    }

    public void addData(ValueDataset data, MeterNeedle needle) {
        if (data != null) {
            int i = this.datasets.length + 1;
            ValueDataset[] t = new ValueDataset[i];
            MeterNeedle[] p = new MeterNeedle[i];
            i -= 2;
            while (i >= 0) {
                t[i] = this.datasets[i];
                p[i] = this.seriesNeedle[i];
                --i;
            }
            i = this.datasets.length;
            t[i] = data;
            p[i] = needle != null ? needle : p[i - 1];
            ValueDataset[] a = this.datasets;
            MeterNeedle[] b = this.seriesNeedle;
            this.datasets = t;
            this.seriesNeedle = p;
            --i;
            while (i >= 0) {
                a[i] = null;
                b[i] = null;
                --i;
            }
            data.addChangeListener(this);
        }
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, PlotState parentState, PlotRenderingInfo info) {
        int y1;
        double a;
        int w;
        Insets insets;
        int outerRadius = 0;
        int innerRadius = 0;
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if ((insets = this.getInsets()) != null) {
            plotArea.setRect(plotArea.getX() + (double)insets.left, plotArea.getY() + (double)insets.top, plotArea.getWidth() - (double)insets.left - (double)insets.right, plotArea.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (this.drawBorder) {
            this.drawBackground(g2, plotArea);
        }
        int midX = (int)(plotArea.getWidth() / 2.0);
        int midY = (int)(plotArea.getHeight() / 2.0);
        int radius = midX;
        if (midY < midX) {
            radius = midY;
        }
        int diameter = 2 * --radius;
        this.circle1.setFrame((midX += (int)plotArea.getMinX()) - radius, (midY += (int)plotArea.getMinY()) - radius, diameter, diameter);
        this.circle2.setFrame(midX - radius + 15, midY - radius + 15, diameter - 30, diameter - 30);
        g2.setPaint(this.rosePaint);
        this.a1 = new Area(this.circle1);
        this.a2 = new Area(this.circle2);
        this.a1.subtract(this.a2);
        g2.fill(this.a1);
        g2.setPaint(this.roseCenterPaint);
        int x1 = diameter - 30;
        g2.fillOval(midX - radius + 15, midY - radius + 15, x1, x1);
        g2.setPaint(this.roseHighlightPaint);
        g2.drawOval(midX - radius, midY - radius, diameter, diameter);
        x1 = diameter - 20;
        g2.drawOval(midX - radius + 10, midY - radius + 10, x1, x1);
        x1 = diameter - 30;
        g2.drawOval(midX - radius + 15, midY - radius + 15, x1, x1);
        x1 = diameter - 80;
        g2.drawOval(midX - radius + 40, midY - radius + 40, x1, x1);
        outerRadius = radius - 20;
        innerRadius = radius - 32;
        for (w = 0; w < 360; w += 15) {
            a = Math.toRadians(w);
            x1 = midX - (int)(Math.sin(a) * (double)innerRadius);
            int x2 = midX - (int)(Math.sin(a) * (double)outerRadius);
            y1 = midY - (int)(Math.cos(a) * (double)innerRadius);
            int y2 = midY - (int)(Math.cos(a) * (double)outerRadius);
            g2.drawLine(x1, y1, x2, y2);
        }
        g2.setPaint(this.roseHighlightPaint);
        innerRadius = radius - 26;
        outerRadius = 7;
        for (w = 45; w < 360; w += 90) {
            a = Math.toRadians(w);
            x1 = midX - (int)(Math.sin(a) * (double)innerRadius);
            y1 = midY - (int)(Math.cos(a) * (double)innerRadius);
            g2.fillOval(x1 - outerRadius, y1 - outerRadius, 2 * outerRadius, 2 * outerRadius);
        }
        for (w = 0; w < 360; w += 90) {
            a = Math.toRadians(w);
            x1 = midX - (int)(Math.sin(a) * (double)innerRadius);
            y1 = midY - (int)(Math.cos(a) * (double)innerRadius);
            Polygon p = new Polygon();
            p.addPoint(x1 - outerRadius, y1);
            p.addPoint(x1, y1 + outerRadius);
            p.addPoint(x1 + outerRadius, y1);
            p.addPoint(x1, y1 - outerRadius);
            g2.fillPolygon(p);
        }
        innerRadius = radius - 42;
        Font f = this.getCompassFont(radius);
        g2.setFont(f);
        g2.drawString("N", midX - 5, midY - innerRadius + f.getSize());
        g2.drawString("S", midX - 5, midY + innerRadius - 5);
        g2.drawString("W", midX - innerRadius + 5, midY + 5);
        g2.drawString("E", midX + innerRadius - f.getSize(), midY + 5);
        y1 = radius / 2;
        x1 = radius / 6;
        Rectangle2D.Double needleArea = new Rectangle2D.Double(midX - x1, midY - y1, 2 * x1, 2 * y1);
        int x = this.seriesNeedle.length;
        int current = 0;
        double value = 0.0;
        for (int i = this.datasets.length - 1; i >= 0; --i) {
            ValueDataset data = this.datasets[i];
            if (data == null || data.getValue() == null) continue;
            value = data.getValue().doubleValue() % this.revolutionDistance;
            value = value / this.revolutionDistance * 360.0;
            current = i % x;
            this.seriesNeedle[current].draw(g2, needleArea, value);
        }
        if (this.drawBorder) {
            this.drawOutline(g2, plotArea);
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Compass_Plot");
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void zoom(double percent) {
    }

    protected Font getCompassFont(int radius) {
        float fontSize = radius / 10;
        if (fontSize < 8.0f) {
            fontSize = 8.0f;
        }
        Font newFont = this.compassFont.deriveFont(fontSize);
        return newFont;
    }

    public List getLegendItemLabels() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CompassPlot && super.equals(object)) {
            CompassPlot p = (CompassPlot)object;
            boolean b0 = this.labelType == p.labelType;
            boolean b1 = ObjectUtils.equal(this.labelFont, p.labelFont);
            boolean b2 = this.drawBorder == p.drawBorder;
            boolean b3 = ObjectUtils.equal(this.roseHighlightPaint, p.roseHighlightPaint);
            boolean b4 = ObjectUtils.equal(this.rosePaint, p.rosePaint);
            boolean b5 = ObjectUtils.equal(this.roseCenterPaint, p.roseCenterPaint);
            boolean b6 = ObjectUtils.equal(this.compassFont, p.compassFont);
            boolean b7 = Arrays.equals(this.seriesNeedle, p.seriesNeedle);
            boolean b8 = this.getRevolutionDistance() == p.getRevolutionDistance();
            return b0 && b1 && b2 && b3 && b4 && b5 && b6 && b7 && b8;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        CompassPlot clone = (CompassPlot)super.clone();
        clone.circle1 = (Ellipse2D)this.circle1.clone();
        clone.circle2 = (Ellipse2D)this.circle2.clone();
        clone.a1 = (Area)this.a1.clone();
        clone.a2 = (Area)this.a2.clone();
        clone.rect1 = (Rectangle2D)this.rect1.clone();
        clone.datasets = (ValueDataset[])this.datasets.clone();
        clone.seriesNeedle = (MeterNeedle[])this.seriesNeedle.clone();
        for (int i = 0; i < this.datasets.length; ++i) {
            if (clone.datasets[i] == null) continue;
            clone.datasets[i].addChangeListener(clone);
        }
        return this.clone();
    }

    public void setRevolutionDistance(double size) {
        if (size > 0.0) {
            this.revolutionDistance = size;
        }
    }

    public double getRevolutionDistance() {
        return this.revolutionDistance;
    }
}

