/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class TimeSpan {
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    private static DateFormat m_longDateFormater = DateFormat.getDateTimeInstance(0, 1, Locale.GERMAN);
    private long m_ticks;

    public TimeSpan(Date date, Date date2) {
        this.m_ticks = date2.getTime() - date.getTime();
    }

    public long getDays() {
        return this.m_ticks / 86400000L;
    }

    public int getHours() {
        return (int)(this.m_ticks % 86400000L / 3600000L);
    }

    public int getMinutes() {
        return (int)(this.m_ticks % 3600000L / 60000L);
    }

    public long getTicks() {
        return this.m_ticks;
    }

    public static String format(Date date, Date date2) {
        TimeSpan timeSpan = new TimeSpan(date, date2);
        StringBuffer stringBuffer = new StringBuffer();
        if (timeSpan.getTicks() >= 0L) {
            stringBuffer.append("in ");
        }
        if (Math.abs(timeSpan.getDays()) >= 1L) {
            stringBuffer.append(Math.abs(timeSpan.getDays()) + " day");
            if (Math.abs(timeSpan.getDays()) > 1L) {
                stringBuffer.append("s");
            }
        } else if (Math.abs(timeSpan.getHours()) >= 1) {
            stringBuffer.append(Math.abs(timeSpan.getHours()) + " hour");
            if (Math.abs(timeSpan.getHours()) > 1) {
                stringBuffer.append("s");
            }
        } else {
            stringBuffer.append(Math.abs(timeSpan.getMinutes()) + " minute");
            if (Math.abs(timeSpan.getMinutes()) != 1) {
                stringBuffer.append("s");
            }
        }
        if (timeSpan.getTicks() < 0L) {
            stringBuffer.append(" ago");
        }
        return stringBuffer.toString();
    }
}

