/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;

public class RecentItems {
    public static final String RECENT_ITEM_STRING = "recent.item.";
    private int m_maxItems;
    private Preferences m_prefNode;
    private List m_items = new ArrayList();
    private List m_observers = new ArrayList();

    public RecentItems(int n, Preferences preferences) {
        this.m_maxItems = n;
        this.m_prefNode = preferences;
        this.loadFromPreferences();
    }

    public void push(Object object) {
        this.m_items.remove(object);
        this.m_items.add(0, object);
        if (this.m_items.size() > this.m_maxItems) {
            this.m_items.remove(this.m_items.size() - 1);
        }
        this.update();
    }

    public void remove(Object object) {
        this.m_items.remove(object);
        this.update();
    }

    public String get(int n) {
        return (String)this.m_items.get(n);
    }

    public List getItems() {
        return this.m_items;
    }

    public int size() {
        return this.m_items.size();
    }

    public void addObserver(RecentItemsObserver recentItemsObserver) {
        this.m_observers.add(recentItemsObserver);
    }

    public void removeObserver(RecentItemsObserver recentItemsObserver) {
        this.m_observers.remove(recentItemsObserver);
    }

    private void update() {
        Iterator iterator = this.m_observers.iterator();
        while (iterator.hasNext()) {
            RecentItemsObserver recentItemsObserver = (RecentItemsObserver)iterator.next();
            recentItemsObserver.onRecentItemChange(this);
        }
        this.storeToPreferences();
    }

    private void loadFromPreferences() {
        String string;
        for (int i = 0; i < this.m_maxItems && !(string = this.m_prefNode.get(RECENT_ITEM_STRING + i, "")).equals(""); ++i) {
            this.m_items.add(string);
        }
    }

    private void storeToPreferences() {
        for (int i = 0; i < this.m_maxItems; ++i) {
            if (i < this.m_items.size()) {
                this.m_prefNode.put(RECENT_ITEM_STRING + i, (String)this.m_items.get(i));
                continue;
            }
            this.m_prefNode.remove(RECENT_ITEM_STRING + i);
        }
    }

    public static interface RecentItemsObserver {
        public void onRecentItemChange(RecentItems var1);
    }
}

