/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class Arrow
implements Icon {
    private boolean descending;
    private int size;
    private int priority;

    public Arrow(boolean bl, int n) {
        this(bl, n, 0);
    }

    public Arrow(boolean bl, int n, int n2) {
        this.descending = bl;
        this.size = n;
        this.priority = n2;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color = component == null ? Color.GRAY : component.getBackground();
        int n3 = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
        int n4 = this.descending ? n3 : -n3;
        n2 = n2 + 5 * this.size / 6 + (this.descending ? -n4 : 0);
        int n5 = this.descending ? 1 : -1;
        graphics.translate(n, n2);
        graphics.setColor(color.darker());
        graphics.drawLine(n3 / 2, n4, 0, 0);
        graphics.drawLine(n3 / 2, n4 + n5, 0, n5);
        graphics.setColor(color.brighter());
        graphics.drawLine(n3 / 2, n4, n3, 0);
        graphics.drawLine(n3 / 2, n4 + n5, n3, n5);
        if (this.descending) {
            graphics.setColor(color.darker().darker());
        } else {
            graphics.setColor(color.brighter().brighter());
        }
        graphics.drawLine(n3, 0, 0, 0);
        graphics.setColor(color);
        graphics.translate(-n, -n2);
    }

    public int getIconWidth() {
        return this.size;
    }

    public int getIconHeight() {
        return this.size;
    }
}

