/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.prefs.Preferences;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.gui.swing.LearnPanel;
import jmemorize.gui.swing.MainFrame;
import jmemorize.util.PreferencesTool;

public class Strategy
implements CategoryObserver {
    public static final int SCHEDULE_LEVELS = 10;
    public static final String[] SCHEDULE_PRESETS;
    public static final int SIDES_NORMAL = 0;
    public static final int SIDES_FLIPPED = 1;
    public static final int SIDES_RANDOM = 2;
    public static final int CATEGORY_ORDER_FIXED = 0;
    public static final int CATEGORY_ORDER_RANDOM = 1;
    private static String PREFS_LIMIT_CARDS_ENABLED;
    private static String PREFS_LIMIT_TIME_ENABLED;
    private static String PREFS_LIMIT_CARDS;
    private static String PREFS_LIMIT_TIME;
    private static String PREFS_RETEST_FAILED_CARDS;
    private static String PREFS_SCHEDULE_PRESET;
    private static String PREFS_SCHEDULE;
    private static String PREFS_SIDES;
    private static String PREFS_GROUP_BY_CATEGORY;
    private static String PREFS_CATEGORY_ORDER;
    private static String PREFS_SHUFFLE_CARDS;
    private boolean m_quit;
    private int m_cardsChecked;
    private int m_cardsLearned;
    private Date m_testDate;
    private List m_cards;
    private Card m_currentCard;
    private List m_cardsCheckedList;
    private Map m_categoryGroupOrder;
    private MainFrame m_frame;
    private LearnPanel m_repeatCardPanel;
    private Category m_category;
    private boolean m_learnUnlearnedCards;
    private boolean m_learnExpiredCards;
    private int m_schedulePreset;
    private int[] m_schedule;
    private boolean m_limitCardsEnabled;
    private boolean m_limitTimeEnabled;
    private int m_limitCards;
    private int m_limitTime;
    private boolean m_retestFailedCards;
    private int m_sides;
    private boolean m_groupByCategory;
    private int m_categoryOrder;
    private boolean m_shuffleCards;
    private Preferences m_prefs;
    private Random m_rand = new Random();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Strategy(Preferences preferences, MainFrame mainFrame) {
        this.m_prefs = preferences;
        this.loadFromPreferences();
        this.m_frame = mainFrame;
        this.m_repeatCardPanel = mainFrame.getLearnPanel();
    }

    public void setCards(Category category, boolean bl, boolean bl2) {
        this.m_category = category;
        this.m_learnUnlearnedCards = bl;
        this.m_learnExpiredCards = bl2;
    }

    public Card getCard() {
        return this.m_currentCard;
    }

    public List getCards() {
        return this.m_cards;
    }

    public Category getCategory() {
        return this.m_category;
    }

    public void setCardLimit(boolean bl, int n) {
        this.m_limitCardsEnabled = bl;
        this.m_limitCards = n;
    }

    public boolean isCardLimitEnabled() {
        return this.m_limitCardsEnabled;
    }

    public int getCardLimit() {
        return this.m_limitCards;
    }

    public void setTimeLimit(boolean bl, int n) {
        this.m_limitTimeEnabled = bl;
        this.m_limitTime = n;
    }

    public boolean isTimeLimitEnabled() {
        return this.m_limitTimeEnabled;
    }

    public int getTimeLimit() {
        return this.m_limitTime;
    }

    public void setRetestFailedCards(boolean bl) {
        this.m_retestFailedCards = bl;
    }

    public boolean isRetestFailedCards() {
        return this.m_retestFailedCards;
    }

    public void setSides(int n) {
        this.m_sides = n;
    }

    public int getSides() {
        return this.m_sides;
    }

    public void setCustomSchedule(int[] nArray) {
        this.m_schedule = nArray;
        this.m_schedulePreset = -1;
    }

    public int[] getSchedule() {
        return this.m_schedule;
    }

    public List getCheckedCardsList() {
        return this.m_cardsCheckedList;
    }

    public void setSchedulePreset(int n) {
        this.m_schedule = Strategy.getPresetSchedule(n);
        this.m_schedulePreset = n;
    }

    public int getSchedulePreset() {
        return this.m_schedulePreset;
    }

    public void setGroupByCategory(boolean bl) {
        this.m_groupByCategory = bl;
    }

    public boolean isGroupByCategory() {
        return this.m_groupByCategory;
    }

    public void setCategoryOrder(int n) {
        this.m_categoryOrder = n;
    }

    public int getCategoryOrder() {
        return this.m_categoryOrder;
    }

    public void setShuffleCards(boolean bl) {
        this.m_shuffleCards = bl;
    }

    public boolean isShuffleCards() {
        return this.m_shuffleCards;
    }

    public static int[] getPresetSchedule(int n) {
        int[] nArray = new int[10];
        switch (n) {
            case 0: {
                for (int i = 0; i < 10; ++i) {
                    nArray[i] = 1440;
                }
                return nArray;
            }
            case 1: {
                for (int i = 0; i < 10; ++i) {
                    nArray[i] = (i + 1) * 60 * 24;
                }
                return nArray;
            }
            case 2: {
                for (int i = 0; i < 10; ++i) {
                    nArray[i] = (int)Math.pow(i + 1, 2.0) * 60 * 24;
                }
                return nArray;
            }
            case 3: {
                for (int i = 0; i < 10; ++i) {
                    nArray[i] = (int)Math.pow(2.0, i) * 60 * 24;
                }
                return nArray;
            }
        }
        throw new IllegalArgumentException("Preset schedule with this index not found.");
    }

    public void startLearning() {
        ArrayList arrayList = new ArrayList();
        if (this.m_learnUnlearnedCards) {
            arrayList.addAll(this.m_category.getUnlearnedCards());
        }
        if (this.m_learnExpiredCards) {
            arrayList.addAll(this.m_category.getExpiredCards());
        }
        this.m_category.addObserver(this);
        this.m_categoryGroupOrder = this.m_groupByCategory ? this.createCategoryGroupOrder() : null;
        this.m_quit = false;
        this.m_cardsChecked = 0;
        this.m_cardsLearned = 0;
        this.m_cardsCheckedList = new LinkedList();
        this.m_testDate = new Date();
        this.m_cards = arrayList;
        Collections.sort(this.m_cards, new CardComparator());
        this.m_repeatCardPanel.onStartLearning(this);
        this.m_frame.gotoLearnMode();
        this.checkNextCard();
    }

    public void endLearning() {
        this.m_category.removeObserver(this);
        this.m_repeatCardPanel.onEndLearning();
        this.m_frame.gotoBrowseMode();
    }

    public void cardChecked(boolean bl) {
        Card card = this.m_currentCard;
        ++this.m_cardsChecked;
        if (bl) {
            ++this.m_cardsLearned;
            long l = this.m_testDate.getTime() + 60000L * (long)this.m_schedule[Math.min(card.getLevel(), 9)];
            this.m_category.raiseCardLevel(card, this.m_testDate, new Date(l));
        } else {
            if (this.m_retestFailedCards) {
                this.m_cards.add(card);
            }
            this.m_category.resetCardLevel(card, this.m_testDate);
        }
    }

    public void cardSkipped() {
        this.m_cards.add(this.m_currentCard);
        this.m_category.reappendCard(this.m_currentCard);
    }

    public void storeToPreferences() {
        this.m_prefs.putBoolean(PREFS_LIMIT_CARDS_ENABLED, this.m_limitCardsEnabled);
        this.m_prefs.putBoolean(PREFS_LIMIT_TIME_ENABLED, this.m_limitTimeEnabled);
        this.m_prefs.putInt(PREFS_LIMIT_CARDS, this.m_limitCards);
        this.m_prefs.putInt(PREFS_LIMIT_TIME, this.m_limitTime);
        this.m_prefs.putBoolean(PREFS_RETEST_FAILED_CARDS, this.m_retestFailedCards);
        this.m_prefs.putBoolean(PREFS_SHUFFLE_CARDS, this.m_shuffleCards);
        this.m_prefs.putInt(PREFS_SIDES, this.m_sides);
        this.m_prefs.putInt(PREFS_SCHEDULE_PRESET, this.m_schedulePreset);
        PreferencesTool.putIntArray(this.m_prefs, PREFS_SCHEDULE, this.m_schedule);
        this.m_prefs.putBoolean(PREFS_GROUP_BY_CATEGORY, this.m_groupByCategory);
        this.m_prefs.putInt(PREFS_CATEGORY_ORDER, this.m_categoryOrder);
    }

    public void onTimer() {
        this.m_quit = true;
    }

    public void onCardEvent(int n, Card card, int n2) {
        switch (n) {
            case 0: {
                this.m_cards.add(card);
                break;
            }
            case 1: {
                if (card == this.m_currentCard) {
                    this.checkNextCard();
                } else {
                    this.m_cards.remove(card);
                }
                this.m_cardsCheckedList.remove(card);
                break;
            }
            case 2: {
                if (card != this.m_currentCard) break;
                this.checkNextCard();
            }
        }
    }

    public void onCategoryEvent(int n, Category category) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private void checkNextCard() {
        if (this.m_quit || this.m_cards.size() == 0 || this.m_limitCardsEnabled && this.m_cardsLearned >= this.m_limitCards) {
            this.endLearning();
        } else {
            if (this.m_shuffleCards) {
                Card card;
                Card card2 = (Card)this.m_cards.get(0);
                int n = card2.getLevel();
                Category category = card2.getCategory();
                int n2 = 0;
                Iterator iterator = this.m_cards.iterator();
                while (iterator.hasNext() && (card = (Card)iterator.next()).getLevel() == n && (!this.m_groupByCategory || card.getCategory() == category)) {
                    ++n2;
                }
                this.m_currentCard = (Card)this.m_cards.remove(this.m_rand.nextInt(n2));
            } else {
                this.m_currentCard = (Card)this.m_cards.remove(0);
            }
            boolean bl = this.m_sides == 2 ? this.m_rand.nextInt(2) == 1 : this.m_sides == 1;
            this.m_cardsCheckedList.remove(this.m_currentCard);
            this.m_cardsCheckedList.add(this.m_currentCard);
            this.m_repeatCardPanel.showCard(this.m_currentCard, bl);
        }
    }

    private Map createCategoryGroupOrder() {
        List list = this.m_category.getSubtreeList();
        if (this.m_categoryOrder == 1) {
            Collections.shuffle(list);
        }
        HashMap<Category, Integer> hashMap = new HashMap<Category, Integer>();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Category category = (Category)iterator.next();
            hashMap.put(category, new Integer(n++));
        }
        return hashMap;
    }

    private void loadFromPreferences() {
        this.m_limitCardsEnabled = this.m_prefs.getBoolean(PREFS_LIMIT_CARDS_ENABLED, false);
        this.m_limitTimeEnabled = this.m_prefs.getBoolean(PREFS_LIMIT_TIME_ENABLED, true);
        this.m_limitCards = this.m_prefs.getInt(PREFS_LIMIT_CARDS, 20);
        this.m_limitTime = this.m_prefs.getInt(PREFS_LIMIT_TIME, 20);
        this.m_retestFailedCards = this.m_prefs.getBoolean(PREFS_RETEST_FAILED_CARDS, true);
        this.m_sides = this.m_prefs.getInt(PREFS_SIDES, 0);
        int n = this.m_prefs.getInt(PREFS_SCHEDULE_PRESET, 1);
        if (n > -1) {
            this.setSchedulePreset(n);
        } else {
            int[] nArray = PreferencesTool.getIntArray(this.m_prefs, PREFS_SCHEDULE);
            if (nArray != null) {
                this.setCustomSchedule(nArray);
            } else {
                this.setSchedulePreset(1);
            }
        }
        this.m_groupByCategory = this.m_prefs.getBoolean(PREFS_GROUP_BY_CATEGORY, true);
        this.m_categoryOrder = this.m_prefs.getInt(PREFS_CATEGORY_ORDER, 0);
        this.m_shuffleCards = this.m_prefs.getBoolean(PREFS_SHUFFLE_CARDS, true);
    }

    static {
        $assertionsDisabled = !Strategy.class.desiredAssertionStatus();
        SCHEDULE_PRESETS = new String[]{"Constant", "Linear (Default)", "Quadratic", "Exponential", "Custom"};
        PREFS_LIMIT_CARDS_ENABLED = "limit.cards.enabled";
        PREFS_LIMIT_TIME_ENABLED = "limit.time.enabled";
        PREFS_LIMIT_CARDS = "limit.cards";
        PREFS_LIMIT_TIME = "limit.time";
        PREFS_RETEST_FAILED_CARDS = "retest-failed-cards";
        PREFS_SCHEDULE_PRESET = "schedule.preset";
        PREFS_SCHEDULE = "schedule.values";
        PREFS_SIDES = "sides";
        PREFS_GROUP_BY_CATEGORY = "card-order.group-by-category";
        PREFS_CATEGORY_ORDER = "card-order.group-by-category.order";
        PREFS_SHUFFLE_CARDS = "card-order.shuffle";
    }

    private class CardComparator
    implements Comparator {
        private CardComparator() {
        }

        public int compare(Object object, Object object2) {
            Date date;
            Date date2;
            Card card = (Card)object;
            Card card2 = (Card)object2;
            if (card.getLevel() < card2.getLevel()) {
                return -1;
            }
            if (card.getLevel() > card2.getLevel()) {
                return 1;
            }
            if (Strategy.this.m_groupByCategory) {
                int n;
                int n2 = (Integer)Strategy.this.m_categoryGroupOrder.get(card.getCategory());
                if (n2 < (n = ((Integer)Strategy.this.m_categoryGroupOrder.get(card2.getCategory())).intValue())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
            }
            return (date2 = card.getDateTouched()).before(date = card2.getDateTouched()) ? -1 : 1;
        }
    }
}

