/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import jmemorize.strategy.Strategy;

public class TimerPanel
extends JPanel
implements ActionListener {
    private DecimalFormat m_formater = new DecimalFormat("##00");
    private int m_secondsPassed;
    private int m_secondsTarget;
    private Timer m_timer;
    private JProgressBar m_bar = new JProgressBar();
    private JTextField m_textField = new JTextField();
    private Strategy m_strategy;

    public void start(Strategy strategy, int n) {
        this.m_strategy = strategy;
        this.m_secondsTarget = n;
        this.m_secondsPassed = 0;
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.m_secondsTarget > -1) {
            this.m_bar.setValue(0);
            this.m_bar.setStringPainted(true);
            this.m_bar.setString(this.getTimeString());
            this.add((Component)this.m_bar, "Center");
        } else {
            this.m_textField.setText(this.getTimeString());
            this.m_textField.setHorizontalAlignment(0);
            this.m_textField.setEditable(false);
            this.add((Component)this.m_textField, "Center");
        }
        this.m_timer = new Timer(1000, this);
        this.m_timer.start();
    }

    public void start(Strategy strategy) {
        this.start(strategy, -1);
    }

    public void stop() {
        this.m_timer.stop();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ++this.m_secondsPassed;
        if (this.m_secondsTarget > -1) {
            this.m_bar.setValue(100 * this.m_secondsPassed / this.m_secondsTarget);
            this.m_bar.setString(this.getTimeString());
        } else {
            this.m_textField.setText(this.getTimeString());
        }
        if (this.m_secondsPassed == this.m_secondsTarget) {
            this.m_timer.stop();
            this.m_strategy.onTimer();
        }
    }

    protected String getTimeString() {
        if (this.m_secondsTarget > -1) {
            if (this.m_secondsTarget <= this.m_secondsPassed) {
                return this.timeString(this.m_secondsTarget, this.m_secondsTarget) + this.timeExtString(this.m_secondsTarget) + " passed!";
            }
            return this.timeString(this.m_secondsPassed, this.m_secondsTarget) + " / " + this.timeString(this.m_secondsTarget, this.m_secondsTarget) + this.timeExtString(this.m_secondsTarget);
        }
        return this.timeString(this.m_secondsPassed, this.m_secondsPassed) + this.timeExtString(this.m_secondsPassed);
    }

    protected String timeString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 3600) {
            return n / 3600 + ":" + this.m_formater.format(n / 60 % 60) + ":" + this.m_formater.format(n % 60);
        }
        if (n2 > 60) {
            return n / 60 + ":" + this.m_formater.format(n % 60);
        }
        return Integer.toString(n);
    }

    protected String timeExtString(int n) {
        if (n > 3600) {
            return " hours";
        }
        if (n > 60) {
            return " minutes";
        }
        return " seconds";
    }
}

