/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.Main;
import jmemorize.gui.swing.EditCardFrame;
import jmemorize.gui.swing.NewCardFrame;

public class NewCardManager {
    private Dimension m_lastSize = new Dimension(400, 250);
    private List m_newCardFrames = new LinkedList();
    private List m_createdCards = new ArrayList();

    public void addNewCardWindow(Category category) {
        if (this.m_newCardFrames.isEmpty()) {
            NewCardFrame newCardFrame = new NewCardFrame(this, null, this.m_lastSize, category);
            this.m_newCardFrames.add(0, newCardFrame);
        } else {
            this.addNewCardWindow((NewCardFrame)this.m_newCardFrames.get(0), category);
        }
    }

    public void addNewCardWindow(NewCardFrame newCardFrame, Category category) {
        Point point = new Point(newCardFrame.getX() + 25, newCardFrame.getY() + 25);
        NewCardFrame newCardFrame2 = new NewCardFrame(this, point, newCardFrame.getCardPanelSize(), category);
        this.m_newCardFrames.add(0, newCardFrame2);
    }

    public void editRecentlyCreatedCards() {
        if (!this.m_createdCards.isEmpty()) {
            EditCardFrame.getInstance().showCard((Card)this.m_createdCards.get(this.m_createdCards.size() - 1), this.m_createdCards, Main.getInstance().getLesson().getRootCategory());
        }
    }

    public boolean closeAllFrames() {
        ArrayList arrayList = new ArrayList(this.m_newCardFrames);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            NewCardFrame newCardFrame = (NewCardFrame)iterator.next();
            if (newCardFrame.close()) continue;
            return false;
        }
        return true;
    }

    public Dimension getLastSize() {
        return this.m_lastSize;
    }

    public void onNewCardCreated(Card card) {
        this.m_createdCards.add(card);
    }

    public void onNewCardFrameClosed(NewCardFrame newCardFrame) {
        this.m_newCardFrames.remove(newCardFrame);
        if (this.m_newCardFrames.size() == 0) {
            this.m_lastSize = newCardFrame.getCardPanelSize();
        }
    }
}

