/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.Main;
import jmemorize.gui.swing.CardSidesPanel;
import jmemorize.gui.swing.CategoryComboBox;
import jmemorize.gui.swing.NewCardManager;
import jmemorize.util.EscapableFrame;

class NewCardFrame
extends EscapableFrame {
    private NewCardManager m_manager;
    private CardSidesPanel m_cardPanel = new CardSidesPanel();
    private JButton m_createMoreButton;
    private CategoryComboBox m_categoryBox = new CategoryComboBox();
    private Action m_editRecentAction = new EditRecentCardAction();

    public NewCardFrame(NewCardManager newCardManager, Point point, Dimension dimension, Category category) {
        this.m_manager = newCardManager;
        this.initComponents();
        this.m_categoryBox.setRootCategory(Main.getInstance().getLesson().getRootCategory());
        this.m_categoryBox.setSelectedCategory(category);
        this.m_cardPanel.reset();
        this.m_cardPanel.setPreferredSize(dimension);
        this.pack();
        if (point == null) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(point);
        }
        this.setVisible(true);
    }

    public boolean close() {
        if (this.m_cardPanel.getFrontside().trim().length() > 0 || this.m_cardPanel.getBackside().trim().length() > 0) {
            int n = JOptionPane.showConfirmDialog(this, "Card data is about to be dismissed.\nDo you want to create the card before the window is closed?", "Warning", 1, 2);
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                return this.create(false);
            }
        }
        this.closeWindow();
        return true;
    }

    Dimension getCardPanelSize() {
        return this.m_cardPanel.getSize();
    }

    private void initComponents() {
        this.getContentPane().add((Component)this.buildToolBar(), "North");
        this.getContentPane().add((Component)this.buildMainPanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonBar(), "South");
        this.getRootPane().setDefaultButton(this.m_createMoreButton);
        this.pack();
        this.setTitle("Create Card");
    }

    private JToolBar buildToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new JButton(new NewWindowAction()));
        jToolBar.add(new JButton(this.m_editRecentAction));
        return jToolBar;
    }

    private JPanel buildMainPanel() {
        this.m_cardPanel.setBorder(Borders.DIALOG_BORDER);
        FormLayout formLayout = new FormLayout("12px, 28dlu, 3dlu, default:grow, 13px", "10px, p, fill:d:grow");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(new EtchedBorder());
        defaultFormBuilder.addLabel("Category", cellConstraints.xy(2, 2));
        defaultFormBuilder.add((Component)this.m_categoryBox, cellConstraints.xy(4, 2));
        defaultFormBuilder.add((Component)this.m_cardPanel, cellConstraints.xyw(1, 3, 5));
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildButtonBar() {
        this.m_createMoreButton = new JButton("Add and create next");
        this.m_createMoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCardFrame.this.create(true);
            }
        });
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCardFrame.this.create(false);
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCardFrame.this.closeWindow();
            }
        });
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("right:p:grow, p, 3dlu, 40dlu, 3dlu, 40dlu", "p");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixedNarrow(this.m_createMoreButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGridded(jButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGridded(jButton2);
        buttonBarBuilder.setBorder(new EmptyBorder(5, 5, 5, 5));
        return buttonBarBuilder.getPanel();
    }

    private boolean create(boolean bl) {
        try {
            Card card = new Card(this.m_cardPanel.getFrontside(), this.m_cardPanel.getBackside());
            this.m_categoryBox.getSelectedCategory().addCard(card);
            this.m_manager.onNewCardCreated(card);
            this.m_cardPanel.reset();
            if (!bl) {
                this.closeWindow();
            }
            return !bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "You need to specify both card sides.", "Bad card sides", 0);
            return false;
        }
    }

    private void closeWindow() {
        this.m_manager.onNewCardFrameClosed(this);
        this.dispose();
    }

    private class EditRecentCardAction
    extends AbstractAction {
        public EditRecentCardAction() {
            this.putValue("Name", "Edit recently");
            this.putValue("MnemonicKey", new Integer(1));
            this.putValue("ShortDescription", "Edit recently created card");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_edit.gif")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewCardFrame.this.m_manager.editRecentlyCreatedCards();
        }
    }

    private class NewWindowAction
    extends AbstractAction {
        public NewWindowAction() {
            this.putValue("Name", "New window");
            this.putValue("MnemonicKey", new Integer(7));
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_add.gif")));
            this.putValue("ShortDescription", "Open another new add card window");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewCardFrame.this.m_manager.addNewCardWindow(NewCardFrame.this, NewCardFrame.this.m_categoryBox.getSelectedCategory());
        }
    }
}

