/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.core.Lesson;
import jmemorize.core.Main;
import jmemorize.gui.swing.CardCategoryTransferHandler;
import jmemorize.gui.swing.CategoryComboBox;
import jmemorize.gui.swing.CategoryTree;
import jmemorize.gui.swing.DeckChartPanel;
import jmemorize.gui.swing.DeckTablePanel;
import jmemorize.gui.swing.EditCardFrame;
import jmemorize.gui.swing.FindFrame;
import jmemorize.gui.swing.LearnPanel;
import jmemorize.gui.swing.LearnSettingsFrame;
import jmemorize.gui.swing.NewCardManager;
import jmemorize.gui.swing.StatusBar;
import jmemorize.strategy.Strategy;
import jmemorize.util.RecentItems;

public class MainFrame
extends JFrame
implements CategoryObserver,
PropertyChangeListener,
RecentItems.RecentItemsObserver {
    public static final DateFormat SHORT_DATE_FORMATER;
    public static final DateFormat LONG_DATE_FORMATER;
    public static final TransferHandler TRANSFER_HANDLER;
    private static final int BROWSING_MODE = 0;
    private static final int LEARNING_MODE = 1;
    private AddCardAction m_addCardAction = new AddCardAction();
    private EditCardAction m_editCardAction = new EditCardAction();
    private ResetCardAction m_resetCardAction = new ResetCardAction();
    private ExitAction m_exitAction = new ExitAction();
    private LearnAction m_learnAction = new LearnAction();
    private NewLessonAction m_newLessonAction = new NewLessonAction();
    private OpenLessonAction m_openLessonAction = new OpenLessonAction();
    private RemoveAction m_removeAction = new RemoveAction();
    private SaveLessonAction m_saveLessonAction = new SaveLessonAction();
    private SaveLessonAsAction m_saveLessonAsAction = new SaveLessonAsAction();
    private ShowCategoryTreeAction m_showCategoryTreeAction = new ShowCategoryTreeAction();
    private AddCategoryAction m_addCategoryAction = new AddCategoryAction();
    private CopyAction m_copyAction = new CopyAction();
    private CutAction m_cutAction = new CutAction();
    private PasteAction m_pasteAction = new PasteAction();
    private FindAction m_findAction = new FindAction();
    private AboutAction m_aboutAction = new AboutAction();
    private List m_openRecentLessonActions = new ArrayList();
    private CategoryComboBox m_categoryBox;
    private CategoryTree m_categoryTree;
    private DeckTablePanel m_deckTablePanel;
    private DeckChartPanel m_lessonInfoPanel;
    private LearnPanel m_learnPanel;
    private StatusBar m_statusBar = new StatusBar();
    private LearnSettingsFrame m_learnSettingsFrame;
    private NewCardManager m_newCardManager = new NewCardManager();
    private JPanel m_bottomPanel;
    private JButton m_showTreeButton;
    private JSplitPane m_horizontalSplitPane;
    private JScrollPane m_treeScrollPane;
    private JMenu m_fileMenu;
    private FindFrame m_findFrame = new FindFrame();
    private Main m_main;
    private Category m_currentCategory;
    private int m_mode;
    private boolean m_showCategoryTree;
    private boolean m_showCategoryTreeOld;
    private int m_categoryTreeWidth = Main.USER_PREFS.getInt("category-tree.width", 150);
    private List m_focusedCards;
    private List m_focusedCategories;
    private static final String PREFS_TREE_WIDTH = "category-tree.width";
    static final /* synthetic */ boolean $assertionsDisabled;

    public MainFrame() {
        this.m_main = Main.getInstance();
        this.m_main.getRecentFiles().addObserver(this);
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.showCategoryTree(false);
        this.m_lessonInfoPanel.setFrame(this);
        this.m_lessonInfoPanel.setMinimumSize(new Dimension(100, 150));
        this.m_deckTablePanel.getCardTable().setStatusBar(this.m_statusBar);
        this.m_learnPanel.setStatusBar(this.m_statusBar);
        this.setLesson(this.m_main.getLesson());
        this.gotoBrowseMode();
    }

    public void setLesson(Lesson lesson) {
        Category category = lesson.getRootCategory();
        this.m_categoryBox.setRootCategory(category);
        this.m_categoryTree.setRootCategory(category);
        this.setCurrentCategory(category);
        EditCardFrame.getInstance().setVisible(false);
        this.updateFrameTitle();
    }

    public void setCurrentCategory(Category category) {
        if (category == null) {
            return;
        }
        if (this.m_currentCategory != null) {
            this.m_currentCategory.removeObserver(this);
        }
        this.m_currentCategory = category;
        this.m_currentCategory.addObserver(this);
        this.m_lessonInfoPanel.setCategory(category);
        this.m_deckTablePanel.setCategory(category);
        this.m_categoryBox.setSelectedCategory(category);
        this.m_categoryTree.setSelectedCategory(category);
        if (this.m_mode != 1) {
            this.m_focusedCards = null;
            this.m_focusedCategories = new ArrayList(1);
            this.m_focusedCategories.add(category);
        }
        this.updateButtons();
    }

    public void showCategoryTree(boolean bl) {
        if (!bl) {
            if (this.m_showCategoryTree) {
                this.m_categoryTreeWidth = this.m_horizontalSplitPane.getDividerLocation();
            }
            this.m_horizontalSplitPane.setDividerSize(0);
            this.m_showTreeButton.setSelected(false);
            this.m_treeScrollPane.setVisible(false);
        } else {
            if (!this.m_showCategoryTree) {
                this.m_horizontalSplitPane.setDividerLocation(this.m_categoryTreeWidth);
            }
            this.m_showTreeButton.setSelected(true);
            this.m_treeScrollPane.setVisible(true);
            this.m_horizontalSplitPane.setDividerSize(5);
        }
        this.m_showCategoryTree = bl;
    }

    public void startLearning() {
        this.m_showCategoryTreeOld = this.m_showCategoryTree;
        this.showCategoryTree(false);
        this.m_main.getStrategy().startLearning();
    }

    public DeckTablePanel getDeckPanel() {
        return this.m_deckTablePanel;
    }

    public LearnPanel getLearnPanel() {
        return this.m_learnPanel;
    }

    public void gotoBrowseMode() {
        ((CardLayout)this.m_bottomPanel.getLayout()).show(this.m_bottomPanel, "deckCard");
        this.m_focusedCategories = null;
        this.m_focusedCards = this.m_deckTablePanel.getCardTable().getSelectedCards();
        this.m_deckTablePanel.getCardTable().addPropertyChangeListener("selectedCards", this);
        this.m_learnPanel.removePropertyChangeListener("selectedCards", this);
        this.m_mode = 0;
        this.updateButtons();
        this.showCategoryTree(this.m_showCategoryTreeOld);
    }

    public void gotoLearnMode() {
        ((CardLayout)this.m_bottomPanel.getLayout()).show(this.m_bottomPanel, "repeatCard");
        this.m_focusedCategories = null;
        this.m_focusedCards = this.m_learnPanel.getSelectedCards();
        this.m_learnPanel.addPropertyChangeListener("selectedCards", this);
        this.m_deckTablePanel.getCardTable().removePropertyChangeListener("selectedCards", this);
        this.m_deckTablePanel.showDeck(-1);
        this.m_mode = 1;
        this.updateButtons();
    }

    public void onCategoryEvent(int n, Category category) {
        if (n == 1) {
            this.setCurrentCategory(this.m_main.getLesson().getRootCategory());
        }
        this.updateButtons();
    }

    public void onCardEvent(int n, Card card, int n2) {
        this.updateButtons();
    }

    public void onRecentItemChange(RecentItems recentItems) {
        this.buildFileMenu();
    }

    public void onPreferencesFrameClosed() {
        this.setEnabled(true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectedCards")) {
            this.m_focusedCards = (List)propertyChangeEvent.getNewValue();
            this.m_focusedCategories = null;
            this.updateButtons();
        }
    }

    private void updateButtons() {
        if (!$assertionsDisabled && this.m_focusedCards != null && this.m_focusedCategories != null) {
            throw new AssertionError((Object)"cards and categories cant be focused at the same time");
        }
        this.m_newLessonAction.setEnabled(this.m_mode != 1);
        this.m_openLessonAction.setEnabled(this.m_mode != 1);
        Iterator iterator = this.m_openRecentLessonActions.iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            action.setEnabled(this.m_mode != 1);
        }
        this.m_saveLessonAction.setEnabled(this.m_mode != 1 && this.m_main.getLesson().isModified());
        this.m_saveLessonAsAction.setEnabled(this.m_mode != 1);
        this.m_editCardAction.setEnabled(this.m_focusedCards != null && this.m_focusedCards.size() > 0);
        this.m_copyAction.setEnabled(this.m_mode != 1 && (this.m_focusedCards != null || this.m_focusedCategories != null));
        this.m_cutAction.setEnabled(this.m_mode != 1 && (this.m_focusedCards != null || this.m_focusedCategories != null));
        this.m_pasteAction.setEnabled(this.m_mode != 1 && (this.getToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(CardCategoryTransferHandler.CARDS_FLAVOR) || this.getToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(CardCategoryTransferHandler.CATEGORY_FLAVOR)));
        this.m_removeAction.setEnabled(this.m_focusedCards != null && this.m_focusedCards.size() > 0 || this.m_focusedCategories != null && this.m_main.getLesson() != null && !this.m_focusedCategories.contains(this.m_main.getLesson().getRootCategory()));
        this.m_resetCardAction.setEnabled(this.m_focusedCards != null && this.m_focusedCards.size() > 0);
        this.m_addCategoryAction.setEnabled(this.m_mode != 1);
        this.m_learnAction.setEnabled(this.m_mode != 1 && !this.m_currentCategory.getLearnableCards().isEmpty());
        this.m_exitAction.setEnabled(this.m_mode != 1);
        this.m_showCategoryTreeAction.setEnabled(this.m_mode != 1);
    }

    public void loadLesson(File file) {
        try {
            this.m_main.loadLesson(file);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "An error occured while loading " + file.getName() + "\n" + "Failed to load lesson.", "Error", 0);
        }
    }

    private void saveLesson(File file) {
        try {
            this.m_main.saveLesson(file);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "An error occured while saving " + file.getName() + "\n" + "Lesson has not been saved.", "Error", 0);
            iOException.printStackTrace();
        }
    }

    private void updateFrameTitle() {
        String string = Main.PROPERTIES.getProperty("project.name");
        String string2 = Main.PROPERTIES.getProperty("project.version");
        File file = this.m_main.getLesson().getFile();
        if (file != null && !this.getTitle().equals(file.getName())) {
            this.setTitle(file.getName() + " - " + string + " " + string2);
        } else if (file == null) {
            this.setTitle("New lesson - " + string + " " + string2);
        }
    }

    private JComponent getEditFocusOwner() {
        if (this.m_focusedCards != null) {
            return this.m_deckTablePanel.getCardTable();
        }
        if (this.m_focusedCategories != null) {
            return this.m_categoryTree;
        }
        return null;
    }

    private boolean confirmCloseLesson() {
        EditCardFrame editCardFrame = EditCardFrame.getInstance();
        if (editCardFrame.isVisible() && !editCardFrame.close()) {
            return false;
        }
        this.m_findFrame.setVisible(false);
        if (!this.m_newCardManager.closeAllFrames()) {
            return false;
        }
        if (this.m_main.getLesson().isModified()) {
            int n = JOptionPane.showConfirmDialog(this, "Lesson has been modified. Do you want to save before exiting?", "Warning", 1, 2);
            if (n == 0) {
                this.m_saveLessonAction.save();
            }
            return n == 0 || n == 1;
        }
        return true;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.m_lessonInfoPanel = new DeckChartPanel();
        this.m_learnPanel = new LearnPanel();
        this.m_deckTablePanel = new DeckTablePanel();
        this.m_learnSettingsFrame = new LearnSettingsFrame(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.buildOperationsBar());
        jPanel2.add(this.buildCategoryBar());
        this.m_categoryTree = new CategoryTree();
        this.m_categoryTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MainFrame.this.selectionChanged(treeSelectionEvent);
            }
        });
        this.m_treeScrollPane = new JScrollPane(this.m_categoryTree);
        this.m_bottomPanel = new JPanel(new CardLayout());
        this.m_bottomPanel.add((Component)this.m_deckTablePanel, "deckCard");
        this.m_bottomPanel.add((Component)this.m_learnPanel, "repeatCard");
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setPreferredSize(new Dimension(16, 500));
        jSplitPane.setTopComponent(this.m_lessonInfoPanel);
        jSplitPane.setBottomComponent(this.m_bottomPanel);
        jPanel.setPreferredSize(new Dimension(800, 500));
        jPanel.add((Component)jSplitPane, "Center");
        this.m_horizontalSplitPane = new JSplitPane(1);
        this.m_horizontalSplitPane.setDividerLocation(this.m_categoryTreeWidth);
        this.m_horizontalSplitPane.setDividerSize(4);
        this.m_horizontalSplitPane.setLeftComponent(this.m_treeScrollPane);
        this.m_horizontalSplitPane.setRightComponent(jPanel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.getContentPane().add((Component)this.m_horizontalSplitPane, "Center");
        this.getContentPane().add((Component)this.m_statusBar, "South");
        this.setJMenuBar(this.buildMenu());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.exitForm(windowEvent);
            }
        });
        this.pack();
    }

    private JPanel buildCategoryBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setMargin(new Insets(2, 2, 2, 2));
        this.m_showTreeButton = new JButton(this.m_showCategoryTreeAction);
        this.m_showTreeButton.setPreferredSize(new Dimension(100, 21));
        jToolBar.add(this.m_showTreeButton);
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setMaximumSize(new Dimension(20, Short.MAX_VALUE));
        jSeparator.setPreferredSize(new Dimension(6, 0));
        jToolBar.add(jSeparator);
        JLabel jLabel = new JLabel("Category", 0);
        jLabel.setPreferredSize(new Dimension(60, 15));
        jToolBar.add(jLabel);
        this.m_categoryBox = new CategoryComboBox();
        this.m_categoryBox.setPreferredSize(new Dimension(24, 24));
        this.m_categoryBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.categoryBoxActionPerformed();
            }
        });
        jToolBar.add(this.m_categoryBox);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EtchedBorder());
        jPanel.add((Component)jToolBar, "North");
        return jPanel;
    }

    private JPanel buildOperationsBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new JButton(this.m_newLessonAction));
        jToolBar.add(new JButton(this.m_openLessonAction));
        jToolBar.add(new JButton(this.m_saveLessonAction));
        jToolBar.add(new JButton(this.m_addCardAction));
        jToolBar.add(new JButton(this.m_editCardAction));
        jToolBar.add(new JButton(this.m_resetCardAction));
        jToolBar.add(new JButton(this.m_removeAction));
        jToolBar.add(new JButton(this.m_addCategoryAction));
        jToolBar.add(new JButton(this.m_findAction));
        jToolBar.add(new JButton(this.m_learnAction));
        JPanel jPanel = new JPanel(new FlowLayout(0, 1, 1));
        jPanel.add(jToolBar);
        return jPanel;
    }

    private JMenuBar buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.m_fileMenu = new JMenu("File");
        jMenuBar.add(this.m_fileMenu);
        this.buildFileMenu();
        JMenu jMenu = new JMenu("Edit");
        jMenu.add(new JMenuItem(this.m_editCardAction));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.m_cutAction));
        jMenu.add(new JMenuItem(this.m_copyAction));
        jMenu.add(new JMenuItem(this.m_pasteAction));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.m_removeAction));
        jMenu.add(new JMenuItem(this.m_resetCardAction));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.m_findAction));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Lesson");
        jMenu2.add(new JMenuItem(this.m_addCardAction));
        jMenu2.add(new JMenuItem(this.m_addCategoryAction));
        jMenu2.addSeparator();
        jMenu2.add(new JMenuItem(this.m_learnAction));
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.add(new JMenuItem(this.m_aboutAction));
        jMenuBar.add(jMenu3);
        return jMenuBar;
    }

    private void buildFileMenu() {
        this.m_fileMenu.removeAll();
        this.m_fileMenu.add(new JMenuItem(this.m_newLessonAction));
        this.m_fileMenu.add(new JMenuItem(this.m_openLessonAction));
        this.m_fileMenu.add(new JMenuItem(this.m_saveLessonAction));
        this.m_fileMenu.add(new JMenuItem(this.m_saveLessonAsAction));
        int n = this.m_main.getRecentFiles().size();
        if (n > 0) {
            this.m_fileMenu.addSeparator();
        }
        for (int i = 0; i < n; ++i) {
            OpenRecentLessonAction openRecentLessonAction = new OpenRecentLessonAction(i);
            this.m_openRecentLessonActions.add(openRecentLessonAction);
            JMenuItem jMenuItem = new JMenuItem(openRecentLessonAction);
            this.m_fileMenu.add(jMenuItem);
        }
        this.m_fileMenu.addSeparator();
        this.m_fileMenu.add(new JMenuItem(this.m_exitAction));
    }

    private void categoryBoxActionPerformed() {
        this.setCurrentCategory(this.m_categoryBox.getSelectedCategory());
    }

    private void selectionChanged(TreeSelectionEvent treeSelectionEvent) {
        this.setCurrentCategory(this.m_categoryTree.getSelectedCategory());
    }

    private void exitForm(WindowEvent windowEvent) {
        this.m_exitAction.exit();
    }

    static {
        $assertionsDisabled = !MainFrame.class.desiredAssertionStatus();
        SHORT_DATE_FORMATER = DateFormat.getDateTimeInstance(3, 3);
        LONG_DATE_FORMATER = DateFormat.getDateTimeInstance(0, 2);
        TRANSFER_HANDLER = new CardCategoryTransferHandler();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class LessonFileFilter
    extends FileFilter {
        private LessonFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".jml");
        }

        public String getDescription() {
            return "jMemorize Lessons";
        }
    }

    private class AboutAction
    extends AbstractAction {
        public AboutAction() {
            this.putValue("Name", "About");
            this.putValue("ShortDescription", "About this application");
            this.putValue("MnemonicKey", new Integer(1));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Main.PROPERTIES.getProperty("project.name");
            String string2 = Main.PROPERTIES.getProperty("project.version");
            String string3 = Main.PROPERTIES.getProperty("buildId");
            JOptionPane.showMessageDialog(MainFrame.this, "<html><b>" + string + " " + string2 + "</b> (" + string3 + ")<br><br>" + "Homepage:<br>http://www.riad.de/jmemorize<br><br>" + "2004-2005 Riad Djemili" + "</html>", "About", 1);
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            this.putValue("Name", "Exit");
            this.putValue("ShortDescription", "Exit application");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/blank.gif")));
            this.putValue("MnemonicKey", new Integer(2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.exit();
        }

        public void exit() {
            if (MainFrame.this.confirmCloseLesson()) {
                Main.USER_PREFS.putInt(MainFrame.PREFS_TREE_WIDTH, MainFrame.this.m_showTreeButton.isSelected() ? MainFrame.this.m_horizontalSplitPane.getDividerLocation() : MainFrame.this.m_categoryTreeWidth);
                MainFrame.this.m_main.exit();
            }
        }
    }

    private class FindAction
    extends AbstractAction {
        public FindAction() {
            this.putValue("Name", "Find");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/find.gif")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
            this.putValue("ShortDescription", "Find cards");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.m_findFrame.show(MainFrame.this.m_main.getLesson().getRootCategory(), MainFrame.this.m_currentCategory);
        }
    }

    private class AddCategoryAction
    extends AbstractAction {
        public AddCategoryAction() {
            this.putValue("Name", "Add category");
            this.putValue("ShortDescription", "Add new category");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/category_add.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog("Input the name of the new category that you want to create.");
            if (string != null && string.trim().length() > 0) {
                MainFrame.this.m_currentCategory.addCategoryChild(new Category(string.trim()));
            }
        }
    }

    private class LearnAction
    extends AbstractAction {
        public LearnAction() {
            this.putValue("Name", "Learn");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/learn.gif")));
            this.putValue("ShortDescription", "Start lerning session with all unlearned and expired cards");
            this.putValue("MnemonicKey", new Integer(1));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.m_learnSettingsFrame.show(MainFrame.this.m_main.getStrategy(), MainFrame.this.m_main.getLesson().getRootCategory(), MainFrame.this.m_currentCategory);
            MainFrame.this.setEnabled(false);
        }
    }

    private class ShowCategoryTreeAction
    extends AbstractAction {
        public ShowCategoryTreeAction() {
            this.putValue("Name", "Category tree");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/tree.gif")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 0));
            this.putValue("ShortDescription", "Show/Hide category tree");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.showCategoryTree(!MainFrame.this.m_showTreeButton.isSelected());
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", "Remove");
            this.putValue("MnemonicKey", new Integer(1));
            this.putValue("ShortDescription", "Remove currently selected item(s)");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/remove.gif")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.m_focusedCards != null) {
                int n = JOptionPane.showConfirmDialog(MainFrame.this, "You are about to delete " + MainFrame.this.m_focusedCards.size() + " card(s). Do you want to continue?", "Category Deletion", 0, 3);
                if (n != 0) {
                    return;
                }
                Iterator iterator = MainFrame.this.m_focusedCards.iterator();
                while (iterator.hasNext()) {
                    Card card = (Card)iterator.next();
                    MainFrame.this.m_currentCategory.removeCard(card);
                }
            } else {
                Iterator iterator = MainFrame.this.m_focusedCategories.iterator();
                while (iterator.hasNext()) {
                    int n;
                    Category category = (Category)iterator.next();
                    int n2 = category.getCards().size();
                    if (n2 > 0 && (n = JOptionPane.showConfirmDialog(MainFrame.this, "Deleting category " + category.getName() + " will delete " + n2 + " cards. Do you want to continue?", "Category Deletion", 0, 3)) != 0) continue;
                    category.remove();
                }
            }
        }
    }

    private class ResetCardAction
    extends AbstractAction {
        public ResetCardAction() {
            this.putValue("Name", "Reset card");
            this.putValue("MnemonicKey", new Integer(1));
            this.putValue("ShortDescription", "Reset card statistics");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_reset.gif")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(MainFrame.this, "You are about to reset " + MainFrame.this.m_focusedCards.size() + " card(s). Do you want to continue?", "Card Reset", 0, 3);
            if (n == 0) {
                Iterator iterator = MainFrame.this.m_focusedCards.iterator();
                while (iterator.hasNext()) {
                    Card card = (Card)iterator.next();
                    MainFrame.this.m_currentCategory.resetCard(card);
                }
            }
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            this.putValue("Name", "Paste");
            this.putValue("MnemonicKey", new Integer(1));
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/edit_paste.gif")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CardCategoryTransferHandler.getPasteAction().actionPerformed(new ActionEvent(MainFrame.this.getEditFocusOwner(), 1001, "paste"));
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            this.putValue("Name", "Cut");
            this.putValue("MnemonicKey", new Integer(2));
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/edit_cut.gif")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CardCategoryTransferHandler.getCutAction().actionPerformed(new ActionEvent(MainFrame.this.getEditFocusOwner(), 1001, "cut"));
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            this.putValue("Name", "Copy");
            this.putValue("MnemonicKey", new Integer(1));
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/edit_copy.gif")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CardCategoryTransferHandler.getCopyAction().actionPerformed(new ActionEvent(MainFrame.this.getEditFocusOwner(), 1001, "copy"));
        }
    }

    private class EditCardAction
    extends AbstractAction {
        private List m_editCardFrames = new LinkedList();

        public EditCardAction() {
            this.putValue("Name", "Edit card");
            this.putValue("MnemonicKey", new Integer(1));
            this.putValue("ShortDescription", "Edit and view card details");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_edit.gif")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.m_mode == 1) {
                Strategy strategy = MainFrame.this.m_main.getStrategy();
                EditCardFrame.getInstance().showCard(strategy.getCard(), strategy.getCheckedCardsList(), strategy.getCategory());
            } else {
                MainFrame.this.m_deckTablePanel.editCards();
            }
        }
    }

    private class AddCardAction
    extends AbstractAction {
        public AddCardAction() {
            this.putValue("Name", "Add card");
            this.putValue("MnemonicKey", new Integer(7));
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_add.gif")));
            this.putValue("ShortDescription", "Add new card");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.m_newCardManager.addNewCardWindow(MainFrame.this.m_currentCategory);
        }
    }

    private class SaveLessonAsAction
    extends AbstractAction {
        public SaveLessonAsAction() {
            this.putValue("Name", "Save as");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/file_saveas.gif")));
            this.putValue("ShortDescription", "Save lesson as..");
            this.putValue("MnemonicKey", new Integer(2));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 3));
        }

        public void saveAs() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("."));
            jFileChooser.setFileFilter(new LessonFileFilter());
            int n = jFileChooser.showSaveDialog(MainFrame.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().endsWith(".jml")) {
                    file = new File(file.getAbsolutePath() + ".jml");
                }
                MainFrame.this.saveLesson(file);
                MainFrame.this.updateFrameTitle();
                MainFrame.this.updateButtons();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.saveAs();
        }
    }

    private class SaveLessonAction
    extends AbstractAction {
        public SaveLessonAction() {
            this.putValue("Name", "Save");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/file_save.gif")));
            this.putValue("ShortDescription", "Save lesson");
            this.putValue("MnemonicKey", new Integer(1));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        }

        public void save() {
            File file = MainFrame.this.m_main.getLesson().getFile();
            if (file != null) {
                MainFrame.this.saveLesson(file);
            } else {
                new SaveLessonAsAction().saveAs();
            }
            MainFrame.this.updateButtons();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.save();
        }
    }

    private class OpenRecentLessonAction
    extends AbstractAction {
        private int m_id;

        public OpenRecentLessonAction(int n) {
            this.m_id = n;
            File file = new File(MainFrame.this.m_main.getRecentFiles().get(n));
            this.putValue("Name", n + 1 + ". " + file.getName());
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/blank.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.confirmCloseLesson()) {
                File file = new File(MainFrame.this.m_main.getRecentFiles().get(this.m_id));
                MainFrame.this.loadLesson(file);
            }
        }
    }

    private class OpenLessonAction
    extends AbstractAction {
        public OpenLessonAction() {
            this.putValue("Name", "Open");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/file_open.gif")));
            this.putValue("ShortDescription", "Open lesson file");
            this.putValue("MnemonicKey", new Integer(49));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.confirmCloseLesson()) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("."));
                jFileChooser.setFileFilter(new LessonFileFilter());
                int n = jFileChooser.showOpenDialog(MainFrame.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    MainFrame.this.loadLesson(file);
                    File file2 = new File(MainFrame.this.m_main.getRecentFiles().get(0));
                    String string = file2.getParent();
                    ((MainFrame)MainFrame.this).m_learnPanel.recent_lesson = string + File.separator + "WAV" + File.separator;
                }
            }
        }
    }

    private class NewLessonAction
    extends AbstractAction {
        public NewLessonAction() {
            this.putValue("Name", "New");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/file_new.gif")));
            this.putValue("ShortDescription", "Create empty lesson");
            this.putValue("MnemonicKey", new Integer(1));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 3));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.confirmCloseLesson()) {
                MainFrame.this.m_main.createNewLesson();
            }
        }
    }
}

