/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmemorize.core.Category;
import jmemorize.gui.swing.LearnSettingPanels;
import jmemorize.gui.swing.MainFrame;
import jmemorize.strategy.Strategy;
import jmemorize.util.EscapableFrame;

public class LearnSettingsFrame
extends EscapableFrame {
    private static final String[] PANEL_NAMES = new String[]{"General", "Advanced", "Scheduling"};
    private Strategy m_strategy;
    private MainFrame m_frame;
    private LearnSettingPanels m_learnSettingsPanels;
    private JPanel m_settingsPanel = new JPanel(new CardLayout());
    private JButton m_applyButton = new JButton("Apply");
    private JList m_sideList = new JList<String>(PANEL_NAMES);

    public LearnSettingsFrame(MainFrame mainFrame) {
        this.m_frame = mainFrame;
        this.m_learnSettingsPanels = new LearnSettingPanels();
        this.initComponents();
    }

    public void show(Strategy strategy, Category category, Category category2) {
        this.m_strategy = strategy;
        this.m_learnSettingsPanels.setStrategy(this.m_strategy);
        this.m_learnSettingsPanels.setCategory(category, category2);
        this.setVisible(true);
    }

    public boolean close() {
        this.m_frame.onPreferencesFrameClosed();
        this.setVisible(false);
        return true;
    }

    private void initComponents() {
        this.getContentPane().add((Component)this.buildMainPanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonBar(), "South");
        this.setTitle("Start Learn Session");
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private JPanel buildMainPanel() {
        this.m_settingsPanel.add((Component)this.buildGeneralSettingsPanel(), PANEL_NAMES[0]);
        this.m_settingsPanel.add((Component)this.buildAdvancedPanel(), PANEL_NAMES[1]);
        this.m_settingsPanel.add((Component)this.m_learnSettingsPanels.buildSchedulePanel(), PANEL_NAMES[2]);
        this.m_settingsPanel.setBorder(new EtchedBorder());
        this.m_sideList.setBorder(new EtchedBorder());
        this.m_sideList.setSelectionMode(0);
        this.m_sideList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CardLayout cardLayout = (CardLayout)LearnSettingsFrame.this.m_settingsPanel.getLayout();
                cardLayout.show(LearnSettingsFrame.this.m_settingsPanel, PANEL_NAMES[LearnSettingsFrame.this.m_sideList.getSelectedIndex()]);
            }
        });
        this.m_sideList.setSelectedIndex(0);
        FormLayout formLayout = new FormLayout("70dlu, 3dlu, p:grow", "fill:p:grow");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.add((Component)this.m_sideList, cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_settingsPanel, cellConstraints.xy(3, 1));
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildGeneralSettingsPanel() {
        FormLayout formLayout = new FormLayout("p:grow", "p, 15dlu, p");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.add((Component)this.m_learnSettingsPanels.buildCardsPanel(), cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_learnSettingsPanels.buildLimiterPanel(), cellConstraints.xy(1, 3));
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildAdvancedPanel() {
        FormLayout formLayout = new FormLayout("p:grow", "p, 9dlu, p");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.add((Component)this.m_learnSettingsPanels.buildCardOrderPanel(), cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_learnSettingsPanels.buildSidesModePanel(), cellConstraints.xy(1, 3));
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildButtonBar() {
        JButton jButton = new JButton("Start Session!");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnSettingsFrame.this.apply();
                LearnSettingsFrame.this.close();
                LearnSettingsFrame.this.m_frame.startLearning();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnSettingsFrame.this.close();
            }
        });
        this.m_applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnSettingsFrame.this.apply();
            }
        });
        JPanel jPanel = ButtonBarFactory.buildOKCancelApplyBar(jButton, jButton2, this.m_applyButton);
        jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private void apply() {
        this.m_learnSettingsPanels.applySettings();
        this.m_strategy.storeToPreferences();
    }
}

