/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmemorize.core.Category;
import jmemorize.gui.swing.CategoryComboBox;
import jmemorize.strategy.Strategy;

public class LearnSettingPanels
extends JFrame {
    private JSpinner m_cardLimitSpinner = new JSpinner(new SpinnerNumberModel(20, 1, 300, 1));
    private JSpinner m_timeLimitSpinner = new JSpinner(new SpinnerNumberModel(20, 1, 300, 1));
    private boolean m_updatingSpinners = false;
    private CategoryComboBox m_categoryComboBox = new CategoryComboBox();
    private JRadioButton m_allCardsButton = new JRadioButton("Learn all unlearned and expired cards.", true);
    private JRadioButton m_unlearnedCardsButton = new JRadioButton("Learn only unlearned cards.");
    private JRadioButton m_expiredCardsButton = new JRadioButton("Learn only expired cards.");
    private JCheckBox m_timeLimitCheckBox = new JCheckBox("End session when a certain time limit has been reached.");
    private JCheckBox m_cardLimitCheckBox = new JCheckBox("End session when a certain card limit has been reached.");
    private JCheckBox m_dontRetestCheckBox = new JCheckBox("Dont retest cards that have been failed in this session.");
    private JRadioButton m_sidesNormalButton = new JRadioButton("Learn in normal mode.");
    private JRadioButton m_sidesFlippedButton = new JRadioButton("Learn with flipped card sides.");
    private JRadioButton m_sidesRandomButton = new JRadioButton("Learn in random mode with card sides being randomly flipped.");
    private JCheckBox m_categoryGroupsCheckBox = new JCheckBox("Group cards by categories while learning.");
    private JRadioButton m_categoryOrderFixedButton = new JRadioButton("Show categories in fixed natural order.");
    private JRadioButton m_categoryOrderRandomButton = new JRadioButton("Show categories in random order.");
    private JCheckBox m_shuffleCardsCheckBox = new JCheckBox("Shuffle cards of all decks and categories.");
    private JSpinner[] m_scheduleDays = new JSpinner[10];
    private JSpinner[] m_scheduleHours = new JSpinner[10];
    private JSpinner[] m_scheduleMinutes = new JSpinner[10];
    private JComboBox m_schedulePresetsComboBox = new JComboBox<String>(Strategy.SCHEDULE_PRESETS);
    private Strategy m_strategy;

    public LearnSettingPanels() {
        for (int i = 0; i < 10; ++i) {
            this.m_scheduleDays[i] = new JSpinner(new SpinnerNumberModel(1, 0, 999, 1));
            this.m_scheduleHours[i] = new JSpinner(new SpinnerNumberModel(1, 0, 23, 1));
            this.m_scheduleMinutes[i] = new JSpinner(new SpinnerNumberModel(1, 0, 59, 1));
        }
        this.m_categoryComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnSettingPanels.this.categoryBoxActionPerformed();
            }
        });
    }

    public void setStrategy(Strategy strategy) {
        this.m_strategy = strategy;
        this.resetSettings();
    }

    public void setCategory(Category category, Category category2) {
        this.m_categoryComboBox.setRootCategory(category);
        this.m_categoryComboBox.setSelectedCategory(category2);
        this.updateCardButtons();
    }

    public void resetSettings() {
        this.m_cardLimitCheckBox.setSelected(this.m_strategy.isCardLimitEnabled());
        this.m_timeLimitCheckBox.setSelected(this.m_strategy.isTimeLimitEnabled());
        this.updateLimiterCheckboxes();
        this.m_dontRetestCheckBox.setSelected(!this.m_strategy.isRetestFailedCards());
        this.m_cardLimitSpinner.setValue(new Integer(this.m_strategy.getCardLimit()));
        this.m_timeLimitSpinner.setValue(new Integer(this.m_strategy.getTimeLimit()));
        switch (this.m_strategy.getSides()) {
            case 0: {
                this.m_sidesNormalButton.setSelected(true);
                break;
            }
            case 1: {
                this.m_sidesFlippedButton.setSelected(true);
                break;
            }
            default: {
                this.m_sidesRandomButton.setSelected(true);
            }
        }
        int n = this.m_strategy.getSchedulePreset();
        this.m_schedulePresetsComboBox.setSelectedIndex(n > -1 ? n : 4);
        this.updateScheduleSpinners(this.m_strategy.getSchedule());
        this.m_categoryGroupsCheckBox.setSelected(this.m_strategy.isGroupByCategory());
        if (this.m_strategy.getCategoryOrder() == 0) {
            this.m_categoryOrderFixedButton.setSelected(true);
        } else {
            this.m_categoryOrderRandomButton.setSelected(true);
        }
        this.updateCategoryOrderButtons();
        this.m_shuffleCardsCheckBox.setSelected(this.m_strategy.isShuffleCards());
    }

    public void applySettings() {
        this.m_strategy.setCards(this.getSelectedCategory(), this.m_allCardsButton.isSelected() || this.m_unlearnedCardsButton.isSelected(), this.m_allCardsButton.isSelected() || this.m_expiredCardsButton.isSelected());
        this.m_strategy.setCardLimit(this.m_cardLimitCheckBox.isSelected(), this.intValue(this.m_cardLimitSpinner));
        this.m_strategy.setTimeLimit(this.m_timeLimitCheckBox.isSelected(), this.intValue(this.m_timeLimitSpinner));
        this.m_strategy.setRetestFailedCards(!this.m_dontRetestCheckBox.isSelected());
        this.m_strategy.setSides(this.m_sidesNormalButton.isSelected() ? 0 : (this.m_sidesFlippedButton.isSelected() ? 1 : 2));
        int n = this.m_schedulePresetsComboBox.getSelectedIndex();
        if (n < 4) {
            this.m_strategy.setSchedulePreset(n);
        } else {
            int[] nArray = new int[10];
            for (int i = 0; i < 10; ++i) {
                nArray[i] = 1440 * this.intValue(this.m_scheduleDays[i]) + 60 * this.intValue(this.m_scheduleHours[i]) + this.intValue(this.m_scheduleMinutes[i]);
            }
            this.m_strategy.setCustomSchedule(nArray);
        }
        this.m_strategy.setGroupByCategory(this.m_categoryGroupsCheckBox.isSelected());
        this.m_strategy.setCategoryOrder(this.m_categoryOrderRandomButton.isSelected() ? 1 : 0);
        this.m_strategy.setShuffleCards(this.m_shuffleCardsCheckBox.isSelected());
    }

    public Category getSelectedCategory() {
        return this.m_categoryComboBox.getSelectedCategory();
    }

    public JPanel buildCardsPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_allCardsButton);
        buttonGroup.add(this.m_unlearnedCardsButton);
        buttonGroup.add(this.m_expiredCardsButton);
        FormLayout formLayout = new FormLayout("p:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.addSeparator("Cards to learn", cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_categoryComboBox, cellConstraints.xy(1, 3));
        defaultFormBuilder.add((Component)this.m_allCardsButton, cellConstraints.xy(1, 5));
        defaultFormBuilder.add((Component)this.m_unlearnedCardsButton, cellConstraints.xy(1, 7));
        defaultFormBuilder.add((Component)this.m_expiredCardsButton, cellConstraints.xy(1, 9));
        return defaultFormBuilder.getPanel();
    }

    public JPanel buildCardOrderPanel() {
        this.m_categoryGroupsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnSettingPanels.this.updateCategoryOrderButtons();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_categoryOrderFixedButton);
        buttonGroup.add(this.m_categoryOrderRandomButton);
        FormLayout formLayout = new FormLayout("18dlu, p:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.addSeparator("Cards order", cellConstraints.xyw(1, 1, 2));
        defaultFormBuilder.add((Component)this.m_categoryGroupsCheckBox, cellConstraints.xyw(1, 3, 2));
        defaultFormBuilder.add((Component)this.m_categoryOrderFixedButton, cellConstraints.xy(2, 5));
        defaultFormBuilder.add((Component)this.m_categoryOrderRandomButton, cellConstraints.xy(2, 7));
        defaultFormBuilder.add((Component)this.m_shuffleCardsCheckBox, cellConstraints.xyw(1, 9, 2));
        return defaultFormBuilder.getPanel();
    }

    public JPanel buildSidesModePanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_sidesNormalButton);
        buttonGroup.add(this.m_sidesFlippedButton);
        buttonGroup.add(this.m_sidesRandomButton);
        this.m_sidesNormalButton.setSelected(true);
        FormLayout formLayout = new FormLayout("p:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.addSeparator("Side mode", cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_sidesNormalButton, cellConstraints.xy(1, 3));
        defaultFormBuilder.add((Component)this.m_sidesFlippedButton, cellConstraints.xy(1, 5));
        defaultFormBuilder.add((Component)this.m_sidesRandomButton, cellConstraints.xy(1, 7));
        return defaultFormBuilder.getPanel();
    }

    public JPanel buildLimiterPanel() {
        this.m_cardLimitCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnSettingPanels.this.updateLimiterCheckboxes();
            }
        });
        this.m_timeLimitCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnSettingPanels.this.updateLimiterCheckboxes();
            }
        });
        this.updateLimiterCheckboxes();
        FormLayout formLayout = new FormLayout("18dlu, 35dlu, left:d:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.addSeparator("Delimiters", cellConstraints.xyw(1, 1, 3));
        defaultFormBuilder.add((Component)this.m_timeLimitCheckBox, cellConstraints.xyw(1, 3, 3));
        defaultFormBuilder.addLabel("Minute limit", cellConstraints.xy(2, 5));
        defaultFormBuilder.add((Component)this.m_timeLimitSpinner, cellConstraints.xy(3, 5));
        defaultFormBuilder.add((Component)this.m_cardLimitCheckBox, cellConstraints.xyw(1, 7, 3));
        defaultFormBuilder.addLabel("Card limit", cellConstraints.xy(2, 9));
        defaultFormBuilder.add((Component)this.m_cardLimitSpinner, cellConstraints.xy(3, 9));
        defaultFormBuilder.add((Component)this.m_dontRetestCheckBox, cellConstraints.xyw(1, 11, 3));
        return defaultFormBuilder.getPanel();
    }

    public JPanel buildSchedulePanel() {
        this.m_schedulePresetsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnSettingPanels.this.onPresetScheduleSelected();
            }
        });
        FormLayout formLayout = new FormLayout("p, 20dlu:grow, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p,  3dlu,  p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p", "p, 15dlu,  p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p,  3dlu,  p, 3dlu, p, 3dlu, p, 3dlu");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.addLabel("Schedule Presets", cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_schedulePresetsComboBox, cellConstraints.xyw(3, 1, 11));
        for (int i = 0; i < 10; ++i) {
            this.addScheduleRow(defaultFormBuilder, cellConstraints, i);
        }
        return defaultFormBuilder.getPanel();
    }

    private void categoryBoxActionPerformed() {
        this.updateCardButtons();
    }

    private void addScheduleRow(PanelBuilder panelBuilder, CellConstraints cellConstraints, int n) {
        this.m_scheduleDays[n].addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LearnSettingPanels.this.spinnerValueChanged();
            }
        });
        this.m_scheduleHours[n].addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LearnSettingPanels.this.spinnerValueChanged();
            }
        });
        this.m_scheduleMinutes[n].addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LearnSettingPanels.this.spinnerValueChanged();
            }
        });
        panelBuilder.addLabel("Delay after level " + n, cellConstraints.xy(1, 3 + 2 * n));
        panelBuilder.add((Component)this.m_scheduleDays[n], cellConstraints.xy(3, 3 + 2 * n));
        panelBuilder.addLabel("Days", cellConstraints.xy(5, 3 + 2 * n));
        panelBuilder.add((Component)this.m_scheduleHours[n], cellConstraints.xy(7, 3 + 2 * n));
        panelBuilder.addLabel("Hours", cellConstraints.xy(9, 3 + 2 * n));
        panelBuilder.add((Component)this.m_scheduleMinutes[n], cellConstraints.xy(11, 3 + 2 * n));
        panelBuilder.addLabel("Minutes", cellConstraints.xy(13, 3 + 2 * n));
    }

    private void updateLimiterCheckboxes() {
        this.m_timeLimitSpinner.setEnabled(this.m_timeLimitCheckBox.isSelected());
        this.m_cardLimitSpinner.setEnabled(this.m_cardLimitCheckBox.isSelected());
    }

    private void updateCategoryOrderButtons() {
        this.m_categoryOrderRandomButton.setEnabled(this.m_categoryGroupsCheckBox.isSelected());
        this.m_categoryOrderFixedButton.setEnabled(this.m_categoryGroupsCheckBox.isSelected());
    }

    private void updateCardButtons() {
        boolean bl = !this.getSelectedCategory().getUnlearnedCards().isEmpty();
        boolean bl2 = !this.getSelectedCategory().getExpiredCards().isEmpty();
        this.m_unlearnedCardsButton.setEnabled(bl);
        this.m_expiredCardsButton.setEnabled(bl2);
        if (this.m_unlearnedCardsButton.isSelected() && !bl || this.m_expiredCardsButton.isSelected() && !bl2) {
            this.m_allCardsButton.setSelected(true);
        }
    }

    private void onPresetScheduleSelected() {
        int n = this.m_schedulePresetsComboBox.getSelectedIndex();
        if (n < 4) {
            int[] nArray = Strategy.getPresetSchedule(n);
            this.updateScheduleSpinners(nArray);
        }
    }

    private void updateScheduleSpinners(int[] nArray) {
        this.m_updatingSpinners = true;
        for (int i = 0; i < 10; ++i) {
            this.m_scheduleDays[i].setValue(new Integer(nArray[i] / 1440));
            this.m_scheduleHours[i].setValue(new Integer(nArray[i] % 1440 / 60));
            this.m_scheduleMinutes[i].setValue(new Integer(nArray[i] % 60));
        }
        this.m_updatingSpinners = false;
    }

    private void spinnerValueChanged() {
        if (!this.m_updatingSpinners) {
            this.m_schedulePresetsComboBox.setSelectedIndex(4);
        }
    }

    private int intValue(JSpinner jSpinner) {
        return ((SpinnerNumberModel)jSpinner.getModel()).getNumber().intValue();
    }
}

