/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.core.Main;
import jmemorize.gui.swing.CardCounterPanel;
import jmemorize.gui.swing.CardSidesPanel;
import jmemorize.gui.swing.StatusBar;
import jmemorize.gui.swing.TimerPanel;
import jmemorize.strategy.Strategy;

public class LearnPanel
extends JPanel
implements CategoryObserver {
    private AudioClip audioClip;
    public static final Color PANEL_COLOR;
    private Strategy m_strategy;
    private Card m_currentCard;
    private boolean m_flippedCard;
    private JButton m_showButton = new JButton("Show answer");
    private JButton m_yesButton = new JButton("Yes");
    private JTextPane m_questionTextPane = new JTextPane();
    private CardSidesPanel m_cardAnswerPanel = new CardSidesPanel();
    private JPanel m_answerMainPanel = this.buildAnswerPanel();
    private JPanel m_questionMainPanel = this.buildQuestionPanel();
    private JPanel m_cardPanel = new JPanel();
    private TimerPanel m_timerPanel = new TimerPanel();
    private CardCounterPanel m_cardCounterPanel = new CardCounterPanel();
    private JCheckBox m_categoryCheckBox = new JCheckBox("Show category");
    private JTextField m_categoryField = new JTextField();
    private JLabel m_flippedLabel = new JLabel("Flipped card sides", new ImageIcon(this.getClass().getResource("/resource/icons/card_flipped.gif")), 0);
    private StatusBar m_statusBar;
    public String recent_lesson = null;
    private static String PREFS_SHOW_CARD_CATEGORY;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LearnPanel() {
        this.initComponents();
    }

    public void showCard(Card card, boolean bl) {
        this.m_currentCard = card;
        this.m_flippedCard = bl;
        this.m_flippedLabel.setVisible(bl);
        this.updateTextPanes();
        this.updateCategoryField();
        this.showQuestion();
        this.putClientProperty("selectedCards", this.getSelectedCards());
        this.updateStatusBar();
    }

    public List getSelectedCards() {
        ArrayList<Card> arrayList = new ArrayList<Card>(1);
        arrayList.add(this.m_currentCard);
        return arrayList;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.m_statusBar = statusBar;
    }

    public void onStartLearning(Strategy strategy) {
        this.m_strategy = strategy;
        this.m_strategy.getCategory().addObserver(this);
        if (strategy.isTimeLimitEnabled()) {
            this.m_timerPanel.start(strategy, strategy.getTimeLimit() * 60);
        } else {
            this.m_timerPanel.start(strategy);
        }
        if (strategy.isCardLimitEnabled()) {
            this.m_cardCounterPanel.start(strategy.getCardLimit());
        } else {
            this.m_cardCounterPanel.start();
        }
        this.updateStatusBar();
    }

    public void onEndLearning() {
        this.m_timerPanel.stop();
        this.m_strategy.getCategory().removeObserver(this);
        if (this.m_statusBar != null) {
            this.m_statusBar.setLeftText("");
        }
    }

    public void onCardEvent(int n, Card card, int n2) {
        if (card == this.m_currentCard && n == 3) {
            this.updateTextPanes();
        }
    }

    public void onCategoryEvent(int n, Category category) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private void initComponents() {
        this.m_cardPanel.setLayout(new CardLayout());
        this.m_cardPanel.add((Component)this.m_questionMainPanel, "questionCard");
        this.m_cardPanel.add((Component)this.m_answerMainPanel, "answerCard");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildSidebarPanel(), "West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EtchedBorder());
        JPanel jPanel3 = this.buildCategoryPanel();
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)this.m_cardPanel, "Center");
        jPanel.add((Component)jPanel2, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    private JPanel buildCategoryPanel() {
        this.m_categoryCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.USER_PREFS.putBoolean(PREFS_SHOW_CARD_CATEGORY, LearnPanel.this.m_categoryCheckBox.isSelected());
                LearnPanel.this.updateCategoryField();
            }
        });
        this.m_categoryField.setEditable(false);
        this.m_categoryCheckBox.setSelected(Main.USER_PREFS.getBoolean(PREFS_SHOW_CARD_CATEGORY, true));
        FormLayout formLayout = new FormLayout("28dlu, 3dlu, p:grow, 3dlu, right:p", "20px");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(new EmptyBorder(10, 10, 7, 10));
        defaultFormBuilder.addLabel("Category", cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_categoryField, cellConstraints.xy(3, 1));
        defaultFormBuilder.add((Component)this.m_categoryCheckBox, cellConstraints.xy(5, 1));
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildQuestionPanel() {
        this.m_questionTextPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_questionTextPane, 20, 31);
        FormLayout formLayout = new FormLayout("28dlu, 3dlu, d:grow", "fill:p:grow");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(new EmptyBorder(5, 10, 5, 10));
        defaultFormBuilder.addLabel("Frontside", cellConstraints.xy(1, 1, "left, top"));
        defaultFormBuilder.add((Component)jScrollPane, cellConstraints.xy(3, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)defaultFormBuilder.getPanel(), "Center");
        jPanel.add((Component)this.buildQuestionButtonBar(), "South");
        return jPanel;
    }

    private JPanel buildQuestionButtonBar() {
        this.m_showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnPanel.this.showButtonActionPerformed(actionEvent);
            }
        });
        JButton jButton = new JButton("Skip card");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnPanel.this.m_strategy.cardSkipped();
            }
        });
        FormLayout formLayout = new FormLayout("right:p:grow, 3dlu, 60dlu, 3dlu, 60dlu", "p");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(new EmptyBorder(5, 5, 5, 10));
        defaultFormBuilder.addLabel("Try to remember the answer", cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_showButton, cellConstraints.xy(3, 1));
        defaultFormBuilder.add((Component)jButton, cellConstraints.xy(5, 1));
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildAnswerPanel() {
        this.m_cardAnswerPanel.setEditable(false);
        this.m_cardAnswerPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.m_cardAnswerPanel, "Center");
        jPanel.add((Component)this.buildAnswerButtonBar(), "South");
        return jPanel;
    }

    private JPanel buildAnswerButtonBar() {
        this.m_yesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnPanel.this.yesButtonActionPerformed(actionEvent);
            }
        });
        JButton jButton = new JButton("No");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnPanel.this.noButtonActionPerformed(actionEvent);
            }
        });
        FormLayout formLayout = new FormLayout("right:p:grow, 3dlu, 60dlu, 3dlu, 60dlu", "p");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(new EmptyBorder(5, 5, 5, 10));
        defaultFormBuilder.addLabel("Did you know the correct answer?", cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_yesButton, cellConstraints.xy(3, 1));
        defaultFormBuilder.add((Component)jButton, cellConstraints.xy(5, 1));
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildSidebarPanel() {
        this.m_timerPanel.setBackground(new Color(225, 230, 235));
        this.m_timerPanel.setPreferredSize(new Dimension(140, 22));
        this.m_cardCounterPanel.setBackground(new Color(225, 230, 235));
        this.m_cardCounterPanel.setPreferredSize(new Dimension(140, 22));
        JButton jButton = new JButton("Stop learning");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearnPanel.this.cancelLearningButtonActionPerformed(actionEvent);
            }
        });
        FormLayout formLayout = new FormLayout("center:170px:grow", "10px, p, 3dlu, p, 9dlu, p, 3dlu, p, 5dlu, fill:p:grow, 5dlu, p, 5px");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.addLabel("Timer", cellConstraints.xy(1, 2));
        defaultFormBuilder.add((Component)this.m_timerPanel, cellConstraints.xy(1, 4));
        defaultFormBuilder.addLabel("Card counter", cellConstraints.xy(1, 6));
        defaultFormBuilder.add((Component)this.m_cardCounterPanel, cellConstraints.xy(1, 8));
        defaultFormBuilder.add((Component)this.m_flippedLabel, cellConstraints.xy(1, 10));
        defaultFormBuilder.add((Component)jButton, cellConstraints.xy(1, 12));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBackground(new Color(225, 230, 235));
        jPanel.setBorder(new EtchedBorder());
        return jPanel;
    }

    private void updateTextPanes() {
        Object object;
        String string;
        String string2 = !this.m_flippedCard ? this.m_currentCard.getFrontSide() : this.m_currentCard.getBackSide();
        String string3 = string = !this.m_flippedCard ? this.m_currentCard.getBackSide() : this.m_currentCard.getFrontSide();
        if (!this.m_flippedCard) {
            int n = string2.length() <= 12 ? 48 : 24;
            object = this.m_questionTextPane.getFont().deriveFont(1, n);
            this.m_questionTextPane.setFont((Font)object);
        } else {
            Font font = this.m_questionTextPane.getFont().deriveFont(0, 12.0f);
            this.m_questionTextPane.setFont(font);
        }
        this.m_questionTextPane.setText(string2);
        this.m_cardAnswerPanel.setSidesBigSide(this.m_flippedCard, string2, string);
        String string4 = "[ |\t|\n]";
        object = !this.m_flippedCard ? string : string2;
        Pattern pattern = Pattern.compile(string4, 1);
        String[] stringArray = pattern.split((CharSequence)object);
        this.audioClip = null;
        if (stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = this.recent_lesson + stringArray[i] + ".WAV";
                boolean bl = new File(string5).exists();
                if (!bl) continue;
                try {
                    URL uRL = new URL("file:" + string5);
                    this.audioClip = Applet.newAudioClip(uRL);
                    i = stringArray.length;
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(malformedURLException.getMessage());
                }
            }
        }
    }

    private void updateCategoryField() {
        this.m_categoryField.setEnabled(this.m_categoryCheckBox.isSelected());
        this.m_categoryField.setText(this.m_categoryCheckBox.isSelected() ? this.m_currentCard.getCategory().getPath() + " (" + this.m_currentCard.getLevel() + ")" : "");
    }

    private void updateStatusBar() {
        if (this.m_statusBar != null) {
            this.m_statusBar.setLeftText("Learning category: " + this.m_strategy.getCategory().getName() + " " + "       Cards left: " + (this.m_strategy.getCards().size() + 1));
        }
    }

    private void showQuestion() {
        ((CardLayout)this.m_cardPanel.getLayout()).show(this.m_cardPanel, "questionCard");
        this.m_showButton.requestFocus();
    }

    private void showAnswer() {
        ((CardLayout)this.m_cardPanel.getLayout()).show(this.m_cardPanel, "answerCard");
        this.m_yesButton.requestFocus();
    }

    private void showButtonActionPerformed(ActionEvent actionEvent) {
        this.showAnswer();
        if (this.audioClip != null) {
            this.audioClip.play();
        }
    }

    private void cancelLearningButtonActionPerformed(ActionEvent actionEvent) {
        this.m_strategy.endLearning();
    }

    private void noButtonActionPerformed(ActionEvent actionEvent) {
        this.m_strategy.cardChecked(false);
    }

    private void yesButtonActionPerformed(ActionEvent actionEvent) {
        this.m_strategy.cardChecked(true);
        this.m_cardCounterPanel.incStats();
    }

    static {
        $assertionsDisabled = !LearnPanel.class.desiredAssertionStatus();
        PANEL_COLOR = new Color(225, 230, 235);
        PREFS_SHOW_CARD_CATEGORY = "show.card-category";
    }
}

