/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.core.Main;
import jmemorize.core.SearchTool;
import jmemorize.gui.swing.CardTable;
import jmemorize.gui.swing.CategoryComboBox;
import jmemorize.gui.swing.EditCardFrame;
import jmemorize.gui.swing.StatusBar;
import jmemorize.util.EscapableFrame;
import jmemorize.util.RecentItems;

public class FindFrame
extends EscapableFrame
implements CategoryObserver {
    private CardTable m_cardTable = new CardTable(Main.USER_PREFS.node("find.table"), new int[]{0, 1, 3});
    private JComboBox m_searchTextBox = new JComboBox();
    private RecentItems m_recentSearchTexts = new RecentItems(10, Main.USER_PREFS.node("recent.search.texts"));
    private JCheckBox m_matchCaseBox = new JCheckBox("Match case");
    private JRadioButton m_radioBothSides = new JRadioButton("Both sides", true);
    private JRadioButton m_radioFrontSide = new JRadioButton("Frontside");
    private JRadioButton m_radioBackSide = new JRadioButton("Backside");
    private CategoryComboBox m_categoryBox = new CategoryComboBox();
    private StatusBar m_statusBar = new StatusBar();
    private String m_searchText;
    private int m_searchSides;
    private boolean m_matchCase;
    private Category m_searchCategory;

    public FindFrame() {
        this.initComponents();
        this.setLocationRelativeTo(null);
    }

    public void show(Category category, Category category2) {
        this.m_categoryBox.setRootCategory(category);
        this.m_categoryBox.setSelectedCategory(category2);
        this.m_searchTextBox.requestFocus();
        this.setVisible(true);
    }

    public boolean close() {
        this.setVisible(false);
        return true;
    }

    public void onCardEvent(int n, Card card, int n2) {
        List list = this.m_cardTable.getView().getCards();
        if (n == 1) {
            list.remove(card);
        }
        this.m_cardTable.getView().setCards(list, this.m_searchCategory);
        this.updateStatusBar();
    }

    public void onCategoryEvent(int n, Category category) {
    }

    private void updateStatusBar() {
        this.m_statusBar.setCards(this.m_cardTable.getView().getCards());
    }

    private JPanel buildSearchPanel() {
        this.m_searchTextBox.setEditable(true);
        this.m_searchTextBox.setMaximumRowCount(10);
        this.m_searchTextBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                FindFrame.this.m_searchTextBox.setModel(new DefaultComboBoxModel<Object>(FindFrame.this.m_recentSearchTexts.getItems().toArray()));
            }
        });
        this.m_searchTextBox.addActionListener(new FindAction());
        JScrollPane jScrollPane = new JScrollPane(this.m_cardTable);
        jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        jScrollPane.setPreferredSize(new Dimension(500, 200));
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, pref:grow, 3dlu, pref:grow, 3dlu, pref:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 9dlu, fill:d:grow");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.addLabel("Search text", cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.m_searchTextBox, cellConstraints.xyw(3, 1, 5));
        defaultFormBuilder.addLabel("Category", cellConstraints.xy(1, 3));
        defaultFormBuilder.add((Component)this.m_categoryBox, cellConstraints.xyw(3, 3, 5));
        defaultFormBuilder.addLabel("Settings", cellConstraints.xy(1, 5));
        defaultFormBuilder.add((Component)this.m_radioBothSides, cellConstraints.xy(3, 5));
        defaultFormBuilder.add((Component)this.m_radioFrontSide, cellConstraints.xy(5, 5));
        defaultFormBuilder.add((Component)this.m_radioBackSide, cellConstraints.xy(7, 5));
        defaultFormBuilder.add((Component)this.m_matchCaseBox, cellConstraints.xy(3, 7));
        defaultFormBuilder.addSeparator("Results", cellConstraints.xyw(1, 9, 7));
        defaultFormBuilder.add((Component)jScrollPane, cellConstraints.xyw(1, 11, 7));
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildSearchBar() {
        JButton jButton = new JButton(new CloseAction());
        JButton jButton2 = new JButton(new FindAction());
        JPanel jPanel = ButtonBarFactory.buildRightAlignedBar(jButton2, jButton);
        jPanel.setBorder(new EmptyBorder(0, 5, 5, 10));
        this.getRootPane().setDefaultButton(jButton2);
        return jPanel;
    }

    private void initComponents() {
        this.setTitle("Find");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_radioBothSides);
        buttonGroup.add(this.m_radioFrontSide);
        buttonGroup.add(this.m_radioBackSide);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildSearchPanel(), "Center");
        jPanel.add((Component)this.buildSearchBar(), "South");
        jPanel.setBorder(new EtchedBorder());
        this.m_statusBar = new StatusBar();
        this.m_cardTable.setStatusBar(this.m_statusBar);
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.m_statusBar, "South");
        this.m_cardTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FindFrame.this.tableMouseClicked(mouseEvent);
            }
        });
        this.m_cardTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "Edit");
        this.m_cardTable.getActionMap().put("Edit", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindFrame.this.editCards();
            }
        });
        this.pack();
    }

    private void tableMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.editCards();
        }
    }

    private void editCards() {
        Card card = this.m_cardTable.getSelectedCard();
        List list = this.m_cardTable.getView().getCards();
        Category category = this.m_cardTable.getView().getCategory();
        EditCardFrame.getInstance().showCard(card, list, category, this.m_searchText, this.m_searchSides, this.m_matchCase);
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", "Close");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FindFrame.this.close();
        }
    }

    private class FindAction
    extends AbstractAction {
        public FindAction() {
            this.putValue("Name", "Find");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)FindFrame.this.m_searchTextBox.getSelectedItem();
            if (!string.equals("")) {
                FindFrame.this.m_searchText = string;
                FindFrame.this.m_recentSearchTexts.push(FindFrame.this.m_searchText);
                if (FindFrame.this.m_radioBothSides.isSelected()) {
                    FindFrame.this.m_searchSides = 2;
                } else {
                    FindFrame.this.m_searchSides = FindFrame.this.m_radioFrontSide.isSelected() ? 0 : 1;
                }
                if (FindFrame.this.m_searchCategory != null) {
                    FindFrame.this.m_searchCategory.removeObserver(FindFrame.this);
                }
                FindFrame.this.m_searchCategory = FindFrame.this.m_categoryBox.getSelectedCategory();
                FindFrame.this.m_searchCategory.addObserver(FindFrame.this);
                FindFrame.this.m_matchCase = FindFrame.this.m_matchCaseBox.isSelected();
                FindFrame.this.m_cardTable.getView().setCards(SearchTool.search(FindFrame.this.m_searchText, FindFrame.this.m_searchSides, FindFrame.this.m_matchCase, FindFrame.this.m_searchCategory.getCards()), FindFrame.this.m_searchCategory);
            }
        }
    }
}

