/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.gui.swing.CardSidesPanel;
import jmemorize.gui.swing.MainFrame;
import jmemorize.util.EscapableFrame;

public class EditCardFrame
extends EscapableFrame
implements CategoryObserver {
    private static final int MAX_TITLE_LENGTH = 80;
    private Action m_nextCardAction = new NextCardAction();
    private Action m_previousCardAction = new PreviousCardAction();
    private Action m_removeCardAction = new RemoveCardAction();
    private Action m_resetCardAction = new ResetCardAction();
    private Card m_currentCard;
    private int m_currentCardIndex;
    private ArrayList m_cards;
    private Category m_category;
    private JButton m_applyButton = new JButton("Apply");
    private CardSidesPanel m_cardPanel = new CardSidesPanel();
    private JTextField m_categoryField = new JTextField();
    private JTextField m_createdField = new JTextField();
    private JTextField m_testedField = new JTextField();
    private JTextField m_expiresField = new JTextField();
    private JTextField m_ratioField = new JTextField();
    private static EditCardFrame m_instance;
    private boolean m_searchCase;
    private int m_searchSide;
    private String m_searchText;

    public static EditCardFrame getInstance() {
        if (m_instance == null) {
            m_instance = new EditCardFrame();
        }
        return m_instance;
    }

    public void showCard(Card card) {
        ArrayList<Card> arrayList = new ArrayList<Card>(1);
        arrayList.add(card);
        this.showCard(card, arrayList, card.getCategory());
    }

    public void showCard(Card card, List list, Category category) {
        this.showCard(card, list, category, null, 0, true);
    }

    public void showCard(Card card, List list, Category category, String string, int n, boolean bl) {
        if (this.isVisible() && !this.confirmCardSides()) {
            return;
        }
        this.m_searchText = string;
        this.m_searchSide = n;
        this.m_searchCase = bl;
        this.m_currentCard = card;
        this.m_currentCardIndex = list.indexOf(card);
        this.m_cards = new ArrayList(list);
        if (this.m_category != null) {
            this.m_category.removeObserver(this);
        }
        this.m_category = category;
        if (this.m_category != null) {
            category.addObserver(this);
        }
        this.updatePanel();
        this.setVisible(true);
    }

    public boolean close() {
        if (this.confirmCardSides()) {
            this.setVisible(false);
            return true;
        }
        return false;
    }

    public void onCategoryEvent(int n, Category category) {
        if (n == 1) {
            if (category.contains(this.m_currentCard.getCategory())) {
                this.setVisible(false);
            }
            Iterator iterator = this.m_cards.iterator();
            while (iterator.hasNext()) {
                Card card = (Card)iterator.next();
                if (!category.contains(card.getCategory())) continue;
                this.m_cards.remove(card);
            }
            this.m_currentCardIndex = this.m_cards.indexOf(this.m_currentCard);
            this.updateActions();
        } else if (n == 3) {
            this.fillFields();
        }
    }

    public void onCardEvent(int n, Card card, int n2) {
        if (n == 2 && this.m_currentCard == card) {
            this.fillFields();
        }
        if (n == 1) {
            if (this.m_currentCard == card) {
                this.setVisible(false);
            }
            if (this.m_cards.remove(card)) {
                this.m_currentCardIndex = this.m_cards.indexOf(this.m_currentCard);
                this.updateActions();
            }
        }
    }

    private boolean confirmCardSides() {
        if (!this.m_cardPanel.getFrontside().equals(this.m_currentCard.getFrontSide()) || !this.m_cardPanel.getBackside().equals(this.m_currentCard.getBackSide())) {
            int n = JOptionPane.showConfirmDialog(this, "Card entries have been modified. Do you want to apply them before continuing?", "Warning", 1, 2);
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                return this.saveSides();
            }
        }
        return true;
    }

    private EditCardFrame() {
        this.initComponents();
        this.m_cardPanel.addDocumentListener(new SidesListener());
        this.setLocationRelativeTo(null);
    }

    private void updatePanel() {
        this.updateTitle();
        this.m_cardPanel.setSides(this.m_currentCard.getFrontSide(), this.m_currentCard.getBackSide());
        this.updateActions();
        this.fillFields();
        this.m_applyButton.setEnabled(false);
    }

    private void updateTitle() {
        String string = this.m_currentCard.getFrontSide();
        if ((string = string.replace('\n', ' ')).length() > 80) {
            string = string.substring(0, 80) + "...";
        }
        this.setTitle(string);
    }

    private void updateActions() {
        if (this.m_cards == null) {
            this.m_nextCardAction.setEnabled(false);
            this.m_previousCardAction.setEnabled(false);
        } else {
            this.m_previousCardAction.setEnabled(this.hasPrevious());
            this.m_nextCardAction.setEnabled(this.hasNext());
        }
    }

    private boolean hasNext() {
        return this.m_currentCardIndex < this.m_cards.size() - 1;
    }

    private boolean hasPrevious() {
        return this.m_currentCardIndex > 0;
    }

    private void showNext() {
        this.m_currentCard = (Card)this.m_cards.get(++this.m_currentCardIndex);
        this.updatePanel();
    }

    private void showPrevious() {
        this.m_currentCard = (Card)this.m_cards.get(--this.m_currentCardIndex);
        this.updatePanel();
    }

    private void fillFields() {
        this.m_categoryField.setText(this.m_currentCard.getCategory().getPath() + " (" + this.m_currentCard.getLevel() + ")");
        Date date = this.m_currentCard.getDateCreated();
        this.m_createdField.setText(MainFrame.LONG_DATE_FORMATER.format(date));
        date = this.m_currentCard.getDateTested();
        this.m_testedField.setText(date != null ? MainFrame.LONG_DATE_FORMATER.format(date) : "-");
        date = this.m_currentCard.getDateExpired();
        this.m_expiresField.setText(date != null ? MainFrame.LONG_DATE_FORMATER.format(date) : "-");
        if (this.m_currentCard.getTestsTotal() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Math.round(100.0 * (double)this.m_currentCard.getTestsHit() / (double)this.m_currentCard.getTestsTotal()));
            stringBuffer.append("%    (");
            stringBuffer.append(this.m_currentCard.getTestsHit());
            stringBuffer.append(" / ");
            stringBuffer.append(this.m_currentCard.getTestsTotal());
            stringBuffer.append(")");
            this.m_ratioField.setText(stringBuffer.toString());
        } else {
            this.m_ratioField.setText("-");
        }
    }

    private boolean saveSides() {
        try {
            this.m_currentCard.setSides(this.m_cardPanel.getFrontside(), this.m_cardPanel.getBackside());
            this.updateTitle();
            this.m_applyButton.setEnabled(false);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "You need to specify both card sides.", "Bad card sides", 0);
            return false;
        }
    }

    private void initComponents() {
        this.m_cardPanel.setBorder(Borders.DIALOG_BORDER);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new JButton(this.m_previousCardAction));
        jToolBar.add(new JButton(this.m_nextCardAction));
        jToolBar.add(new JButton(this.m_removeCardAction));
        jToolBar.add(new JButton(this.m_resetCardAction));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBorder(new EtchedBorder());
        jTabbedPane.setMinimumSize(new Dimension(380, 138));
        jTabbedPane.setPreferredSize(new Dimension(400, 426));
        jTabbedPane.addTab("Sides", this.m_cardPanel);
        jTabbedPane.addTab("Properties", this.buildPropertiesPanel());
        this.getContentPane().add((Component)jToolBar, "North");
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)this.buildBottomButtonBar(), "South");
        this.setTitle("Card Details");
        this.pack();
    }

    private JPanel buildBottomButtonBar() {
        JButton jButton = new JButton("Okay");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditCardFrame.this.saveSides();
                EditCardFrame.this.close();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditCardFrame.this.setVisible(false);
            }
        });
        this.m_applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditCardFrame.this.saveSides();
            }
        });
        JPanel jPanel = ButtonBarFactory.buildOKCancelApplyBar(jButton, jButton2, this.m_applyButton);
        jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private JPanel buildPropertiesPanel() {
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, d:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        this.m_categoryField.setEditable(false);
        this.m_createdField.setEditable(false);
        this.m_testedField.setEditable(false);
        this.m_expiresField.setEditable(false);
        this.m_ratioField.setEditable(false);
        defaultFormBuilder.addSeparator("General", cellConstraints.xyw(1, 1, 3));
        defaultFormBuilder.addLabel("Category", cellConstraints.xy(1, 3));
        defaultFormBuilder.add((Component)this.m_categoryField, cellConstraints.xy(3, 3));
        defaultFormBuilder.addLabel("Created", cellConstraints.xy(1, 5));
        defaultFormBuilder.add((Component)this.m_createdField, cellConstraints.xy(3, 5));
        defaultFormBuilder.addLabel("Tested", cellConstraints.xy(1, 7));
        defaultFormBuilder.add((Component)this.m_testedField, cellConstraints.xy(3, 7));
        defaultFormBuilder.addLabel("Expires", cellConstraints.xy(1, 9));
        defaultFormBuilder.add((Component)this.m_expiresField, cellConstraints.xy(3, 9));
        defaultFormBuilder.addSeparator("Learn History", cellConstraints.xyw(1, 11, 3));
        defaultFormBuilder.addLabel("Succes ratio", cellConstraints.xy(1, 13));
        defaultFormBuilder.add((Component)this.m_ratioField, cellConstraints.xy(3, 13));
        return defaultFormBuilder.getPanel();
    }

    private class SidesListener
    implements DocumentListener {
        private SidesListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (!EditCardFrame.this.m_applyButton.isEnabled()) {
                EditCardFrame.this.m_applyButton.setEnabled(true);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (!EditCardFrame.this.m_applyButton.isEnabled()) {
                EditCardFrame.this.m_applyButton.setEnabled(true);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (!EditCardFrame.this.m_applyButton.isEnabled()) {
                EditCardFrame.this.m_applyButton.setEnabled(true);
            }
        }
    }

    private class ResetCardAction
    extends AbstractAction {
        public ResetCardAction() {
            this.putValue("Name", "Reset card");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_reset.gif")));
            this.putValue("ShortDescription", "Resets current card");
            this.putValue("MnemonicKey", new Integer(3));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(EditCardFrame.this, "Resetting this card will move it back to the first deck.\nAre you sure?", "Card Reset", 0, 3);
            if (n == 0) {
                EditCardFrame.this.m_category.resetCard(EditCardFrame.this.m_currentCard);
            }
        }
    }

    private class RemoveCardAction
    extends AbstractAction {
        public RemoveCardAction() {
            this.putValue("Name", "Remove card");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/remove.gif")));
            this.putValue("ShortDescription", "Remove current card");
            this.putValue("MnemonicKey", new Integer(3));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(EditCardFrame.this, "Are you sure you want to delete this card?", "Card Deletion", 0, 3);
            if (n == 0) {
                Card card = EditCardFrame.this.m_currentCard;
                if (EditCardFrame.this.hasNext()) {
                    EditCardFrame.this.showNext();
                } else if (EditCardFrame.this.hasPrevious()) {
                    EditCardFrame.this.showPrevious();
                }
                card.getCategory().removeCard(card);
            }
        }
    }

    private class PreviousCardAction
    extends AbstractAction {
        public PreviousCardAction() {
            this.putValue("Name", "Previous card");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_prev.gif")));
            this.putValue("ShortDescription", "Display previous card");
            this.putValue("MnemonicKey", new Integer(1));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EditCardFrame.this.confirmCardSides()) {
                EditCardFrame.this.showPrevious();
            }
        }
    }

    private class NextCardAction
    extends AbstractAction {
        public NextCardAction() {
            this.putValue("Name", "Next card");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_next.gif")));
            this.putValue("ShortDescription", "Display next card");
            this.putValue("MnemonicKey", new Integer(1));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EditCardFrame.this.confirmCardSides()) {
                EditCardFrame.this.showNext();
            }
        }
    }
}

