/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.core.Main;
import jmemorize.gui.swing.CardTable;
import jmemorize.gui.swing.EditCardFrame;

public class DeckTablePanel
extends JPanel
implements CategoryObserver {
    private NextDeckAction m_nextDeckAction = new NextDeckAction();
    private PreviousDeckAction m_previousDeckAction = new PreviousDeckAction();
    private int m_currentDeckLevel = 0;
    private Category m_category;
    private CardTable m_cardTable = new CardTable(Main.USER_PREFS.node("main.table"), new int[]{0, 2, 3, 6, 7});

    public DeckTablePanel() {
        this.initComponents();
    }

    public void showDeck(int n) {
        this.m_cardTable.getView().setCards(n > -1 ? this.m_category.getCards(n) : this.m_category.getCards(), this.m_category);
        this.m_currentDeckLevel = n;
        this.updateButtons();
    }

    public void editCards() {
        Card card = this.m_cardTable.getSelectedCard();
        List list = this.m_cardTable.getView().getCards();
        Category category = this.m_cardTable.getView().getCategory();
        EditCardFrame.getInstance().showCard(card, list, category);
    }

    public void setCategory(Category category) {
        if (this.m_category != null) {
            this.m_category.removeObserver(this);
        }
        this.m_category = category;
        this.m_category.addObserver(this);
        this.showDeck(-1);
    }

    public CardTable getCardTable() {
        return this.m_cardTable;
    }

    public void onCategoryEvent(int n, Category category) {
    }

    public void onCardEvent(int n, Card card, int n2) {
        this.showDeck(this.m_currentDeckLevel);
    }

    private void updateButtons() {
        this.m_previousDeckAction.setEnabled(this.m_currentDeckLevel >= 0);
        this.m_nextDeckAction.setEnabled(this.m_currentDeckLevel < this.m_category.getNumberOfDecks() - 1);
    }

    private void initComponents() {
        JButton jButton = new JButton(this.m_previousDeckAction);
        JButton jButton2 = new JButton(this.m_nextDeckAction);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EtchedBorder());
        jPanel.add((Component)jToolBar, "North");
        JScrollPane jScrollPane = new JScrollPane(this.m_cardTable);
        jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.m_cardTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DeckTablePanel.this.tableMouseClicked(mouseEvent);
            }
        });
        jPanel.add((Component)jScrollPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        InputMap inputMap = this.m_cardTable.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "");
    }

    private void tableMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.editCards();
        }
    }

    private class PreviousDeckAction
    extends AbstractAction {
        public PreviousDeckAction() {
            this.putValue("Name", "Previous deck");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_prev.gif")));
            this.putValue("ShortDescription", "Display previous deck.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            for (n = DeckTablePanel.this.m_currentDeckLevel - 1; n >= 0 && DeckTablePanel.this.m_category.getCards(n).isEmpty(); --n) {
            }
            DeckTablePanel.this.showDeck(n);
        }
    }

    private class NextDeckAction
    extends AbstractAction {
        public NextDeckAction() {
            this.putValue("Name", "Next deck");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/resource/icons/card_next.gif")));
            this.putValue("ShortDescription", "Display next deck.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = DeckTablePanel.this.m_currentDeckLevel + 1;
            while (DeckTablePanel.this.m_category.getCards(n).isEmpty()) {
                ++n;
            }
            DeckTablePanel.this.showDeck(n);
        }
    }
}

