/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.gui.swing.MainFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendRenderingOrder;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.TextAnchor;

public class DeckChartPanel
extends JPanel
implements CategoryObserver {
    private static final int MINIMAL_DECK_BARS = 4;
    private static final String DECK0_NAME = "Start Deck";
    private static final String SUMMARY_BAR_NAME = "Summary";
    private static final Color UNLEARNED_CARDS_COLOR = Color.GRAY;
    private static final Color EXPIRED_CARDS_COLOR = Color.RED;
    private static final Color LEARNED_CARDS_COLOR = Color.GREEN;
    private Category m_category;
    private MainFrame m_frame;
    private DefaultCategoryDataset m_dataset;
    private ChartPanel m_chartPanel;

    public DeckChartPanel() {
        this.initComponents();
        JFreeChart jFreeChart = this.createChart();
        this.m_chartPanel = new ChartPanel(jFreeChart);
        this.m_chartPanel.addChartMouseListener(new MouseClicked());
        this.m_chartPanel.setMinimumDrawHeight(100);
        this.m_chartPanel.setMinimumDrawWidth(400);
        this.add(this.m_chartPanel);
    }

    public void setFrame(MainFrame mainFrame) {
        this.m_frame = mainFrame;
    }

    public void setCategory(Category category) {
        if (this.m_category != null) {
            this.m_category.removeObserver(this);
        }
        this.m_category = category;
        category.addObserver(this);
        this.createDataset();
    }

    private void createDataset() {
        this.m_dataset = this.createDefaultDataSet();
        this.updateBars();
        ((CategoryPlot)this.m_chartPanel.getChart().getPlot()).setDataset(this.m_dataset);
    }

    private JFreeChart createChart() {
        this.m_dataset = this.createDefaultDataSet();
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D("", "Decks", "Cards", this.m_dataset, PlotOrientation.VERTICAL, true, true, false);
        StandardLegend standardLegend = (StandardLegend)jFreeChart.getLegend();
        standardLegend.setRenderingOrder(LegendRenderingOrder.REVERSE);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setLabelGenerator(new StandardCategoryLabelGenerator());
        categoryItemRenderer.setItemLabelsVisible(true);
        categoryItemRenderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        categoryItemRenderer.setSeriesPaint(0, LEARNED_CARDS_COLOR);
        categoryItemRenderer.setSeriesPaint(1, EXPIRED_CARDS_COLOR);
        categoryItemRenderer.setSeriesPaint(2, UNLEARNED_CARDS_COLOR);
        return jFreeChart;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder());
    }

    private DefaultCategoryDataset createDefaultDataSet() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(0.0, (Comparable)((Object)"Learned Cards"), (Comparable)((Object)SUMMARY_BAR_NAME));
        for (int i = 0; i < 4; ++i) {
            defaultCategoryDataset.addValue(0.0, (Comparable)((Object)"Learned Cards"), (Comparable)((Object)(i > 0 ? "Deck " + i : DECK0_NAME)));
        }
        return defaultCategoryDataset;
    }

    private void updateBars() {
        this.updateSummaryBar();
        for (int i = 0; i < Math.max(this.m_category.getNumberOfDecks(), 4); ++i) {
            this.updateBar(i);
        }
    }

    private void updateSummaryBar() {
        this.m_dataset.setValue(this.m_category.getLearnedCards().size(), (Comparable)((Object)"Learned Cards"), (Comparable)((Object)SUMMARY_BAR_NAME));
        this.m_dataset.setValue(this.m_category.getExpiredCards().size(), (Comparable)((Object)"Expired Cards"), (Comparable)((Object)SUMMARY_BAR_NAME));
        this.m_dataset.setValue(this.m_category.getUnlearnedCards().size(), (Comparable)((Object)"Unlearned Cards"), (Comparable)((Object)SUMMARY_BAR_NAME));
    }

    private void updateBar(int n) {
        if (n == 0) {
            this.m_dataset.setValue(this.m_category.getCards(n).size(), (Comparable)((Object)"Unlearned Cards"), (Comparable)((Object)DECK0_NAME));
        } else if (n >= this.m_category.getNumberOfDecks()) {
            this.m_dataset.setValue(0.0, (Comparable)((Object)"Unlearned Cards"), (Comparable)((Object)("Deck " + n)));
            this.m_dataset.setValue(0.0, (Comparable)((Object)"Learned Cards"), (Comparable)((Object)("Deck " + n)));
            this.m_dataset.setValue(0.0, (Comparable)((Object)"Expired Cards"), (Comparable)((Object)("Deck " + n)));
        } else {
            this.m_dataset.setValue(this.m_category.getLearnedCards(n).size(), (Comparable)((Object)"Learned Cards"), (Comparable)((Object)("Deck " + n)));
            this.m_dataset.setValue(this.m_category.getExpiredCards(n).size(), (Comparable)((Object)"Expired Cards"), (Comparable)((Object)("Deck " + n)));
        }
    }

    public void onCategoryEvent(int n, Category category) {
    }

    public void onCardEvent(int n, Card card, int n2) {
        this.updateBars();
        while (this.m_dataset.getColumnCount() > Math.max(this.m_category.getNumberOfDecks() + 1, 5)) {
            this.m_dataset.removeColumn(this.m_dataset.getColumnCount() - 1);
        }
    }

    private class MouseClicked
    implements ChartMouseListener {
        private MouseClicked() {
        }

        public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
            ChartEntity chartEntity = chartMouseEvent.getEntity();
            if (chartEntity instanceof CategoryItemEntity) {
                int n = ((CategoryItemEntity)chartEntity).getCategoryIndex();
                DeckChartPanel.this.m_frame.getDeckPanel().showDeck(n - 1);
            }
        }

        public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
        }
    }
}

