/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import jmemorize.gui.swing.MainFrame;

public class CategoryTree
extends JTree
implements CategoryObserver {
    private final ImageIcon FOLDER_ICON = new ImageIcon(this.getClass().getResource("/resource/icons/folder.gif"));
    private DefaultMutableTreeNode m_editedNode;
    private Category m_editedCategory;
    private Category m_rootCategory;

    public CategoryTree() {
        CellRenderer cellRenderer = new CellRenderer();
        this.setCellRenderer(cellRenderer);
        this.setCellEditor(new CellEditor(this, cellRenderer));
        this.setTransferHandler(MainFrame.TRANSFER_HANDLER);
        this.setDragEnabled(true);
        this.setEditable(true);
    }

    public void setRootCategory(Category category) {
        if (this.m_rootCategory != null) {
            this.m_rootCategory.removeObserver(this);
        }
        this.m_rootCategory = category;
        this.m_rootCategory.addObserver(this);
        MutableTreeNode mutableTreeNode = this.createCategory(category);
        this.setModel(new CategoryTreeModel(mutableTreeNode));
        this.repaint();
    }

    public void setSelectedCategory(Category category) {
        if (category == null || this.m_rootCategory == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode2.getUserObject();
            if (object != category) continue;
            this.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
    }

    public Category getSelectedCategory() {
        return (Category)this.getSelectedValue();
    }

    public void onCategoryEvent(int n, Category category) {
        switch (n) {
            case 0: {
                DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(category.getFather());
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(category);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
                defaultTreeModel.reload(defaultMutableTreeNode);
                break;
            }
            case 1: {
                DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(category.getFather());
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.getNode(category);
                defaultMutableTreeNode.remove(defaultMutableTreeNode3);
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
                defaultTreeModel.reload(defaultMutableTreeNode);
                break;
            }
            case 3: {
                DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(category);
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
                defaultTreeModel.reload(defaultMutableTreeNode);
            }
        }
    }

    public void onCardEvent(int n, Card card, int n2) {
    }

    private DefaultMutableTreeNode getNode(Object object) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode2.getUserObject() != object) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    private Object getSelectedValue() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return defaultMutableTreeNode.getUserObject();
        }
        return null;
    }

    private List getSelectedValues() {
        TreePath[] treePathArray = this.getSelectionPaths();
        ArrayList<Object> arrayList = new ArrayList<Object>(treePathArray.length);
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            arrayList.add(defaultMutableTreeNode.getUserObject());
        }
        return arrayList;
    }

    private MutableTreeNode createCategory(Category category) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(category);
        Iterator iterator = category.getChildCategories().iterator();
        while (iterator.hasNext()) {
            Category category2 = (Category)iterator.next();
            defaultMutableTreeNode.add(this.createCategory(category2));
        }
        return defaultMutableTreeNode;
    }

    private class CellEditor
    extends DefaultTreeCellEditor {
        public CellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        public DefaultMutableTreeNode getEditedNode() {
            return CategoryTree.this.m_editedNode;
        }

        public Category getNodeCategory() {
            return CategoryTree.this.m_editedCategory;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject != null) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                TreePath treePath = CategoryTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                CategoryTree.this.m_editedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                CategoryTree.this.m_editedCategory = (Category)CategoryTree.this.m_editedNode.getUserObject();
            }
            return super.isCellEditable(eventObject) && CategoryTree.this.m_editedCategory != CategoryTree.this.m_rootCategory;
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Category category = (Category)defaultMutableTreeNode.getUserObject();
            return super.getTreeCellEditorComponent(jTree, category.getName(), bl, bl2, bl3, n);
        }
    }

    private class CategoryTreeModel
    extends DefaultTreeModel {
        public CategoryTreeModel(TreeNode treeNode) {
            super(treeNode);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Category category = (Category)defaultMutableTreeNode.getUserObject();
            category.setName((String)object);
            this.nodeChanged(defaultMutableTreeNode);
        }
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        public CellRenderer() {
            this.setLeafIcon(CategoryTree.this.FOLDER_ICON);
            this.setOpenIcon(CategoryTree.this.FOLDER_ICON);
            this.setClosedIcon(CategoryTree.this.FOLDER_ICON);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof Category) {
                Category category = (Category)object2;
                jLabel.setText(category.getName());
            }
            if (bl4) {
                // empty if block
            }
            return jLabel;
        }
    }
}

