/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.Component;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;

public class CategoryComboBox
extends JComboBox
implements CategoryObserver {
    private final ImageIcon FOLDER_ICON = new ImageIcon(this.getClass().getResource("/resource/icons/folder.gif"));
    private Category m_rootCategory;

    public CategoryComboBox() {
        this.setRenderer(new CatergoryRenderer());
        this.setMaximumRowCount(12);
    }

    public void setRootCategory(Category category) {
        if (this.m_rootCategory != null) {
            this.m_rootCategory.removeObserver(this);
        }
        this.m_rootCategory = category;
        this.m_rootCategory.addObserver(this);
        this.updateModel();
    }

    public void setSelectedCategory(Category category) {
        this.setSelectedItem(category);
    }

    public Category getSelectedCategory() {
        return (Category)this.getModel().getSelectedItem();
    }

    public void onCategoryEvent(int n, Category category) {
        this.updateModel();
    }

    public void onCardEvent(int n, Card card, int n2) {
    }

    private void updateModel() {
        Object object = this.getModel().getSelectedItem();
        List list = this.m_rootCategory.getSubtreeList();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        if (list.contains(object)) {
            defaultComboBoxModel.setSelectedItem(object);
        }
        this.setModel(defaultComboBoxModel);
    }

    private class CatergoryRenderer
    extends BasicComboBoxRenderer {
        private CatergoryRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Category category = (Category)object;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, category.getName(), n, bl, bl2);
            jLabel.setIcon(CategoryComboBox.this.FOLDER_ICON);
            int n2 = n >= 0 ? 20 * category.getDepth() : 0;
            jLabel.setBorder(new EmptyBorder(2, n2, 2, 2));
            return jLabel;
        }
    }
}

