/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.ExitObserver;
import jmemorize.core.Main;
import jmemorize.gui.swing.MainFrame;
import jmemorize.gui.swing.StatusBar;
import jmemorize.util.Arrow;
import jmemorize.util.PreferencesTool;
import jmemorize.util.ReverseOrder;
import jmemorize.util.TimeSpan;

public class CardTable
extends JTable
implements ExitObserver {
    public static final int COLUMN_FRONTSIDE = 0;
    public static final int COLUMN_BACKSIDE = 1;
    public static final int COLUMN_DECK = 2;
    public static final int COLUMN_CATEGORY = 3;
    public static final int COLUMN_PATH = 4;
    public static final int COLUMN_CREATED = 5;
    public static final int COLUMN_TESTED = 6;
    public static final int COLUMN_EXPIRES = 7;
    private static final String[] COLUMN_NAMES = new String[]{"Frontside", "Flipside", "Deck", "Category", "Path", "Created", "Last Test", "Expires"};
    private JCheckBoxMenuItem[] m_checkBoxItems = new JCheckBoxMenuItem[COLUMN_NAMES.length];
    private JPopupMenu m_menu = new JPopupMenu("Columns");
    private StatusBar m_statusBar;
    private Icon m_ascendingArrow = new Arrow(false, 15);
    private Icon m_descendingArrow = new Arrow(true, 15);
    private ViewModel m_tableModel = new ViewModel();
    private int[] m_columns;
    private int[] m_defaultColumns;
    private int[] m_columnWidths = new int[COLUMN_NAMES.length];
    private Preferences m_prefs;

    public CardTable(Preferences preferences, int[] nArray) {
        Main.getInstance().addExitObserver(this);
        this.m_prefs = preferences;
        this.m_defaultColumns = nArray;
        for (int i = 0; i < COLUMN_NAMES.length; ++i) {
            this.m_checkBoxItems[i] = new JCheckBoxMenuItem(COLUMN_NAMES[i]);
            this.m_checkBoxItems[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CardTable.this.columnSelectionChanged();
                }
            });
            this.m_menu.add(this.m_checkBoxItems[i]);
        }
        this.setModel(this.m_tableModel);
        this.m_tableModel.setSorting(7, 0);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CardTable.this.headerClicked(mouseEvent);
            }
        });
        this.loadFromPreferences();
        this.setTransferHandler(MainFrame.TRANSFER_HANDLER);
        this.setDragEnabled(true);
        this.setShowGrid(false);
    }

    public void setColumns(int[] nArray) {
        this.m_columns = nArray;
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        for (int i = 0; i < nArray.length; ++i) {
            TableColumn tableColumn = new TableColumn(nArray[i]);
            tableColumn.setHeaderValue(COLUMN_NAMES[nArray[i]]);
            tableColumn.setHeaderRenderer(new SortableHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
            if (this.m_columnWidths[nArray[i]] > 0) {
                tableColumn.setPreferredWidth(this.m_columnWidths[nArray[i]]);
            }
            switch (nArray[i]) {
                case 5: {
                    tableColumn.setCellRenderer(new DateRenderer("-"));
                    break;
                }
                case 7: {
                    tableColumn.setCellRenderer(new DateExpiredRenderer());
                    break;
                }
                case 6: {
                    tableColumn.setCellRenderer(new DateRenderer("not learned"));
                    break;
                }
                default: {
                    tableColumn.setCellRenderer(new DefaultTableCellRenderer());
                }
            }
            defaultTableColumnModel.addColumn(tableColumn);
        }
        this.setColumnModel(defaultTableColumnModel);
    }

    public void setStatusBar(StatusBar statusBar) {
        this.m_statusBar = statusBar;
        if (this.m_statusBar != null) {
            this.updateCardCountStatusBar();
            this.updateSelectedCardCountStatusBar();
        }
    }

    public ViewModel getView() {
        return this.m_tableModel;
    }

    public Card getSelectedCard() {
        int n = this.getSelectedRow();
        return (Card)this.m_tableModel.getCards().get(n);
    }

    public List getSelectedCards() {
        if (this.m_tableModel == null) {
            return new ArrayList();
        }
        List list = this.m_tableModel.getCards();
        ArrayList arrayList = new ArrayList(list.size());
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        return arrayList;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateSelectedCardCountStatusBar();
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.putClientProperty("selectedCards", this.getSelectedCards());
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        Card card = (Card)this.m_tableModel.getCards().get(n);
        int n3 = this.m_columns[n2];
        switch (n3) {
            case 3: {
                return card.getCategory().getPath();
            }
            case 5: {
                Date date = card.getDateCreated();
                return date != null ? TimeSpan.format(new Date(), date) : null;
            }
            case 6: {
                Date date = card.getDateTested();
                return date != null ? TimeSpan.format(new Date(), date) : "This card has never been tested.";
            }
            case 7: {
                Date date = card.getDateExpired();
                return date != null ? TimeSpan.format(new Date(), date) : "This card has never been tested.";
            }
        }
        return null;
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        super.columnMarginChanged(changeEvent);
        for (int i = 0; i < this.m_columns.length; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            this.m_columnWidths[tableColumn.getModelIndex()] = tableColumn.getWidth();
        }
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnMoved(tableColumnModelEvent);
        int[] nArray = new int[this.m_columns.length];
        for (int i = 0; i < nArray.length; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            nArray[i] = tableColumn.getModelIndex();
        }
        this.m_columns = nArray;
    }

    public void onExit() {
        this.storeToPreferences();
    }

    private static Object getValue(Card card, int n) {
        switch (n) {
            case 0: {
                return card.getFrontSide().replace('\n', ' ');
            }
            case 1: {
                return card.getBackSide().replace('\n', ' ');
            }
            case 2: {
                return new Integer(card.getLevel());
            }
            case 3: {
                return card.getCategory().getName();
            }
            case 4: {
                return card.getCategory().getPath();
            }
            case 5: {
                return card.getDateCreated();
            }
            case 6: {
                return card.getDateTested();
            }
            case 7: {
                return card.getDateExpired();
            }
        }
        return "-";
    }

    private void columnSelectionChanged() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.m_columns.length; ++n) {
            arrayList.add(new Integer(this.m_columns[n]));
        }
        for (n = 0; n < COLUMN_NAMES.length; ++n) {
            if (this.m_checkBoxItems[n].isSelected() && !arrayList.contains(new Integer(n))) {
                arrayList.add(Math.min(n, arrayList.size()), new Integer(n));
                continue;
            }
            if (this.m_checkBoxItems[n].isSelected() || !arrayList.contains(new Integer(n))) continue;
            arrayList.remove(new Integer(n));
        }
        int[] nArray = new int[arrayList.size()];
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Integer n3 = (Integer)iterator.next();
            nArray[n2++] = n3;
        }
        this.setColumns(nArray);
    }

    private void headerClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            int n;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n2 != -1) {
                if (n2 == this.m_tableModel.getSortingColumn()) {
                    int n3 = this.m_tableModel.getSortingDir();
                    this.m_tableModel.setSorting(n2, n3 == 0 ? 1 : 0);
                } else {
                    this.m_tableModel.setSorting(n2, 0);
                }
                jTableHeader.repaint();
            }
        } else if (mouseEvent.getButton() == 3) {
            int n;
            for (n = 0; n < this.m_checkBoxItems.length; ++n) {
                this.m_checkBoxItems[n].setSelected(false);
            }
            for (n = 0; n < this.m_columns.length; ++n) {
                this.m_checkBoxItems[this.m_columns[n]].setSelected(true);
            }
            this.m_menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void loadFromPreferences() {
        int[] nArray;
        this.m_columnWidths = PreferencesTool.getIntArray(this.m_prefs, "widths");
        if (this.m_columnWidths == null || this.m_columnWidths.length != COLUMN_NAMES.length) {
            this.m_columnWidths = new int[COLUMN_NAMES.length];
        }
        this.setColumns((nArray = PreferencesTool.getIntArray(this.m_prefs, "columns")) != null ? nArray : this.m_defaultColumns);
    }

    private void updateSelectedCardCountStatusBar() {
        if (this.m_statusBar != null) {
            if (this.getSelectedRowCount() >= 2) {
                this.m_statusBar.setLeftText("Selected cards: " + this.getSelectedRowCount());
            } else {
                this.m_statusBar.setLeftText("");
            }
        }
    }

    private void updateCardCountStatusBar() {
        if (this.m_statusBar != null) {
            this.m_statusBar.setCards(this.m_tableModel.getCards());
        }
    }

    private void storeToPreferences() {
        PreferencesTool.putIntArray(this.m_prefs, "widths", this.m_columnWidths);
        PreferencesTool.putIntArray(this.m_prefs, "columns", this.m_columns);
    }

    public class ViewModel
    extends AbstractTableModel {
        public static final int ASCENDING = 0;
        public static final int DESCENDING = 1;
        private List m_cards = new ArrayList();
        private Category m_category;
        private int m_orderModelIndex;
        private int m_orderDir;

        public Category getCategory() {
            return this.m_category;
        }

        public void setCards(List list, Category category) {
            this.m_cards = list;
            this.m_category = category;
            this.resort();
            CardTable.this.updateCardCountStatusBar();
        }

        public void setSorting(int n, int n2) {
            this.m_orderModelIndex = n;
            this.m_orderDir = n2;
            this.resort();
        }

        public List getCards() {
            return this.m_cards;
        }

        public int getRowCount() {
            return this.m_cards != null ? this.m_cards.size() : 0;
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return COLUMN_NAMES[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Card card = (Card)this.m_cards.get(n);
            return CardTable.getValue(card, n2);
        }

        public int getSortingColumn() {
            return this.m_orderModelIndex;
        }

        public int getSortingDir() {
            return this.m_orderDir;
        }

        private void resort() {
            if (this.m_cards != null) {
                LazyRowComparator lazyRowComparator = new LazyRowComparator(this.m_orderModelIndex);
                Collections.sort(this.m_cards, this.m_orderDir == 0 ? lazyRowComparator : new ReverseOrder(lazyRowComparator));
                this.fireTableDataChanged();
            }
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                int n3 = jTable.convertColumnIndexToModel(n2);
                if (n3 == CardTable.this.m_tableModel.getSortingColumn()) {
                    jLabel.setIcon(CardTable.this.m_tableModel.getSortingDir() == 0 ? CardTable.this.m_ascendingArrow : CardTable.this.m_descendingArrow);
                } else {
                    jLabel.setIcon(null);
                }
            }
            return component;
        }
    }

    private class LazyRowComparator
    implements Comparator {
        private int m_modelIndex;

        public LazyRowComparator(int n) {
            this.m_modelIndex = n;
        }

        public int compare(Object object, Object object2) {
            Comparable comparable = (Comparable)CardTable.getValue((Card)object, this.m_modelIndex);
            Comparable comparable2 = (Comparable)CardTable.getValue((Card)object2, this.m_modelIndex);
            if (comparable == null) {
                return comparable2 == null ? 0 : -1;
            }
            return comparable2 == null ? 1 : comparable.compareTo(comparable2);
        }
    }

    private class DateExpiredRenderer
    extends DefaultTableCellRenderer {
        private final ImageIcon OK_ICON = new ImageIcon(this.getClass().getResource("/resource/icons/state_ok.gif"));
        private final ImageIcon TODAY_ICON = new ImageIcon(this.getClass().getResource("/resource/icons/state_soon.gif"));
        private final ImageIcon NO_ICON = new ImageIcon(this.getClass().getResource("/resource/icons/state_no.gif"));
        private final ImageIcon EXPIRED_ICON = new ImageIcon(this.getClass().getResource("/resource/icons/state_forgotten.gif"));

        private DateExpiredRenderer() {
        }

        public void setValue(Object object) {
            if (object == null) {
                this.setText("not learned");
                this.setIcon(this.NO_ICON);
            } else {
                Date date = (Date)object;
                if (date.after(Main.getTomorrow())) {
                    this.setIcon(this.OK_ICON);
                } else if (date.after(Main.getNow())) {
                    this.setIcon(this.TODAY_ICON);
                } else {
                    this.setIcon(this.EXPIRED_ICON);
                }
                this.setText(MainFrame.SHORT_DATE_FORMATER.format(object));
            }
        }
    }

    private class DateRenderer
    extends DefaultTableCellRenderer {
        private String m_nullString;

        public DateRenderer(String string) {
            this.m_nullString = string;
        }

        protected void setValue(Object object) {
            this.setText(object == null ? this.m_nullString : MainFrame.SHORT_DATE_FORMATER.format(object));
        }
    }
}

