/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;

public class CardSidesPanel
extends JPanel {
    private JTextPane m_frontTextPane = new JTextPane();
    private JTextPane m_backTextPane = new JTextPane();
    private JTextPane m_notesTextPane = new JTextPane();
    private JLabel m_frontLabel = new JLabel("Frontside");
    private JLabel m_backLabel = new JLabel("Flipside");
    private JLabel m_notesLabel = new JLabel("Notes");

    public CardSidesPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildSidesPanel(-1), "Center");
        this.m_frontTextPane.setFocusTraversalKeysEnabled(false);
        this.m_frontTextPane.getInputMap(0).put(KeyStroke.getKeyStroke(9, 128), "FocusNext");
        this.m_frontTextPane.getActionMap().put("FocusNext", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CardSidesPanel.this.m_backTextPane.requestFocus();
            }
        });
    }

    public void setSidesBigSide(boolean bl, String string, String string2) {
        Font font;
        int n;
        if (!bl) {
            n = string.length() <= 12 ? 48 : 24;
            font = this.m_frontTextPane.getFont().deriveFont(1, n);
            this.m_frontTextPane.setFont(font);
        } else {
            Font font2 = this.m_frontTextPane.getFont().deriveFont(0, 12.0f);
            this.m_frontTextPane.setFont(font2);
        }
        this.m_frontTextPane.setText(string);
        if (bl) {
            n = string2.length() <= 12 ? 48 : 24;
            font = this.m_backTextPane.getFont().deriveFont(1, n);
            this.m_backTextPane.setFont(font);
        } else {
            Font font3 = this.m_backTextPane.getFont().deriveFont(0, 12.0f);
            this.m_backTextPane.setFont(font3);
        }
        this.m_backTextPane.setText(string2);
        this.m_frontTextPane.requestFocus();
    }

    public void setSides(String string, String string2) {
        this.m_frontTextPane.setText(string);
        this.m_backTextPane.setText(string2);
        this.m_frontTextPane.requestFocus();
    }

    public void setEditable(boolean bl) {
        this.m_frontTextPane.setEditable(bl);
        this.m_backTextPane.setEditable(bl);
        this.m_notesTextPane.setEditable(bl);
    }

    public void reset() {
        this.setSides("", "");
    }

    public String getFrontside() {
        return this.m_frontTextPane.getText();
    }

    public String getBackside() {
        return this.m_backTextPane.getText();
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.m_frontTextPane.getDocument().addDocumentListener(documentListener);
        this.m_backTextPane.getDocument().addDocumentListener(documentListener);
    }

    private JPanel buildSidesPanel(int n) {
        JScrollPane jScrollPane = new JScrollPane(this.m_frontTextPane);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_backTextPane);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        JScrollPane jScrollPane3 = new JScrollPane(this.m_notesTextPane);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        FormLayout formLayout = new FormLayout("28dlu, 3dlu, d:grow", "fill:20dlu:grow, 3dlu, fill:20dlu:grow");
        CellConstraints cellConstraints = new CellConstraints();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.add((Component)this.m_frontLabel, cellConstraints.xy(1, 1, "left, top"));
        defaultFormBuilder.add((Component)jScrollPane, cellConstraints.xy(3, 1));
        defaultFormBuilder.add((Component)this.m_backLabel, cellConstraints.xy(1, 3, "left, top"));
        defaultFormBuilder.add((Component)jScrollPane2, cellConstraints.xy(3, 3));
        return defaultFormBuilder.getPanel();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.add(new CardSidesPanel());
        jFrame.setVisible(true);
    }
}

