/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class CardCounterPanel
extends JPanel {
    private int m_cardsPassed;
    private int m_cardsTarget;
    private JProgressBar m_bar = new JProgressBar();
    private JTextField m_textField = new JTextField();

    public void start(int n) {
        this.m_cardsTarget = n;
        this.m_cardsPassed = 0;
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.m_cardsTarget > -1) {
            this.m_bar.setStringPainted(true);
            this.m_bar.setString(this.getCardString());
            this.m_bar.setValue(0);
            this.add((Component)this.m_bar, "Center");
        } else {
            this.m_textField.setText(this.getCardString());
            this.m_textField.setHorizontalAlignment(0);
            this.m_textField.setEditable(false);
            this.add((Component)this.m_textField, "Center");
        }
    }

    public void start() {
        this.start(-1);
    }

    public void incStats() {
        ++this.m_cardsPassed;
        if (this.m_cardsTarget > -1) {
            this.m_bar.setValue(100 * this.m_cardsPassed / this.m_cardsTarget);
            this.m_bar.setString(this.getCardString());
        } else {
            this.m_textField.setText(this.getCardString());
        }
    }

    protected String getCardString() {
        if (this.m_cardsTarget > -1) {
            return this.m_cardsPassed + " / " + this.m_cardsTarget;
        }
        return Integer.toString(this.m_cardsPassed);
    }
}

