/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.gui.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.gui.swing.CardTable;
import jmemorize.gui.swing.CategoryTree;

public class CardCategoryTransferHandler
extends TransferHandler {
    public static final DataFlavor CARDS_FLAVOR = new DataFlavor(Card.class, "Card");
    public static final DataFlavor CATEGORY_FLAVOR = new DataFlavor(Category.class, "Category");

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (jComponent instanceof CategoryTree) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i] != CARDS_FLAVOR && dataFlavorArray[i] != CATEGORY_FLAVOR) continue;
                return true;
            }
        }
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        if (jComponent instanceof CardTable) {
            CardTable cardTable = (CardTable)jComponent;
            return new CardsTransferable(cardTable.getSelectedCards());
        }
        if (jComponent instanceof CategoryTree) {
            CategoryTree categoryTree = (CategoryTree)jComponent;
            Category category = categoryTree.getSelectedCategory();
            return category.getFather() != null ? new CategoryTransferable(category) : null;
        }
        return null;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        Category category;
        Object object;
        if (jComponent instanceof CategoryTree) {
            object = (CategoryTree)jComponent;
            category = ((CategoryTree)object).getSelectedCategory();
        } else if (jComponent instanceof CardTable) {
            object = (CardTable)jComponent;
            category = ((CardTable)object).getView().getCategory();
        } else {
            return false;
        }
        try {
            if (transferable.isDataFlavorSupported(CARDS_FLAVOR)) {
                object = (List)transferable.getTransferData(CARDS_FLAVOR);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Card card = (Card)iterator.next();
                    category.addCard((Card)card.clone(), card.getLevel());
                }
                return true;
            }
            if (transferable.isDataFlavorSupported(CATEGORY_FLAVOR)) {
                object = (Category)transferable.getTransferData(CATEGORY_FLAVOR);
                if (!((Category)object).contains(category)) {
                    this.copyCategories(category, (Category)object);
                    return true;
                }
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private void copyCategories(Category category, Category category2) throws CloneNotSupportedException {
        Object object;
        Category category3 = new Category(category2.getName());
        category.addCategoryChild(category3);
        Iterator iterator = category2.getChildCategories().iterator();
        while (iterator.hasNext()) {
            object = (Category)iterator.next();
            this.copyCategories(category3, (Category)object);
        }
        for (int i = 0; i < category2.getNumberOfDecks(); ++i) {
            object = category2.getLocalCards(i).iterator();
            while (object.hasNext()) {
                Card card = (Card)object.next();
                category3.addCard((Card)card.clone(), i);
            }
        }
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n != 2) {
            return;
        }
        try {
            if (transferable.isDataFlavorSupported(CARDS_FLAVOR)) {
                CardTable cardTable = (CardTable)jComponent;
                Category category = cardTable.getView().getCategory();
                List list = (List)transferable.getTransferData(CARDS_FLAVOR);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Card card = (Card)iterator.next();
                    category.removeCard(card);
                }
            } else if (transferable.isDataFlavorSupported(CATEGORY_FLAVOR)) {
                Category category = (Category)transferable.getTransferData(CATEGORY_FLAVOR);
                category.remove();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class CategoryTransferable
    implements Transferable {
        private Category m_category;

        public CategoryTransferable(Category category) {
            this.m_category = category;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.m_category;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{CATEGORY_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return CATEGORY_FLAVOR.equals(dataFlavor);
        }
    }

    public class CardsTransferable
    implements Transferable {
        private List m_cards;

        public CardsTransferable(List list) {
            this.m_cards = list;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.m_cards;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{CARDS_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return CARDS_FLAVOR.equals(dataFlavor);
        }
    }
}

