/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.Timer;
import jmemorize.core.Card;
import jmemorize.core.ExitObserver;
import jmemorize.core.Lesson;
import jmemorize.gui.swing.MainFrame;
import jmemorize.strategy.Strategy;
import jmemorize.util.RecentItems;

public class Main
extends Observable {
    public static final Properties PROPERTIES = new Properties();
    public static final Preferences USER_PREFS = Preferences.userRoot().node("de/riad/jmemorize");
    private Lesson m_lesson;
    private Strategy m_strategy;
    private MainFrame m_frame;
    private Card m_nextCard;
    private Date m_lastDate = new Date();
    private RecentItems m_recentFiles = new RecentItems(5, USER_PREFS.node("recent.files"));
    private List m_exitObservers = new LinkedList();
    private static Main m_instance;

    public static Main getInstance() {
        if (m_instance == null) {
            m_instance = new Main();
        }
        return m_instance;
    }

    public static Date getNow() {
        return new Date();
    }

    public static Date getTomorrow() {
        return new Date(new Date().getTime() + 86400000L);
    }

    public void createNewLesson() {
        this.m_lesson = new Lesson();
        if (this.m_frame != null) {
            this.m_frame.setLesson(this.m_lesson);
        }
    }

    public void loadLesson(File file) throws IOException {
        try {
            this.m_lesson = Lesson.fromXML(file);
            this.m_recentFiles.push(file.getAbsolutePath());
        }
        catch (Exception exception) {
            this.m_recentFiles.remove(file.getAbsolutePath());
            throw new IOException(exception.getMessage());
        }
        if (this.m_frame != null) {
            this.m_frame.setLesson(this.m_lesson);
        }
    }

    public String getNewestVersion() {
        String string = PROPERTIES.getProperty("project.version");
        int n = Integer.parseInt(PROPERTIES.getProperty("buildId"));
        try {
            URL uRL = new URL("http://riad.de/jmemorize/vc/" + n);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String[] stringArray = bufferedReader.readLine().split(" ");
            int n2 = Integer.parseInt(stringArray[0]);
            String string2 = stringArray[1];
            bufferedReader.close();
            return n2 > n ? string2 : null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void saveLesson(File file) throws IOException {
        try {
            this.m_lesson.toXML(file);
            this.m_recentFiles.push(file.getAbsolutePath());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        this.m_lesson.setFile(file);
    }

    public Lesson getLesson() {
        return this.m_lesson;
    }

    public Strategy getStrategy() {
        return this.m_strategy;
    }

    public RecentItems getRecentFiles() {
        return this.m_recentFiles;
    }

    public void addExitObserver(ExitObserver exitObserver) {
        this.m_exitObservers.add(exitObserver);
    }

    public void exit() {
        Iterator iterator = this.m_exitObservers.iterator();
        while (iterator.hasNext()) {
            ExitObserver exitObserver = (ExitObserver)iterator.next();
            exitObserver.onExit();
        }
        System.exit(0);
    }

    private Main() {
        try {
            PROPERTIES.load(this.getClass().getResource("/resource/jMemorize.properties").openStream());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void run(File file) {
        this.createNewLesson();
        this.m_frame = new MainFrame();
        this.m_strategy = new Strategy(USER_PREFS.node("strategy"), this.m_frame);
        this.m_frame.setVisible(true);
        if (file != null) {
            this.m_frame.loadLesson(file);
        }
    }

    private void startExpirationTimer() {
        this.m_nextCard = this.getLesson().getNextExpirationCard(this.m_lastDate);
        this.m_lastDate = this.m_nextCard.getDateExpired();
        new CardTimer(this.m_nextCard);
    }

    public static void main(String[] stringArray) {
        File file = stringArray.length >= 1 ? new File(stringArray[0]) : null;
        Main.getInstance().run(file);
    }

    private class CardTimer
    implements ActionListener {
        private Card m_card;

        public CardTimer(Card card) {
            this.m_card = card;
            int n = (int)(card.getDateExpired().getTime() - System.currentTimeMillis());
            new Timer(n, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

