/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jmemorize.core.Card;
import jmemorize.core.Category;
import jmemorize.core.CategoryObserver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Lesson
implements CategoryObserver {
    private boolean m_modified = false;
    private File m_file;
    private static DateFormat m_dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.UK);
    private Category m_rootCategory = new Category("All");

    public Lesson() {
        this.m_rootCategory.addObserver(this);
    }

    public File getFile() {
        return this.m_file;
    }

    public void setFile(File file) {
        this.m_file = file;
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public Category getRootCategory() {
        return this.m_rootCategory;
    }

    public Card getNextExpirationCard(Date date) {
        List list = this.m_rootCategory.getCards();
        Card card = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Date date2;
            Card card2 = (Card)iterator.next();
            Date date3 = card2.getDateExpired();
            Date date4 = card != null ? card.getDateExpired() : null;
            Date date5 = date2 = card2.getDateExpired() != null && card2.getDateExpired().compareTo(date) > 0 ? card2.getDateExpired() : null;
            if (date4 == null && date2 != null) {
                card = card2;
                continue;
            }
            if (date4 == null || date2 == null || date4.compareTo(date2) <= 0) continue;
            card = card2;
        }
        return card;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toXML(File file) throws IOException, TransformerException, ParserConfigurationException {
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file));
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement("Lesson");
            document.appendChild(element);
            Lesson.writeCategory(document, element, this.getRootCategory());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(gZIPOutputStream));
            this.setModified(false);
        }
        finally {
            if (gZIPOutputStream != null) {
                gZIPOutputStream.close();
            }
        }
    }

    private static void writeCategory(Document document, Element element, Category category) {
        Object object;
        Element element2 = document.createElement("Category");
        element2.setAttribute("name", category.getName());
        element.appendChild(element2);
        for (int i = 0; i < category.getNumberOfDecks(); ++i) {
            object = document.createElement("Deck");
            element2.appendChild((Node)object);
            Iterator iterator = category.getLocalCards(i).iterator();
            while (iterator.hasNext()) {
                Card card = (Card)iterator.next();
                Element element3 = document.createElement("Card");
                element3.setAttribute("Frontside", card.getFrontSide());
                element3.setAttribute("Backside", card.getBackSide());
                element3.setAttribute("DateCreated", m_dateFormat.format(card.getDateCreated()));
                element3.setAttribute("DateTouched", m_dateFormat.format(card.getDateTouched()));
                if (card.getDateTested() != null) {
                    element3.setAttribute("DateTested", m_dateFormat.format(card.getDateTested()));
                }
                if (card.getDateExpired() != null) {
                    element3.setAttribute("DateExpired", m_dateFormat.format(card.getDateExpired()));
                }
                element3.setAttribute("TestsTotal", Integer.toString(card.getTestsTotal()));
                element3.setAttribute("TestsHit", Integer.toString(card.getTestsHit()));
                object.appendChild(element3);
            }
        }
        Iterator iterator = category.getChildCategories().iterator();
        while (iterator.hasNext()) {
            object = (Category)iterator.next();
            Lesson.writeCategory(document, element2, (Category)object);
        }
    }

    private static void fillCategory(Category category, Category category2, Element element, int n) {
        int n2 = 0;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            Node node = nodeList.item(i);
            if (node.getNodeName().equalsIgnoreCase("Deck")) {
                object2 = node.getChildNodes();
                for (int j = 0; j < object2.getLength(); ++j) {
                    object = object2.item(j);
                    if (!object.getNodeName().equalsIgnoreCase("Card")) continue;
                    NamedNodeMap namedNodeMap = object.getAttributes();
                    String string = namedNodeMap.getNamedItem("Frontside").getNodeValue();
                    String string2 = namedNodeMap.getNamedItem("Backside").getNodeValue();
                    Date date = Lesson.readDate(namedNodeMap, "DateCreated");
                    Date date2 = Lesson.readDate(namedNodeMap, "DateTested");
                    Date date3 = Lesson.readDate(namedNodeMap, "DateExpired");
                    Date date4 = Lesson.readDate(namedNodeMap, "DateTouched");
                    if (date == null) {
                        Date date5 = date = date2 != null ? date2 : new Date();
                    }
                    if (date4 == null) {
                        date4 = date2 != null ? date2 : date;
                    }
                    int n3 = Lesson.readInt(namedNodeMap, "TestsTotal");
                    int n4 = Lesson.readInt(namedNodeMap, "TestsHit");
                    Card card = new Card(date, string, string2);
                    card.setDateTested(date2);
                    card.setDateExpired(date3);
                    card.setDateTouched(date4);
                    card.incStats(n4, n3);
                    category.addCard(card, n2);
                }
                ++n2;
                continue;
            }
            if (!node.getNodeName().equalsIgnoreCase("Category")) continue;
            object2 = (Element)node;
            String string = object2.getAttribute("name");
            object = new Category(string);
            category.addCategoryChild((Category)object);
            Lesson.fillCategory((Category)object, category, (Element)object2, n + 1);
        }
    }

    private static int readInt(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node != null) {
            return Integer.parseInt(node.getNodeValue());
        }
        return 0;
    }

    private static Date readDate(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node != null) {
            try {
                return m_dateFormat.parse(node.getNodeValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Lesson fromXML(File file) throws SAXException, IOException, ParserConfigurationException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(gZIPInputStream);
            Element element = (Element)document.getElementsByTagName("Category").item(0);
            Category category = new Category(element.getAttribute("name"));
            Lesson.fillCategory(category, null, element, 0);
            Lesson lesson = new Lesson();
            lesson.setRootcategry(category);
            lesson.setFile(file);
            lesson.setModified(false);
            Lesson lesson2 = lesson;
            return lesson2;
        }
        finally {
            if (gZIPInputStream != null) {
                gZIPInputStream.close();
            }
        }
    }

    private void setModified(boolean bl) {
        if (bl != this.m_modified) {
            this.m_modified = bl;
        }
    }

    private void setRootcategry(Category category) {
        this.m_rootCategory.removeObserver(this);
        this.m_rootCategory = category;
        this.m_rootCategory.addObserver(this);
    }

    public void onCategoryEvent(int n, Category category) {
        this.setModified(true);
    }

    public void onCardEvent(int n, Card card, int n2) {
        if (n != 4) {
            this.setModified(true);
        }
    }
}

