/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jmemorize.core.Card;
import jmemorize.core.CategoryObserver;
import jmemorize.core.Events;

public class Category
implements Events {
    private List m_observers = new ArrayList();
    private String m_name;
    private int m_depth = 0;
    private List m_decks = new ArrayList();
    private Category m_father;
    private List m_childCategories = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Category(String string) {
        this.m_name = string;
    }

    public void addCard(Card card) {
        this.addCard(card, 0);
    }

    public void addCard(Card card, int n) {
        this.addCardInternal(card, n);
        this.fireCardEvent(0, card, n);
    }

    public void removeCard(Card card) {
        int n = card.getLevel();
        this.removeCardInternal(card);
        this.fireCardEvent(1, card, n);
    }

    public void raiseCardLevel(Card card, Date date, Date date2) {
        card.incStats(1, 1);
        this.changeCardLevel(card, card.getLevel() + 1, date, date2);
    }

    public void resetCardLevel(Card card, Date date) {
        card.incStats(0, 1);
        this.changeCardLevel(card, 0, date, null);
    }

    public void reappendCard(Card card) {
        card.setDateTouched(new Date());
        card.getCategory().fireCardEvent(2, card, card.getLevel());
    }

    public void resetCard(Card card) {
        card.resetStats();
        this.changeCardLevel(card, 0, null, null);
    }

    public List getCards() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.m_decks.size(); ++i) {
            arrayList.addAll(this.getCards(i));
        }
        return arrayList;
    }

    public List getCards(int n) {
        if (n >= this.getNumberOfDecks()) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList((List)this.m_decks.get(n));
        Iterator iterator = this.getChildCategories().iterator();
        while (iterator.hasNext()) {
            Category category = (Category)iterator.next();
            if (category.getNumberOfDecks() <= n) continue;
            arrayList.addAll(category.getCards(n));
        }
        return arrayList;
    }

    public List getExpiredCards() {
        List list = this.getCards();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Card card = (Card)iterator.next();
            if (card.isExpired()) continue;
            iterator.remove();
        }
        return list;
    }

    public List getExpiredCards(int n) {
        List list = this.getCards(n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Card card = (Card)iterator.next();
            if (card.isExpired()) continue;
            iterator.remove();
        }
        return list;
    }

    public List getLearnedCards() {
        List list = this.getCards();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Card card = (Card)iterator.next();
            if (card.isLearned()) continue;
            iterator.remove();
        }
        return list;
    }

    public List getLearnedCards(int n) {
        if (n == 0) {
            return new ArrayList();
        }
        List list = this.getCards(n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Card card = (Card)iterator.next();
            if (card.isLearned()) continue;
            iterator.remove();
        }
        return list;
    }

    public List getLearnableCards(int n) {
        return n == 0 ? this.getCards(0) : this.getExpiredCards(n);
    }

    public List getLearnableCards() {
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < this.getNumberOfDecks(); ++i) {
            linkedList.addAll(this.getLearnableCards(i));
        }
        return linkedList;
    }

    public List getUnlearnedCards() {
        return this.m_decks.size() > 0 ? this.getCards(0) : new ArrayList();
    }

    public List getLocalCards(int n) {
        return (List)this.m_decks.get(n);
    }

    public int getNumberOfDecks() {
        return this.m_decks.size();
    }

    public List getChildCategories() {
        return this.m_childCategories;
    }

    public Category addCategoryChild(Category category) {
        return this.addCategoryChild(this.m_childCategories.size(), category);
    }

    public Category addCategoryChild(int n, Category category) {
        category.m_father = this;
        category.m_depth = this.m_depth + 1;
        this.m_childCategories.add(n, category);
        this.fireCategoryEvent(0, category);
        return category;
    }

    public void remove() {
        if (!$assertionsDisabled && this.m_father == null) {
            throw new AssertionError((Object)"Root category cant be deleted");
        }
        this.m_father.m_childCategories.remove(this);
        this.fireCategoryEvent(1, this);
    }

    public boolean contains(Category category) {
        if (this == category) {
            return true;
        }
        Iterator iterator = this.m_childCategories.iterator();
        while (iterator.hasNext()) {
            Category category2 = (Category)iterator.next();
            if (!category2.contains(category)) continue;
            return true;
        }
        return false;
    }

    public Category getFather() {
        return this.m_father;
    }

    public void setName(String string) {
        this.m_name = string;
        this.fireCategoryEvent(3, this);
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        return this.m_father != null ? this.m_father.getPath() + "/" + this.getName() : this.getName();
    }

    public int getDepth() {
        return this.m_depth;
    }

    public List getSubtreeList() {
        ArrayList<Category> arrayList = new ArrayList<Category>(this.m_childCategories.size() + 1);
        arrayList.add(this);
        Iterator iterator = this.m_childCategories.iterator();
        while (iterator.hasNext()) {
            Category category = (Category)iterator.next();
            arrayList.addAll(category.getSubtreeList());
        }
        return arrayList;
    }

    public String toString() {
        return "Category(" + this.m_name + ")";
    }

    public void addObserver(CategoryObserver categoryObserver) {
        this.m_observers.add(categoryObserver);
    }

    public void removeObserver(CategoryObserver categoryObserver) {
        this.m_observers.remove(categoryObserver);
    }

    void fireCardEvent(int n, Card card, int n2) {
        if (n != 3) {
            this.adjustNumberOfDecks();
        }
        if (this.m_father != null) {
            this.m_father.fireCardEvent(n, card, n2);
        }
        ArrayList arrayList = new ArrayList(this.m_observers);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CategoryObserver categoryObserver = (CategoryObserver)iterator.next();
            categoryObserver.onCardEvent(n, card, n2);
        }
    }

    void fireCategoryEvent(int n, Category category) {
        this.adjustNumberOfDecks();
        if (this.m_father != null) {
            this.m_father.fireCategoryEvent(n, category);
        }
        ArrayList arrayList = new ArrayList(this.m_observers);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CategoryObserver categoryObserver = (CategoryObserver)iterator.next();
            categoryObserver.onCategoryEvent(n, category);
        }
    }

    private void addCardInternal(Card card, int n) {
        while (this.m_decks.size() <= n) {
            this.m_decks.add(new ArrayList());
        }
        List list = (List)this.m_decks.get(n);
        list.add(card);
        card.setCategory(this);
        card.setLevel(n);
    }

    private void removeCardInternal(Card card) {
        Category category = card.getCategory();
        if (category == this) {
            int n = card.getLevel();
            List list = (List)this.m_decks.get(n);
            list.remove(card);
            card.setCategory(null);
        } else {
            category.removeCardInternal(card);
        }
    }

    private void changeCardLevel(Card card, int n, Date date, Date date2) {
        Category category = card.getCategory();
        int n2 = card.getLevel();
        category.removeCardInternal(card);
        card.setDateTested(date);
        card.setDateExpired(date2);
        card.setDateTouched(new Date());
        category.addCardInternal(card, n);
        category.fireCardEvent(2, card, n2);
    }

    private void adjustNumberOfDecks() {
        int n = 0;
        Iterator iterator = this.m_childCategories.iterator();
        while (iterator.hasNext()) {
            Category category = (Category)iterator.next();
            if (category.getNumberOfDecks() <= n) continue;
            n = category.getNumberOfDecks();
        }
        while (n > this.getNumberOfDecks()) {
            this.m_decks.add(new ArrayList());
        }
        while (n < this.getNumberOfDecks() && ((List)this.m_decks.get(this.getNumberOfDecks() - 1)).isEmpty()) {
            this.m_decks.remove(this.getNumberOfDecks() - 1);
        }
    }

    static {
        $assertionsDisabled = !Category.class.desiredAssertionStatus();
    }
}

