/*
 * Decompiled with CFR 0.152.
 */
package jmemorize.core;

import java.util.Date;
import jmemorize.core.Category;
import jmemorize.core.Events;
import jmemorize.core.Main;

public class Card
implements Events,
Cloneable {
    public static final long ONE_DAY = 86400000L;
    private Category m_category;
    private int m_level;
    private String m_frontSide;
    private String m_backSide;
    private Date m_dateTested;
    private Date m_dateExpired;
    private Date m_dateCreated;
    private Date m_dateTouched;
    private int m_testsTotal;
    private int m_testsHit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Card(String string, String string2) throws IllegalArgumentException {
        this(new Date(), string, string2);
        if (string.length() == 0 || string2.length() == 0) {
            throw new IllegalArgumentException("String arguments can't have zero-length.");
        }
    }

    public Card(Date date, String string, String string2) {
        this.m_dateCreated = date;
        this.m_dateTouched = date;
        this.m_frontSide = string;
        this.m_backSide = string2;
    }

    public void setSides(String string, String string2) throws IllegalArgumentException {
        if (string.length() == 0 || string2.length() == 0) {
            throw new IllegalArgumentException("String arguments can't have zero-length.");
        }
        if (this.m_frontSide.equals(string) && this.m_backSide.equals(string2)) {
            return;
        }
        this.m_frontSide = string;
        this.m_backSide = string2;
        this.m_category.fireCardEvent(3, this, this.m_level);
    }

    public String getFrontSide() {
        return this.m_frontSide;
    }

    public String getBackSide() {
        return this.m_backSide;
    }

    public Date getDateTested() {
        return this.m_dateTested;
    }

    public void setDateTested(Date date) {
        this.m_dateTested = date;
        this.m_dateTouched = date;
    }

    public Date getDateExpired() {
        return this.m_dateExpired;
    }

    public void setDateExpired(Date date) {
        this.m_dateExpired = date;
    }

    public Date getDateCreated() {
        return this.m_dateCreated;
    }

    public void setDateCreated(Date date) {
        this.m_dateCreated = date;
    }

    public Date getDateTouched() {
        return this.m_dateTouched;
    }

    public void setDateTouched(Date date) {
        this.m_dateTouched = date;
    }

    public int getTestsTotal() {
        return this.m_testsTotal;
    }

    public int getTestsHit() {
        return this.m_testsHit;
    }

    public void incStats(int n, int n2) {
        this.m_testsTotal += n2;
        this.m_testsHit += n;
    }

    public void resetStats() {
        this.m_testsTotal = 0;
        this.m_testsHit = 0;
    }

    public Category getCategory() {
        return this.m_category;
    }

    void setCategory(Category category) {
        this.m_category = category;
    }

    public boolean isExpired() {
        return this.m_dateExpired != null && this.m_dateExpired.before(Main.getNow());
    }

    public boolean isLearned() {
        return this.m_dateExpired != null && this.m_dateExpired.after(Main.getNow());
    }

    public boolean isUnlearned() {
        if (!$assertionsDisabled && this.m_dateTested == null != (this.m_dateExpired == null)) {
            throw new AssertionError();
        }
        return this.m_dateExpired == null;
    }

    public int getLevel() {
        return this.m_level;
    }

    public void setLevel(int n) {
        this.m_level = n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "Card(" + this.m_frontSide + ")";
    }

    static {
        $assertionsDisabled = !Card.class.desiredAssertionStatus();
    }
}

