/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.Size;
import java.util.StringTokenizer;

public final class RowSpec
extends FormSpec {
    public static final FormSpec.DefaultAlignment TOP = FormSpec.TOP_ALIGN;
    public static final FormSpec.DefaultAlignment CENTER = FormSpec.CENTER_ALIGN;
    public static final FormSpec.DefaultAlignment BOTTOM = FormSpec.BOTTOM_ALIGN;
    public static final FormSpec.DefaultAlignment FILL = FormSpec.FILL_ALIGN;
    public static final FormSpec.DefaultAlignment DEFAULT = CENTER;

    public RowSpec(FormSpec.DefaultAlignment defaultAlignment, Size size, double resizeWeight) {
        super(defaultAlignment, size, resizeWeight);
    }

    public RowSpec(Size size) {
        super(DEFAULT, size, 0.0);
    }

    public RowSpec(String encodedDescription) {
        super(DEFAULT, encodedDescription);
    }

    protected final boolean isHorizontal() {
        return false;
    }

    public static RowSpec[] decodeSpecs(String encodedRowSpecs) {
        if (encodedRowSpecs == null) {
            throw new NullPointerException("The row description must not be null.");
        }
        StringTokenizer tokenizer = new StringTokenizer(encodedRowSpecs, ", ");
        int rowCount = tokenizer.countTokens();
        RowSpec[] rowSpecs = new RowSpec[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rowSpecs[i] = new RowSpec(tokenizer.nextToken());
        }
        return rowSpecs;
    }
}

