#include <stdio.h>
#include <stdarg.h>
#include <process.h>
#include <dos.h>
#include <errno.h>

char * xmalloc(int size)
{
  char * res;
  extern char * malloc();

  res = malloc(size);
  if (res == NULL) {
    fprintf(stderr, "Out of memory\n");
    exit(2);
  }
  return res;
}

int suffix(char * name, char * suff)
{
  int lname = strlen(name);
  int lsuff = strlen(suff);

  return lname >= lsuff && strcmp(name + lname - lsuff, suff) == 0;
}

int prefix(char * name, char * pref)
{
  return strncmp(name, pref, strlen(pref)) == 0;
}

void format(char ** res, char * fmt, ...)
{
  va_list ap;
  char buffer[1024];
  
  va_start(ap, fmt);
  vsprintf(buffer, fmt, ap);
  *res = xmalloc(strlen(buffer) + 1);
  strcpy(*res, buffer);
}

void reformat(char ** res, char * fmt, ...)
{
  va_list ap;
  char buffer[1024];
  
  if (**res != 0) free(*res);
  va_start(ap, fmt);
  vsprintf(buffer, fmt, ap);
  *res = xmalloc(strlen(buffer) + 1);
  strcpy(*res, buffer);
}

int callcmd(char * cmd, char * args, int mode)
{
  int retcode;
#ifdef DEBUG
  fprintf(stderr, "\t%s %s\n", cmd, args);
#endif
  if (strlen(cmd) + 1 + strlen(args) < 128) {
    retcode = spawnlp(mode, cmd, cmd, args, NULL);
  } else {
    int n;
    char ** env;
    for (n = 0; environ[n] != NULL; n++) /*nothing*/;
    env = (char **) xmalloc((n + 2) * sizeof(char *));
    env[n+1] = NULL;
    for (n = 0; environ[n] != NULL; n++) env[n+1] = environ[n];
    env[0] = xmalloc(strlen(args) + 2 + 1);
    strcpy(env[0], "*=");
    strcat(env[0], args);
    retcode = spawnlpe(mode, cmd, cmd, NULL, env);
    free(env[0]);
    free(env);
  }
  if (retcode == -1) {
    perror(cmd);
    exit(2);
  }
  return retcode;
}

int execute(char * cmd, char * args)
{
  return callcmd(cmd, args, P_WAIT);
}

void terminate(char * cmd, char * args)
{
  (void) callcmd(cmd, args, P_OVERLAY);
}
