/* THIS FILE IS AUTOGENERATED FROM MozMobileMessageManager.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MozMobileMessageManagerBinding_h
#define mozilla_dom_MozMobileMessageManagerBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/File.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Blob;
struct MmsAttachment;
struct MmsAttachmentAtoms;
class MmsMessage;
struct MmsParametersAtoms;
struct MmsSendParametersAtoms;
struct MobileMessageFilterAtoms;
class MobileMessageManager;
struct MobileMessageManagerAtoms;
struct NativePropertyHooks;
class OwningLongOrSmsMessageOrMmsMessage;
class ProtoAndIfaceCache;
class SmsMessage;
struct SmsSegmentInfoAtoms;
struct SmsSendParametersAtoms;
struct SmscAddressAtoms;
struct TypeOfAddress;
struct TypeOfAddressAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class MobileMessageFilterDelivery : uint32_t {
  Sent,
  Received,
  EndGuard_
};

namespace MobileMessageFilterDeliveryValues {
extern const EnumEntry strings[3];
} // namespace MobileMessageFilterDeliveryValues

bool
ToJSValue(JSContext* aCx, MobileMessageFilterDelivery aArgument, JS::MutableHandle<JS::Value> aValue);


enum class TypeOfNumber : uint32_t {
  Unknown,
  International,
  National,
  Network_specific,
  Dedicated_access_short_code,
  EndGuard_
};

namespace TypeOfNumberValues {
extern const EnumEntry strings[6];
} // namespace TypeOfNumberValues

bool
ToJSValue(JSContext* aCx, TypeOfNumber aArgument, JS::MutableHandle<JS::Value> aValue);


enum class NumberPlanIdentification : uint32_t {
  Unknown,
  Isdn,
  Data,
  Telex,
  National,
  Private,
  EndGuard_
};

namespace NumberPlanIdentificationValues {
extern const EnumEntry strings[7];
} // namespace NumberPlanIdentificationValues

bool
ToJSValue(JSContext* aCx, NumberPlanIdentification aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningLongOrSmsMessageOrMmsMessage& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningLongOrSmsMessageOrMmsMessage& aUnion);


class LongOrSmsMessageOrMmsMessage
{
  friend class LongOrSmsMessageOrMmsMessageArgument;
  enum Type
  {
    eUninitialized,
    eLong,
    eSmsMessage,
    eMmsMessage
  };

  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<NonNull<mozilla::dom::SmsMessage> > mSmsMessage;
    UnionMember<NonNull<mozilla::dom::MmsMessage> > mMmsMessage;

  };

  Type mType;
  Value mValue;

  LongOrSmsMessageOrMmsMessage(const LongOrSmsMessageOrMmsMessage&) = delete;
  void operator=(const LongOrSmsMessageOrMmsMessage) = delete;
public:
  explicit inline LongOrSmsMessageOrMmsMessage()
    : mType(eUninitialized)
  {
  }

  inline ~LongOrSmsMessageOrMmsMessage()
  {
    Uninit();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline NonNull<mozilla::dom::SmsMessage>&
  RawSetAsSmsMessage()
  {
    if (mType == eSmsMessage) {
      return mValue.mSmsMessage.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSmsMessage;
    return mValue.mSmsMessage.SetValue();
  }

  inline NonNull<mozilla::dom::SmsMessage>&
  SetAsSmsMessage()
  {
    if (mType == eSmsMessage) {
      return mValue.mSmsMessage.Value();
    }
    Uninit();
    mType = eSmsMessage;
    return mValue.mSmsMessage.SetValue();
  }

  inline bool
  IsSmsMessage() const
  {
    return mType == eSmsMessage;
  }

  inline NonNull<mozilla::dom::SmsMessage>&
  GetAsSmsMessage()
  {
    MOZ_ASSERT(IsSmsMessage(), "Wrong type!");
    return mValue.mSmsMessage.Value();
  }

  inline mozilla::dom::SmsMessage&
  GetAsSmsMessage() const
  {
    MOZ_ASSERT(IsSmsMessage(), "Wrong type!");
    return mValue.mSmsMessage.Value();
  }

  inline NonNull<mozilla::dom::MmsMessage>&
  RawSetAsMmsMessage()
  {
    if (mType == eMmsMessage) {
      return mValue.mMmsMessage.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMmsMessage;
    return mValue.mMmsMessage.SetValue();
  }

  inline NonNull<mozilla::dom::MmsMessage>&
  SetAsMmsMessage()
  {
    if (mType == eMmsMessage) {
      return mValue.mMmsMessage.Value();
    }
    Uninit();
    mType = eMmsMessage;
    return mValue.mMmsMessage.SetValue();
  }

  inline bool
  IsMmsMessage() const
  {
    return mType == eMmsMessage;
  }

  inline NonNull<mozilla::dom::MmsMessage>&
  GetAsMmsMessage()
  {
    MOZ_ASSERT(IsMmsMessage(), "Wrong type!");
    return mValue.mMmsMessage.Value();
  }

  inline mozilla::dom::MmsMessage&
  GetAsMmsMessage() const
  {
    MOZ_ASSERT(IsMmsMessage(), "Wrong type!");
    return mValue.mMmsMessage.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
      case eSmsMessage: {
        DestroySmsMessage();
        break;
      }
      case eMmsMessage: {
        DestroyMmsMessage();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyLong()
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroySmsMessage()
  {
    MOZ_ASSERT(IsSmsMessage(), "Wrong type!");
    mValue.mSmsMessage.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyMmsMessage()
  {
    MOZ_ASSERT(IsMmsMessage(), "Wrong type!");
    mValue.mMmsMessage.Destroy();
    mType = eUninitialized;
  }
};


class OwningLongOrSmsMessageOrMmsMessage : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningLongOrSmsMessageOrMmsMessage& aUnion);
  enum Type
  {
    eUninitialized,
    eLong,
    eSmsMessage,
    eMmsMessage
  };

  union Value
  {
    UnionMember<int32_t > mLong;
    UnionMember<OwningNonNull<mozilla::dom::SmsMessage> > mSmsMessage;
    UnionMember<OwningNonNull<mozilla::dom::MmsMessage> > mMmsMessage;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningLongOrSmsMessageOrMmsMessage()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningLongOrSmsMessageOrMmsMessage(const OwningLongOrSmsMessageOrMmsMessage& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningLongOrSmsMessageOrMmsMessage()
  {
    Uninit();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  OwningNonNull<mozilla::dom::SmsMessage>&
  RawSetAsSmsMessage();

  OwningNonNull<mozilla::dom::SmsMessage>&
  SetAsSmsMessage();

  bool
  TrySetToSmsMessage(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsSmsMessage() const
  {
    return mType == eSmsMessage;
  }

  inline OwningNonNull<mozilla::dom::SmsMessage>&
  GetAsSmsMessage()
  {
    MOZ_ASSERT(IsSmsMessage(), "Wrong type!");
    return mValue.mSmsMessage.Value();
  }

  inline OwningNonNull<mozilla::dom::SmsMessage> const &
  GetAsSmsMessage() const
  {
    MOZ_ASSERT(IsSmsMessage(), "Wrong type!");
    return mValue.mSmsMessage.Value();
  }

  OwningNonNull<mozilla::dom::MmsMessage>&
  RawSetAsMmsMessage();

  OwningNonNull<mozilla::dom::MmsMessage>&
  SetAsMmsMessage();

  bool
  TrySetToMmsMessage(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMmsMessage() const
  {
    return mType == eMmsMessage;
  }

  inline OwningNonNull<mozilla::dom::MmsMessage>&
  GetAsMmsMessage()
  {
    MOZ_ASSERT(IsMmsMessage(), "Wrong type!");
    return mValue.mMmsMessage.Value();
  }

  inline OwningNonNull<mozilla::dom::MmsMessage> const &
  GetAsMmsMessage() const
  {
    MOZ_ASSERT(IsMmsMessage(), "Wrong type!");
    return mValue.mMmsMessage.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningLongOrSmsMessageOrMmsMessage& aOther);

private:
  void
  DestroyLong();

  void
  DestroySmsMessage();

  void
  DestroyMmsMessage();
};


struct MmsAttachment : public DictionaryBase
{
  RefPtr<mozilla::dom::Blob> mContent;
  nsString mId;
  nsString mLocation;

  MmsAttachment();

  explicit inline MmsAttachment(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MmsAttachment(const MmsAttachment& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MmsAttachment& aOther);

private:
  static bool
  InitIds(JSContext* cx, MmsAttachmentAtoms* atomsCache);
};

namespace binding_detail {
struct FastMmsAttachment : public MmsAttachment
{
  inline FastMmsAttachment()
    : MmsAttachment(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MmsSendParameters : public DictionaryBase
{
  Optional<uint32_t> mServiceId;

  MmsSendParameters();

  explicit inline MmsSendParameters(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MmsSendParameters(const MmsSendParameters& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MmsSendParameters& aOther);

private:
  static bool
  InitIds(JSContext* cx, MmsSendParametersAtoms* atomsCache);
};

namespace binding_detail {
struct FastMmsSendParameters : public MmsSendParameters
{
  inline FastMmsSendParameters()
    : MmsSendParameters(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MobileMessageFilter : public DictionaryBase
{
  Nullable<MobileMessageFilterDelivery> mDelivery;
  Nullable<uint64_t> mEndDate;
  Nullable<Sequence<nsString>> mNumbers;
  Nullable<bool> mRead;
  Nullable<uint64_t> mStartDate;
  Nullable<uint64_t> mThreadId;

  MobileMessageFilter();

  explicit inline MobileMessageFilter(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MobileMessageFilter(const MobileMessageFilter& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MobileMessageFilter& aOther);

private:
  static bool
  InitIds(JSContext* cx, MobileMessageFilterAtoms* atomsCache);
};

namespace binding_detail {
struct FastMobileMessageFilter : public MobileMessageFilter
{
  inline FastMobileMessageFilter()
    : MobileMessageFilter(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SmsSegmentInfo : public DictionaryBase
{
  int32_t mCharsAvailableInLastSegment;
  int32_t mCharsPerSegment;
  int32_t mSegments;

  SmsSegmentInfo();

  explicit inline SmsSegmentInfo(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline SmsSegmentInfo(const SmsSegmentInfo& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const SmsSegmentInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, SmsSegmentInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastSmsSegmentInfo : public SmsSegmentInfo
{
  inline FastSmsSegmentInfo()
    : SmsSegmentInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SmsSendParameters : public DictionaryBase
{
  Optional<uint32_t> mServiceId;

  SmsSendParameters();

  explicit inline SmsSendParameters(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline SmsSendParameters(const SmsSendParameters& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const SmsSendParameters& aOther);

private:
  static bool
  InitIds(JSContext* cx, SmsSendParametersAtoms* atomsCache);
};

namespace binding_detail {
struct FastSmsSendParameters : public SmsSendParameters
{
  inline FastSmsSendParameters()
    : SmsSendParameters(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct TypeOfAddress : public DictionaryBase
{
  NumberPlanIdentification mNumberPlanIdentification;
  TypeOfNumber mTypeOfNumber;

  TypeOfAddress();

  explicit inline TypeOfAddress(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline TypeOfAddress(const TypeOfAddress& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const TypeOfAddress& aOther);

private:
  static bool
  InitIds(JSContext* cx, TypeOfAddressAtoms* atomsCache);
};

namespace binding_detail {
struct FastTypeOfAddress : public TypeOfAddress
{
  inline FastTypeOfAddress()
    : TypeOfAddress(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MmsParameters : public DictionaryBase
{
  Optional<Sequence<MmsAttachment>> mAttachments;
  Optional<Sequence<nsString>> mReceivers;
  nsString mSmil;
  nsString mSubject;

  MmsParameters();

  explicit inline MmsParameters(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MmsParameters(const MmsParameters& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MmsParameters& aOther);

private:
  static bool
  InitIds(JSContext* cx, MmsParametersAtoms* atomsCache);
};

namespace binding_detail {
struct FastMmsParameters : public MmsParameters
{
  inline FastMmsParameters()
    : MmsParameters(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SmscAddress : public DictionaryBase
{
  Optional<nsString> mAddress;
  TypeOfAddress mTypeOfAddress;

  SmscAddress();

  explicit inline SmscAddress(const FastDictionaryInitializer& )
    : mTypeOfAddress(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline SmscAddress(const SmscAddress& aOther)
    : mTypeOfAddress(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const SmscAddress& aOther);

private:
  static bool
  InitIds(JSContext* cx, SmscAddressAtoms* atomsCache);
};

namespace binding_detail {
struct FastSmscAddress : public SmscAddress
{
  inline FastSmscAddress()
    : SmscAddress(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MozMobileMessageManagerBinding {

  typedef mozilla::dom::MobileMessageManager NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MobileMessageManager* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozMobileMessageManagerBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MozMobileMessageManagerBinding_h
